/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data.types;

import com.nokia.helium.ant.data.PropertyMeta;
import com.nokia.helium.ant.data.types.AntLintCheck;
import com.nokia.helium.ant.data.types.LintIssue;
import java.io.IOException;
import java.util.List;

public class WrongTypePropertyCheck
extends AntLintCheck {
    public static final String DESCRIPTION = "Property value does not match type";

    @Override
    public void run() throws IOException {
        List<PropertyMeta> properties = this.getDb().getProperties();
        this.log("Properties total: " + properties.size(), 4);
        for (PropertyMeta propertyMeta : properties) {
            String type = propertyMeta.getType();
            String value = propertyMeta.getValue();
            if (value != null) {
                this.log("Testing for wrong type: " + propertyMeta.getName() + ", type: " + type, 4);
                if (!type.equals("integer")) continue;
                try {
                    Integer.decode(value);
                }
                catch (NumberFormatException e) {
                    this.getTask().addLintIssue(new LintIssue(DESCRIPTION, this.getSeverity(), propertyMeta.getLocation()));
                }
                continue;
            }
            this.log("Testing for wrong type: " + propertyMeta.getName() + ": value cannot be found", 4);
        }
    }
}

