/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.sysdef.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractSydefTask
extends Task
implements ErrorListener {
    private File srcFile;
    private File destFile;
    private File epocroot;
    private boolean failOnError = true;

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File srcfile) {
        this.srcFile = srcfile;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destfile) {
        this.destFile = destfile;
    }

    public File getEpocroot() {
        if (this.epocroot == null) {
            if (System.getenv("EPOCROOT") != null) {
                return new File(System.getenv("EPOCROOT"));
            }
            throw new BuildException("'epocroot' attribute has not been defined.");
        }
        return this.epocroot;
    }

    public void setEpocroot(File epocroot) {
        this.epocroot = epocroot;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failonerror) {
        this.failOnError = failonerror;
    }

    abstract File getXsl();

    protected void check() {
        if (this.srcFile == null) {
            throw new BuildException("'srcfile' attribute is not defined");
        }
        if (this.destFile == null) {
            throw new BuildException("'destfile' attribute is not defined");
        }
        File xslt = this.getXsl();
        if (!xslt.exists()) {
            throw new BuildException("Could not find " + xslt);
        }
        if (!this.srcFile.exists()) {
            throw new BuildException("Could not find source file " + this.srcFile);
        }
    }

    public void transform(Map<String, String> data) {
        this.check();
        if (this.destFile.exists()) {
            this.log("Deleting previous output file: " + this.destFile, 4);
            this.destFile.delete();
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.destFile);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(this.getXsl()));
            transformer.setParameter("path", this.srcFile);
            for (Map.Entry<String, String> entry : data.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            transformer.setErrorListener(this);
            transformer.transform(new StreamSource(this.srcFile), new StreamResult(output));
        }
        catch (Exception exc) {
            if (this.destFile.exists()) {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException ioe) {
                    this.log(ioe, 4);
                }
                this.log("Deleting " + this.destFile + " because an error occured.", 2);
                this.destFile.delete();
            }
            throw new BuildException(exc.toString());
        }
    }

    @Override
    public void error(TransformerException message) throws TransformerException {
        if (this.isFailOnError()) {
            throw message;
        }
        this.log("ERROR: " + message.getMessageAndLocation(), 0);
    }

    @Override
    public void fatalError(TransformerException message) throws TransformerException {
        this.log("ERROR: " + message.getMessageAndLocation(), 0);
        throw message;
    }

    @Override
    public void warning(TransformerException message) throws TransformerException {
        if (this.isFailOnError()) {
            throw message;
        }
        this.log("WARNING: " + message.getMessageAndLocation(), 1);
    }
}

