/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.util.WikiTagNode;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateParser
extends AbstractParser {
    public final boolean fParseOnlySignature;
    private final boolean fRenderTemplate;

    public TemplateParser(String stringSource) {
        this(stringSource, false, false);
    }

    public TemplateParser(String stringSource, boolean parseOnlySignature, boolean renderTemplate) {
        super(stringSource);
        this.fParseOnlySignature = parseOnlySignature;
        this.fRenderTemplate = renderTemplate;
    }

    public static void parse(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean renderTemplate) throws IOException {
        TemplateParser.parse(rawWikitext, wikiModel, writer, false, renderTemplate);
    }

    public static void parse(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean parseOnlySignature, boolean renderTemplate) throws IOException {
        TemplateParser.parseRecursive(rawWikitext, wikiModel, writer, parseOnlySignature, renderTemplate, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void parseRecursive(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean parseOnlySignature, boolean renderTemplate, HashMap<String, String> templateParameterMap) throws IOException {
        try {
            int level = wikiModel.incrementRecursionLevel();
            if (level > 25) {
                writer.append("Error - recursion limit exceeded parsing templates.");
                return;
            }
            try {
                String preprocessedContent;
                WikipediaScanner scanner;
                TemplateParser parser = new TemplateParser(rawWikitext, false, renderTemplate);
                parser.setModel(wikiModel);
                StringBuilder sb = new StringBuilder(rawWikitext.length());
                parser.runPreprocessParser(sb);
                StringBuilder plainBuffer = sb;
                if (templateParameterMap != null && !templateParameterMap.isEmpty() && (plainBuffer = (scanner = new WikipediaScanner(preprocessedContent = sb.toString())).replaceTemplateParameters(preprocessedContent, templateParameterMap)) == null) {
                    plainBuffer = sb;
                }
                parser.initialize(plainBuffer.toString());
                parser.runParser(writer);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                writer.append(e.getClass().getSimpleName());
                return;
            }
            catch (Error e) {
                e.printStackTrace();
                writer.append(e.getClass().getSimpleName());
                return;
            }
        }
        finally {
            wikiModel.decrementRecursionLevel();
        }
    }

    protected void runPreprocessParser(Appendable writer) throws IOException {
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
        try {
            block7: while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                switch (this.fCurrentCharacter) {
                    case '<': {
                        int htmlStartPosition = this.fCurrentPosition;
                        if (!this.fParseOnlySignature && this.parseIncludeWikiTags(writer)) continue block7;
                        this.fCurrentPosition = htmlStartPosition;
                    }
                }
                if (this.fWhiteStart) continue;
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition - 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                // empty catch block
            }
            return;
        }
    }

    protected void runParser(Appendable writer) throws IOException {
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
        try {
            block11: while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                switch (this.fCurrentCharacter) {
                    case '{': {
                        if (this.fParseOnlySignature || !this.parseTemplate(writer)) break;
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                        continue block11;
                    }
                    case '<': {
                        int htmlStartPosition = this.fCurrentPosition;
                        if (!this.fParseOnlySignature && this.parseSpecialWikiTags(writer)) continue block11;
                        this.fCurrentPosition = htmlStartPosition;
                        break;
                    }
                    case '~': {
                        int tildeCounter = 0;
                        if (this.fSource[this.fCurrentPosition] != '~' || this.fSource[this.fCurrentPosition + 1] != '~') break;
                        tildeCounter = 3;
                        try {
                            if (this.fSource[this.fCurrentPosition + 2] == '~') {
                                tildeCounter = 4;
                                if (this.fSource[this.fCurrentPosition + 3] == '~') {
                                    tildeCounter = 5;
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1);
                        this.fWikiModel.appendSignature(writer, tildeCounter);
                        this.fCurrentPosition += tildeCounter - 1;
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                    }
                }
                if (this.fWhiteStart) continue;
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition - 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parseIncludeWikiTags(Appendable writer) throws IOException {
        try {
            switch (this.fSource[this.fCurrentPosition]) {
                case '!': {
                    if (!this.parseHTMLCommentTags(writer)) return false;
                    return true;
                }
                default: {
                    if (this.fSource[this.fCurrentPosition] == '/') return false;
                    int lessThanStart = this.fCurrentPosition - 1;
                    WikiTagNode tagNode = this.parseTag(this.fCurrentPosition);
                    if (tagNode == null) return false;
                    int tagStart = this.fCurrentPosition = tagNode.getEndPosition();
                    String tagName = tagNode.getTagName();
                    if (tagName.equals("nowiki") ? this.readUntilIgnoreCase("</", "nowiki>") : (tagName.equals("source") ? this.readUntilIgnoreCase("</", "source>") : tagName.equals("math") && this.readUntilIgnoreCase("</", "math>"))) {
                        return true;
                    }
                    if (!this.isTemplate()) {
                        if (tagName.equals("includeonly")) {
                            if (!this.readUntilIgnoreCase("</", "includeonly>")) return false;
                            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart);
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = tagStart;
                            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 2 + "includeonly>".length());
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = this.fCurrentPosition;
                            return true;
                        } else {
                            if (!tagName.equals("noinclude") || !this.readUntilIgnoreCase("</", "noinclude>")) return false;
                            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart);
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = this.fCurrentPosition;
                            return true;
                        }
                    }
                    if (tagName.equals("noinclude")) {
                        if (!this.readUntilIgnoreCase("</", "noinclude>")) return false;
                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart);
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = tagStart;
                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 2 + "noinclude>".length());
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                        return true;
                    } else {
                        if (!tagName.equals("includeonly") || !this.readUntilIgnoreCase("</", "includeonly>")) return false;
                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart);
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                        return true;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parseSpecialWikiTags(Appendable writer) throws IOException {
        try {
            switch (this.fSource[this.fCurrentPosition]) {
                case '!': {
                    if (!this.parseHTMLCommentTags(writer)) return false;
                    return true;
                }
                default: {
                    WikiTagNode tagNode;
                    if (this.fSource[this.fCurrentPosition] == '/' || (tagNode = this.parseTag(this.fCurrentPosition)) == null) return false;
                    this.fCurrentPosition = tagNode.getEndPosition();
                    String tagName = tagNode.getTagName();
                    if (!(tagName.equals("nowiki") ? this.readUntilIgnoreCase("</", "nowiki>") : (tagName.equals("source") ? this.readUntilIgnoreCase("</", "source>") : tagName.equals("math") && this.readUntilIgnoreCase("</", "math>")))) return false;
                    return true;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    protected void appendContent(Appendable writer, boolean whiteStart, int whiteStartPosition, int diff) throws IOException {
        if (whiteStart) {
            try {
                int whiteEndPosition = this.fCurrentPosition - diff;
                int count = whiteEndPosition - whiteStartPosition;
                if (count > 0) {
                    writer.append(this.fStringSource, whiteStartPosition, whiteEndPosition);
                }
            }
            finally {
                this.fWhiteStart = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseTemplate(Appendable writer) throws IOException {
        if (this.fSource[this.fCurrentPosition] != '{') return false;
        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1);
        int startTemplatePosition = ++this.fCurrentPosition;
        if (this.fSource[this.fCurrentPosition] != '{') {
            int templateEndPosition = this.findTemplateEnd(this.fSource, this.fCurrentPosition);
            if (templateEndPosition < 0) {
                --this.fCurrentPosition;
                return false;
            }
            int endPosition = this.fCurrentPosition = templateEndPosition;
            String plainContent = null;
            int endOffset = this.fCurrentPosition - 2;
            String function = this.checkParserFunction(startTemplatePosition, endOffset);
            if (function != null) {
                ITemplateFunction templateFunction = this.fWikiModel.getTemplateFunction(function.toLowerCase());
                if (templateFunction != null) {
                    plainContent = templateFunction.parseFunction(this.fSource, this.fCurrentPosition, endOffset, this.fWikiModel);
                    this.fCurrentPosition = endPosition;
                    if (plainContent == null) return true;
                    TemplateParser.parseRecursive(plainContent, this.fWikiModel, writer, false, false, null);
                    return true;
                }
                this.fCurrentPosition = endOffset + 2;
            }
            Object[] objs = TemplateParser.createParameterMap(this.fSource, startTemplatePosition, this.fCurrentPosition - startTemplatePosition - 2);
            HashMap map = (HashMap)objs[0];
            String templateName = ((String)objs[1]).trim();
            if (templateName.length() > 0 && templateName.charAt(0) == ':') {
                plainContent = this.fWikiModel.getRawWikiContent("", templateName.substring(1), map);
            } else {
                this.fWikiModel.addTemplate(templateName);
                plainContent = this.fWikiModel.getRawWikiContent(this.fWikiModel.getTemplateNamespace(), templateName, map);
            }
            this.fCurrentPosition = endPosition;
            if (plainContent != null) {
                TemplateParser.parseRecursive(plainContent.trim(), this.fWikiModel, writer, false, false, map);
                return true;
            }
            writer.append("{{" + templateName + "}}");
            return true;
        }
        int templateEndPosition = this.findTemplateParameterEnd(this.fCurrentPosition + 1);
        if (templateEndPosition <= 0) {
            --this.fCurrentPosition;
            return false;
        }
        String plainContent = new String(this.fSource, startTemplatePosition - 2, templateEndPosition - startTemplatePosition + 2);
        if (plainContent == null) return false;
        this.fCurrentPosition = templateEndPosition;
        WikipediaScanner scanner = new WikipediaScanner(plainContent);
        StringBuilder plainBuffer = scanner.replaceTemplateParameters(plainContent, null);
        if (plainBuffer == null) {
            writer.append(plainContent);
            return true;
        }
        TemplateParser.parseRecursive(plainBuffer.toString().trim(), this.fWikiModel, writer, false, false, null);
        return true;
    }

    private static Object[] createParameterMap(char[] src, int startOffset, int len) {
        HashMap<String, String> map;
        Object[] objs = new Object[2];
        objs[0] = map = new HashMap<String, String>();
        int currOffset = startOffset;
        int endOffset = startOffset + len;
        List<String> resultList = new ArrayList<String>();
        if ((resultList = TemplateParser.splitByPipe(src, currOffset, endOffset, resultList)).size() <= 1) {
            objs[1] = new String(src, startOffset, len);
            return objs;
        }
        objs[1] = resultList.get(0);
        int i = 1;
        while (i < resultList.size()) {
            TemplateParser.createSingleParameter(i, resultList.get(i).toCharArray(), map);
            ++i;
        }
        return objs;
    }

    private static void createSingleParameter(int parameterCounter, char[] src, HashMap<String, String> map) {
        int currOffset = 0;
        int endOffset = src.length;
        String parameter = null;
        boolean equalCharParsed = false;
        int lastOffset = currOffset;
        try {
            try {
                while (currOffset < endOffset) {
                    int temp;
                    char ch;
                    if ((ch = src[currOffset++]) == '[' && src[currOffset] == '[') {
                        if ((temp = TemplateParser.findNestedEnd(src, '[', ']', ++currOffset)) < 0) continue;
                        currOffset = temp;
                        continue;
                    }
                    if (ch == '{' && src[currOffset] == '{') {
                        if (src[++currOffset] == '{') {
                            if ((temp = TemplateParser.findNestedParamEnd(src, ++currOffset)) >= 0) {
                                currOffset = temp;
                                continue;
                            }
                            if ((temp = TemplateParser.findNestedTemplateEnd(src, --currOffset)) < 0) continue;
                            currOffset = temp;
                            continue;
                        }
                        temp = TemplateParser.findNestedTemplateEnd(src, currOffset);
                        if (temp < 0) continue;
                        currOffset = temp;
                        continue;
                    }
                    if (ch != '=') continue;
                    if (!equalCharParsed) {
                        parameter = new String(src, lastOffset, currOffset - lastOffset - 1).trim();
                        lastOffset = currOffset;
                    }
                    equalCharParsed = true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (currOffset > lastOffset) {
                    String value = new String(src, lastOffset, currOffset - lastOffset).trim();
                    map.put(Integer.toString(parameterCounter), value);
                    if (parameter != null) {
                        map.put(parameter, value);
                    }
                }
            }
        }
        finally {
            if (currOffset > lastOffset) {
                String value = new String(src, lastOffset, currOffset - lastOffset).trim();
                map.put(Integer.toString(parameterCounter), value);
                if (parameter != null) {
                    map.put(parameter, value);
                }
            }
        }
    }

    private String checkParserFunction(int startOffset, int endOffset) {
        int currOffset = startOffset;
        int functionStart = startOffset;
        while (currOffset < endOffset) {
            char ch;
            if (Character.isWhitespace(ch = this.fSource[currOffset++])) continue;
            functionStart = currOffset - 1;
            while (currOffset < endOffset) {
                if ((ch = this.fSource[currOffset++]) != ':') continue;
                this.fCurrentPosition = currOffset;
                return new String(this.fSource, functionStart, currOffset - functionStart - 1);
            }
            break block0;
        }
        return null;
    }

    protected boolean parseHTMLCommentTags(Appendable writer) throws IOException {
        int temp = this.readWhitespaceUntilStartOfLine(2);
        String htmlCommentString = new String(this.fSource, this.fCurrentPosition - 1, 4);
        if (htmlCommentString.equals("<!--")) {
            if (temp >= 0) {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - temp - 1);
            } else {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1);
            }
            this.fCurrentPosition += 3;
            if (this.readUntil("-->")) {
                if (temp >= 0 && (temp = this.readWhitespaceUntilEndOfLine(0)) >= 0) {
                    ++this.fCurrentPosition;
                }
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition;
                return true;
            }
        }
        return false;
    }

    @Override
    public void runParser() {
    }

    @Override
    public void setNoToC(boolean noToC) {
    }

    public boolean isTemplate() {
        return this.fRenderTemplate;
    }
}

