/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.jpa.entity.metadata;

import com.nokia.helium.jpa.ORMCommitCount;
import com.nokia.helium.jpa.ORMEntityManager;
import com.nokia.helium.jpa.entity.metadata.Component;
import com.nokia.helium.jpa.entity.metadata.ComponentTime;
import com.nokia.helium.jpa.entity.metadata.LogFile;
import com.nokia.helium.jpa.entity.metadata.MetadataEntry;
import com.nokia.helium.jpa.entity.metadata.Priority;
import com.nokia.helium.jpa.entity.metadata.WhatLogEntry;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.FlushModeType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKeyColumn;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import org.apache.log4j.Logger;

@Entity
public class Metadata {
    private static Logger log = Logger.getLogger(Metadata.class);
    private static String[] priorityNames = new String[]{"FATAL", "ERROR", "WARNING", "INFO", "REAMARK", "CRITICAL", "DEFAULT"};
    private transient ORMEntityManager manager;
    private transient String logPath;
    @Basic
    @Column(unique=true, nullable=false)
    private String name;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    private int id;
    @OneToMany(mappedBy="metadata", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Hashtable<String, LogFile> logFiles;
    @OneToMany(mappedBy="metadata", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @MapKeyColumn(name="PRIORITY", insertable=false, updatable=false)
    private Hashtable<String, Priority> priorities;
    private Hashtable<String, Component> components;
    private List<MetadataEntry> entries;

    public Metadata() {
    }

    public Metadata(String nm) {
        this.name = nm;
    }

    public Metadata(ORMEntityManager mgr, String path) {
        this.manager = mgr;
        if (this.logPath == null) {
            this.logPath = path;
            this.initializeLogPath();
        }
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable<String, LogFile> getLogFiles() {
        return this.logFiles;
    }

    public void setComponents(Hashtable<String, Component> componentsList) {
        this.components = componentsList;
    }

    public void setLogFiles(Hashtable<String, LogFile> logFilesList) {
        this.logFiles = logFilesList;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setEntries(List<MetadataEntry> entriesList) {
        this.entries = entriesList;
    }

    public List<MetadataEntry> getEntries() {
        return this.entries;
    }

    public void setLogPath(String path) {
        this.logPath = path;
    }

    public void setPriorities(Hashtable<String, Priority> prtList) {
        this.priorities = prtList;
    }

    public void initComponents(String path, LogFile logFile) {
        this.logPath = path;
        this.components = new Hashtable();
        if (logFile != null) {
            List componentList = this.manager.getEntityManager().createQuery("SELECT c FROM Component c WHERE c.logPathID = :pathId").setParameter("pathId", (Object)logFile.getId()).getResultList();
            for (Component comp : componentList) {
                this.components.put(comp.getComponent(), comp);
            }
        }
    }

    public void initPriorities() {
        this.priorities = new Hashtable();
        List priorityList = this.manager.getEntityManager().createQuery("SELECT p FROM Priority p").getResultList();
        for (Priority priority : priorityList) {
            this.priorities.put(priority.getPriority(), priority);
        }
    }

    private void loadFromDB(String path) {
        LogFile logFile = null;
        this.logFiles = new Hashtable();
        List logFilesList = this.manager.getEntityManager().createQuery("SELECT l FROM LogFile l").getResultList();
        for (LogFile file : logFilesList) {
            log.debug((Object)("getting logfile from db: " + file.getPath()));
            this.logFiles.put(file.getPath(), file);
        }
        logFile = this.logFiles.get(path);
        if (logFile == null) {
            this.populateDB(path);
        } else {
            this.initComponents(path, logFile);
            ArrayList<MetadataEntry> entriesList = new ArrayList<MetadataEntry>();
            this.setEntries(entriesList);
        }
        this.initPriorities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(Object obj) {
        ORMEntityManager oRMEntityManager = this.manager;
        synchronized (oRMEntityManager) {
            EntityManager em = this.manager.getEntityManager();
            ORMCommitCount countObject = this.manager.getCommitCountObject();
            em.persist(obj);
            countObject.decreaseCount();
            if (countObject.isCommitRequired()) {
                countObject.reset();
                em.getTransaction().commit();
                em.clear();
                em.getTransaction().begin();
            }
        }
    }

    private void populatePriorities() {
        Hashtable<String, Priority> priorityList = new Hashtable<String, Priority>();
        this.setPriorities(priorityList);
        for (String priorityName : priorityNames) {
            Priority priority = new Priority();
            priority.setPriority(priorityName);
            priorityList.put(priorityName, priority);
            log.debug((Object)("populating priorities: " + priorityName));
            this.persist(priority);
        }
    }

    private void populateDB(String path) {
        this.setLogPath(path);
        Hashtable<String, LogFile> logFileList = new Hashtable<String, LogFile>();
        this.setLogFiles(logFileList);
        log.debug((Object)("populatedb: " + path));
        this.checkAndAddLogPath();
        Hashtable<String, Component> componentsList = new Hashtable<String, Component>();
        this.setComponents(componentsList);
        ArrayList<MetadataEntry> entriesList = new ArrayList<MetadataEntry>();
        this.setEntries(entriesList);
    }

    private void initializeLogPath() {
        EntityManager em = this.manager.getEntityManager();
        Query q = em.createQuery("select m from LogFile m");
        this.name = "metadata";
        if (q.getResultList().size() == 0) {
            log.debug((Object)("query result: size" + q.getResultList().size()));
            this.populatePriorities();
            this.populateDB(this.logPath);
        } else {
            log.debug((Object)("loading from db: " + this.logPath));
            this.loadFromDB(this.logPath);
        }
    }

    public void addEntry(LogEntry entry) {
        String comp = entry.getComponent();
        Component component = null;
        if (comp != null) {
            component = this.checkAndAddComponent(comp);
            float elapsedTime = entry.getElapsedTime();
            String priority = entry.getPriorityText();
            int lineNo = entry.getLineNumber();
            String logText = entry.getText();
            log.debug((Object)("elapsedTime: " + elapsedTime));
            log.debug((Object)("comp: " + comp));
            if (elapsedTime != -1.0f) {
                this.addElapsedTime(component, elapsedTime);
            } else if (!priority.equals("default")) {
                this.addMetadata(priority, component, lineNo, logText);
            } else {
                List<WhatLogMember> members;
                WhatEntry whatEntry = entry.getWhatEntry();
                if (whatEntry != null && (members = whatEntry.getMembers()) != null) {
                    for (WhatLogMember member : members) {
                        if (member == null) continue;
                        this.addWhatLogMember(component, member.getMember(), member.getMemberExists());
                    }
                }
            }
        }
    }

    private void addWhatLogMember(Component component, String whatLogMember, boolean memberExists) {
        WhatLogEntry entry = new WhatLogEntry();
        entry.setMember(whatLogMember);
        entry.setMissing(!memberExists);
        entry.setComponent(component);
        this.persist(entry);
    }

    private LogFile checkAndAddLogPath() {
        LogFile logFile = this.logFiles.get(this.logPath);
        log.debug((Object)("checkandaddlogpath:logpath" + this.logPath));
        log.debug((Object)("checkandaddlogpath:logFile" + logFile));
        if (logFile == null) {
            logFile = new LogFile();
            logFile.setPath(this.logPath);
            this.persist(logFile);
            this.logFiles.put(this.logPath, logFile);
        }
        return logFile;
    }

    private void addElapsedTime(Component component, double elapsedTime) {
        ComponentTime componentTime = new ComponentTime();
        componentTime.setComponent(component);
        componentTime.setDuration(elapsedTime);
        this.persist(componentTime);
    }

    private Component checkAndAddComponent(String comp) {
        Component component = this.components.get(comp);
        if (component == null) {
            component = new Component();
            log.debug((Object)("checkandaddcomponent: logpath" + this.logPath));
            log.debug((Object)("checkandaddcomponent: logpath" + this.logFiles));
            component.setLogFile(this.logFiles.get(this.logPath));
            component.setComponent(comp);
            this.persist(component);
            this.components.put(comp, component);
        }
        return component;
    }

    private Priority getPriority(String prty) {
        Priority retValue = this.priorities.get(prty.toUpperCase());
        if (retValue == null) {
            retValue = this.priorities.get(priorityNames[0]);
        }
        log.debug((Object)("priority:getPriority: " + prty));
        return retValue;
    }

    private void addMetadata(String priority, Component component, int lineNo, String logText) {
        MetadataEntry entry = new MetadataEntry();
        log.debug((Object)("logfile : " + component.getLogFile().getPath()));
        entry.setLogFile(component.getLogFile());
        entry.setComponent(component);
        entry.setLineNumber(lineNo);
        entry.setPriority(this.getPriority(priority));
        log.debug((Object)("error text message: " + logText));
        entry.setText(logText);
        this.persist(entry);
    }

    public final void removeEntries() {
        EntityManager em = this.manager.getEntityManager();
        LogFile file = (LogFile)this.executeSingleQuery("select l from LogFile l where l.path like '%" + this.logPath + "'");
        if (file != null) {
            log.debug((Object)("removing entries for : " + file.getPath()));
            int pathId = file.getId();
            this.removeEntries("DELETE FROM MetadataEntry AS m where m.COMPONENT_ID in (select COMPONENT_ID from Component where LOGPATH_ID= " + pathId + ")");
            this.removeEntries("DELETE FROM ComponentTime AS ctime where ctime.COMPONENT_ID in (select COMPONENT_ID from Component where LOGPATH_ID= " + pathId + ")");
            this.removeEntries("DELETE FROM WhatLogEntry AS wentry where wentry.COMPONENT_ID in (select COMPONENT_ID from Component where LOGPATH_ID= " + pathId + ")");
            this.removeEntries("DELETE FROM Component AS c where c.LOGPATH_ID = " + pathId);
            this.removeEntries("DELETE FROM LogFile AS l where l.LOGPATH_ID = " + pathId);
            this.removeEntries("DELETE FROM LogFile l where l.LOGPATH_ID = " + pathId);
        }
    }

    private Object executeSingleQuery(String queryString) {
        EntityManager em = this.manager.getEntityManager();
        Query query = em.createQuery(queryString);
        query.setHint("eclipselink.persistence-context.reference-mode", (Object)"WEAK");
        query.setHint("eclipselink.maintain-cache", (Object)"false");
        query.setHint("eclipselink.read-only", (Object)"true");
        query.setFlushMode(FlushModeType.COMMIT);
        Object obj = null;
        try {
            obj = query.getSingleResult();
        }
        catch (NoResultException nex) {
            log.debug((Object)"no results:", (Throwable)nex);
        }
        catch (NonUniqueResultException nux) {
            log.debug((Object)"more than one result returned:", (Throwable)nux);
        }
        return obj;
    }

    private void removeEntries(String queryString) {
        EntityManager em = this.manager.getEntityManager();
        Query query = em.createNativeQuery(queryString);
        query.setHint("eclipselink.persistence-context.reference-mode", (Object)"WEAK");
        query.setHint("eclipselink.maintain-cache", (Object)"false");
        query.setFlushMode(FlushModeType.COMMIT);
        try {
            int deletedRecords = query.executeUpdate();
            log.debug((Object)("total records deleted " + deletedRecords + "for query:" + queryString));
        }
        catch (NoResultException nex) {
            log.debug((Object)"no results:", (Throwable)nex);
        }
        catch (NonUniqueResultException nux) {
            log.debug((Object)"more than one result returned:", (Throwable)nux);
        }
    }

    public static class WhatLogMember {
        private String member;
        private boolean memberExists;

        public WhatLogMember(String mbr, boolean exists) {
            this.member = mbr;
            this.memberExists = exists;
        }

        public String getMember() {
            return this.member;
        }

        public boolean getMemberExists() {
            return this.memberExists;
        }
    }

    public static class WhatEntry {
        private String component;
        private List<WhatLogMember> members;

        public WhatEntry(String comp, List<WhatLogMember> mbrs) {
            this.component = comp;
            this.members = mbrs;
        }

        public String getComponent() {
            return this.component;
        }

        public List<WhatLogMember> getMembers() {
            return this.members;
        }
    }

    public static enum PriorityEnum {
        FATAL(1),
        ERROR(2),
        WARNING(3),
        INFO(4),
        REMARK(5),
        DEFAULT(6),
        CRITICAL(7);

        private final int value;

        private PriorityEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PriorityEnum getPriorityEnum(int i) {
            PriorityEnum[] values = PriorityEnum.values();
            return i >= 0 && i < values.length ? values[i] : FATAL;
        }
    }

    public static class LogEntry {
        private String text;
        private PriorityEnum priority;
        private String component;
        private int lineNumber;
        private String logPath;
        private float elapsedTime;
        private String priroityText;
        private WhatEntry whatEntry;

        public LogEntry(String text, PriorityEnum priority, String component, String logPath, int lineNumber, float time, WhatEntry entry) {
            this.text = text;
            this.priority = priority;
            this.component = component;
            this.lineNumber = lineNumber;
            this.logPath = logPath.replace('\'', '/');
            this.elapsedTime = time;
            this.whatEntry = entry;
        }

        public LogEntry(String text, PriorityEnum priority, String component, String logPath, int lineNumber) {
            this(text, priority, component, logPath, lineNumber, -1.0f, null);
        }

        public LogEntry(String text, String priorityTxt, String component, String logPath, int lineNumber, float time, WhatEntry entry) throws Exception {
            String prtyText;
            PriorityEnum prty = null;
            this.priroityText = prtyText = priorityTxt.trim().toLowerCase();
            if (prtyText.equals("error")) {
                prty = PriorityEnum.ERROR;
            } else if (prtyText.equals("warning")) {
                prty = PriorityEnum.WARNING;
            } else if (prtyText.equals("fatal")) {
                prty = PriorityEnum.FATAL;
            } else if (prtyText.equals("info")) {
                prty = PriorityEnum.INFO;
            } else if (prtyText.equals("remark")) {
                prty = PriorityEnum.REMARK;
            } else if (prtyText.equals("default")) {
                prty = PriorityEnum.DEFAULT;
            } else if (prtyText.equals("critical")) {
                prty = PriorityEnum.CRITICAL;
            } else {
                log.debug((Object)("Error: priority " + prtyText + " is not acceptable by metadata and set to Error"));
                prty = PriorityEnum.ERROR;
                this.priroityText = "error";
            }
            this.logPath = logPath.replace('\\', '/');
            this.text = text;
            this.priority = prty;
            this.component = component;
            this.lineNumber = lineNumber;
            this.elapsedTime = time;
            this.whatEntry = entry;
        }

        public void setElapsedTime(float time) {
            this.elapsedTime = time;
        }

        public String getLogPath() {
            return this.logPath;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public PriorityEnum getPriority() {
            return this.priority;
        }

        public String getPriorityText() {
            return this.priroityText;
        }

        public float getElapsedTime() {
            return this.elapsedTime;
        }

        public void setPriority(PriorityEnum priority) {
            this.priority = priority;
        }

        public String getComponent() {
            return this.component;
        }

        public void setComponent(String component) {
            this.component = component;
        }

        public WhatEntry getWhatEntry() {
            return this.whatEntry;
        }
    }
}

