/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data;

import com.nokia.helium.ant.data.AntlibMeta;
import com.nokia.helium.ant.data.Database;
import com.nokia.helium.ant.data.ProjectMeta;
import com.nokia.helium.ant.data.RootAntObjectMeta;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Project;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class AntFile {
    private Database database;
    private File path;
    private Document doc;
    private RootAntObjectMeta fileObjectMeta;
    private Project rootProject;

    public AntFile(Database database, String path) throws IOException {
        this(database, path, "public");
    }

    public AntFile(Database database, String path, String scope) throws IOException {
        this.database = database;
        this.path = new File(path);
        SAXReader xmlReader = new SAXReader();
        try {
            this.doc = xmlReader.read(path);
            Element node = this.doc.getRootElement();
            this.fileObjectMeta = node.getName().equals("project") ? new ProjectMeta(this, node) : new AntlibMeta(this, node);
            this.fileObjectMeta.setScopeFilter(scope);
            this.fileObjectMeta.setRuntimeProject(this.rootProject);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Project getProject() {
        return this.rootProject;
    }

    public void setProject(Project project) {
        this.rootProject = project;
        this.fileObjectMeta.setRuntimeProject(this.rootProject);
    }

    public void setScope(String scope) {
        this.fileObjectMeta.setScopeFilter(scope);
    }

    public RootAntObjectMeta getRootObjectMeta() throws IOException {
        return this.fileObjectMeta;
    }

    public File getFile() {
        return this.path;
    }

    public Database getDatabase() {
        return this.database;
    }

    public List<AntFile> getAntlibs() throws IOException {
        Element node = this.doc.getRootElement();
        ArrayList<AntFile> antlibFiles = new ArrayList<AntFile>();
        if (node.getName().equals("project")) {
            List typedefs = node.selectNodes("//*[namespace-uri()='http://www.nokia.com/helium' and local-name()='typedef']");
            for (Node typedefNode : typedefs) {
                String filePath = ((Element)typedefNode).attributeValue("file");
                filePath = this.getProject().replaceProperties(filePath);
                antlibFiles.add(new AntFile(this.database, filePath));
            }
        }
        return antlibFiles;
    }
}

