/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.scm.ant.taskdefs;

import com.nokia.helium.scm.ant.taskdefs.AddAction;
import com.nokia.helium.scm.ant.taskdefs.BranchAction;
import com.nokia.helium.scm.ant.taskdefs.ChangelogAction;
import com.nokia.helium.scm.ant.taskdefs.CheckinAction;
import com.nokia.helium.scm.ant.taskdefs.CheckoutAction;
import com.nokia.helium.scm.ant.taskdefs.DiffAction;
import com.nokia.helium.scm.ant.taskdefs.ExportAction;
import com.nokia.helium.scm.ant.taskdefs.InfoAction;
import com.nokia.helium.scm.ant.taskdefs.InitAction;
import com.nokia.helium.scm.ant.taskdefs.PullAction;
import com.nokia.helium.scm.ant.taskdefs.RemoveAction;
import com.nokia.helium.scm.ant.taskdefs.ScmAction;
import com.nokia.helium.scm.ant.taskdefs.StatusAction;
import com.nokia.helium.scm.ant.taskdefs.TagAction;
import com.nokia.helium.scm.ant.taskdefs.TagsAction;
import com.nokia.helium.scm.ant.taskdefs.UpdateAction;
import com.nokia.maven.scm.manager.BasicExtendedScmManager;
import com.nokia.maven.scm.manager.ExtendedScmManager;
import com.nokia.maven.scm.provider.hg.HgScmProviderExt;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ScmTask
extends Task {
    private ExtendedScmManager scmManager;
    private String username;
    private String password;
    private String scmUrl;
    private String basedir;
    private List<ScmAction> actions = new ArrayList<ScmAction>();
    private boolean verbose;
    private boolean failonerror = true;

    public ScmTask() {
        this.setTaskName("scm");
        this.scmManager = new BasicExtendedScmManager();
        this.scmManager.setScmProvider("hg", (ScmProvider)new HgScmProviderExt());
    }

    public ScmManager getScmManager() {
        return this.scmManager;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public void addAdd(AddAction action) {
        this.addAction(action);
    }

    public void addChangelog(ChangelogAction action) {
        this.addAction(action);
    }

    public void addBranch(BranchAction action) {
        this.addAction(action);
    }

    public void addCheckin(CheckinAction action) {
        this.addAction(action);
    }

    public void addCheckout(CheckoutAction action) {
        this.addAction(action);
    }

    public void addDiff(DiffAction action) {
        this.addAction(action);
    }

    public void addRemove(RemoveAction action) {
        this.addAction(action);
    }

    public void addStatus(StatusAction action) {
        this.addAction(action);
    }

    public void addUpdate(UpdateAction action) {
        this.addAction(action);
    }

    public ScmAction[] getActions() {
        return this.actions.toArray(new ScmAction[0]);
    }

    public void addPull(PullAction action) {
        this.addAction(action);
    }

    public void addTag(TagAction action) {
        this.addAction(action);
    }

    public void addTags(TagsAction action) {
        this.addAction(action);
    }

    public void addInfo(InfoAction action) {
        this.addAction(action);
    }

    public void addInit(InitAction action) {
        this.addAction(action);
    }

    public void addExport(ExportAction action) {
        this.addAction(action);
    }

    private void addAction(ScmAction action) {
        action.setTask(this);
        this.actions.add(action);
    }

    public void add(ScmAction action) {
        this.addAction(action);
    }

    public final void execute() {
        try {
            this.log("scm url: " + this.scmUrl);
            ScmRepository repository = this.scmManager.makeScmRepository(this.scmUrl);
            for (ScmAction action : this.actions) {
                action.execute(repository);
            }
        }
        catch (NoSuchScmProviderException ex) {
            throw new BuildException("Could not find a provider.");
        }
        catch (ScmRepositoryException ex) {
            throw new BuildException("Error while connecting to the repository: " + ex.getMessage());
        }
        catch (Exception e) {
            if (this.failonerror) {
                e.printStackTrace();
                throw new BuildException(e.getMessage());
            }
            e.printStackTrace();
        }
    }
}

