/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.XMLLogMetaDataInput;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class PolicyLogMetaDataInput
extends XMLLogMetaDataInput {
    private Logger log = Logger.getLogger(XMLLogMetaDataInput.class);
    private Map<String, String> currentAttributeMap;

    private Map<String, String> getAttributes(XMLStreamReader streamReader) {
        int count = streamReader.getAttributeCount();
        if (count > 0) {
            HashMap<String, String> attributesMap = new HashMap<String, String>();
            for (int i = 0; i < count; ++i) {
                attributesMap.put(streamReader.getAttributeLocalName(i), streamReader.getAttributeValue(i));
            }
            return attributesMap;
        }
        return null;
    }

    @Override
    boolean startElement(XMLStreamReader streamReader) {
        String tagName = streamReader.getLocalName();
        if (tagName.equalsIgnoreCase("error")) {
            this.currentAttributeMap = this.getAttributes(streamReader);
        }
        return false;
    }

    @Override
    boolean endElement(XMLStreamReader streamReader) throws Exception {
        boolean retValue = false;
        try {
            String tagName = streamReader.getLocalName();
            String priority = "ERROR";
            this.log.debug((Object)("endElement: " + tagName));
            if (tagName.equalsIgnoreCase("error")) {
                this.log.debug((Object)"tagName matches error");
                String errorType = this.currentAttributeMap.get("type");
                this.log.debug((Object)("errorType:" + errorType));
                if (errorType.equals("unknownstatus")) {
                    this.addEntry(priority, "CSV validation", this.getCurrentFile().toString(), -1, this.currentAttributeMap.get("message") + this.currentAttributeMap.get("value"));
                    retValue = true;
                } else if (errorType.equals("A") || errorType.equals("B") || errorType.equals("C") || errorType.equals("D")) {
                    int flags = 34;
                    Pattern pattern = Pattern.compile("([\\\\/][^\\\\/]+?)$", flags);
                    this.addEntry(priority, "Issues", this.getCurrentFile().toString(), -1, errorType + "Found incorrect value for" + pattern.matcher(this.currentAttributeMap.get("message")).replaceAll(""));
                    retValue = true;
                } else if (errorType.equals("missing")) {
                    this.addEntry(priority, "Missing", this.getCurrentFile().toString(), -1, this.currentAttributeMap.get("message"));
                    retValue = true;
                } else if (errorType.equals("invalidencoding")) {
                    this.addEntry(priority, "Incorrect policy files", this.getCurrentFile().toString(), -1, this.currentAttributeMap.get("message"));
                    retValue = true;
                }
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception in endelement", (Throwable)ex);
            throw ex;
        }
        return retValue;
    }

    @Override
    boolean characters(XMLStreamReader streamReader) {
        return false;
    }
}

