/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.cruisecontrol.sourcecontrol;

import com.nokia.cruisecontrol.sourcecontrol.OperationFailedException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynergyBaselineProjects {
    private static final Logger LOG = Logger.getLogger(SynergyBaselineProjects.class);
    private ManagedCommandline cmd;
    private String project;

    public SynergyBaselineProjects(ManagedCommandline cmd, String project) {
        this.cmd = cmd;
        this.project = project;
        LOG.setLevel(Level.DEBUG);
    }

    public List<String> getBaselineProjects() {
        ArrayList<String> baselines = new ArrayList<String>();
        LOG.info((Object)("Querying baselines projects for " + this.project));
        this.cmd.clearArgs();
        this.cmd.createArgument("query");
        this.cmd.createArgument("hierarchy_project_members(is_project_in_baseline_of(is_baseline_in_pg_of(is_project_grouping_of('" + this.project + "'))),none)");
        this.cmd.createArgument("-u");
        this.cmd.createArgument("-f");
        this.cmd.createArgument("%objectname");
        try {
            this.cmd.execute();
            this.cmd.assertExitCode(0);
        }
        catch (Exception e) {
            String message = "Could not query baseline projects for \"" + this.project + "\".";
            LOG.error((Object)message, (Throwable)e);
            throw new OperationFailedException(message, e);
        }
        LOG.info((Object)("stderr: " + this.cmd.getStderrAsString()));
        LOG.info((Object)("stdout: " + this.cmd.getStdoutAsString()));
        for (Object o : this.cmd.getStdoutAsList()) {
            String l = (String)o;
            if (l.length() <= 0) continue;
            LOG.info((Object)("Baseline: " + l));
            baselines.add(l);
        }
        return baselines;
    }
}

