/*
 * Decompiled with CFR 0.152.
 */
package fmpp.setting;

import bsh.EvalError;
import bsh.Interpreter;
import fmpp.DataModelBuildingException;
import fmpp.Engine;
import fmpp.LocalDataBuilder;
import fmpp.ProcessingException;
import fmpp.ProgressListener;
import fmpp.XmlRenderingConfiguration;
import fmpp.localdatabuilders.BshLocalDataBuilder;
import fmpp.localdatabuilders.MapLocalDataBuilder;
import fmpp.localdatabuilders.TddHashLocalDataBuilder;
import fmpp.setting.FileWithConfigurationBase;
import fmpp.setting.FileWithSettingValue;
import fmpp.setting.SettingException;
import fmpp.setting.XmlDependentOps;
import fmpp.tdd.DataLoaderEvaluationEnvironment;
import fmpp.tdd.EvalException;
import fmpp.tdd.EvaluationEnvironment;
import fmpp.tdd.Fragment;
import fmpp.tdd.FunctionCall;
import fmpp.util.BugException;
import fmpp.util.InstallationException;
import fmpp.util.MiscUtil;
import fmpp.util.StringUtil;
import freemarker.ext.beans.BeansWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class Settings {
    public static final String NAME_SKIP_UNCHANGED = "skipUnchanged";
    public static final String NAME_TURNS = "turns";
    public static final String NAME_SOURCES = "sources";
    public static final String NAME_SOURCE_ROOT = "sourceRoot";
    public static final String NAME_OUTPUT_ROOT = "outputRoot";
    public static final String NAME_OUTPUT_FILE = "outputFile";
    public static final String NAME_DATA_ROOT = "dataRoot";
    public static final String NAME_OBJECT_WRAPPER = "objectWrapper";
    public static final String NAME_FREEMARKER_LINKS = "freemarkerLinks";
    public static final String NAME_INHERIT_CONFIGURATION = "inheritConfiguration";
    public static final String NAME_MODES = "modes";
    public static final String NAME_BORDERS = "borders";
    public static final String NAME_DATA = "data";
    public static final String NAME_LOCAL_DATA = "localData";
    public static final String NAME_TEMPLATE_DATA = "templateData";
    public static final String NAME_SOURCE_ENCODING = "sourceEncoding";
    public static final String NAME_OUTPUT_ENCODING = "outputEncoding";
    public static final String NAME_URL_ESCAPING_CHARSET = "urlEscapingCharset";
    public static final String NAME_LOCALE = "locale";
    public static final String NAME_NUMBER_FORMAT = "numberFormat";
    public static final String NAME_DATE_FORMAT = "dateFormat";
    public static final String NAME_TIME_FORMAT = "timeFormat";
    public static final String NAME_DATETIME_FORMAT = "datetimeFormat";
    public static final String NAME_TIME_ZONE = "timeZone";
    public static final String NAME_TAG_SYNTAX = "tagSyntax";
    public static final String NAME_CASE_SENSITIVE = "caseSensitive";
    public static final String NAME_STOP_ON_ERROR = "stopOnError";
    public static final String NAME_REMOVE_EXTENSIONS = "removeExtensions";
    public static final String OLD_NAME_REMOVE_EXTENSION = "removeExtension";
    public static final String NAME_REMOVE_POSTFIXES = "removePostfixes";
    public static final String OLD_NAME_REMOVE_POSTFIX = "removePostfix";
    public static final String NAME_REPLACE_EXTENSIONS = "replaceExtensions";
    public static final String OLD_NAME_REPLACE_EXTENSION = "replaceExtension";
    public static final String NAME_IGNORE_CVS_FILES = "ignoreCvsFiles";
    public static final String NAME_IGNORE_SVN_FILES = "ignoreSvnFiles";
    public static final String NAME_IGNORE_TEMPORARY_FILES = "ignoreTemporaryFiles";
    public static final String NAME_EXPERT = "expert";
    public static final String NAME_LOG_FILE = "logFile";
    public static final String NAME_APPEND_LOG_FILE = "appendLogFile";
    public static final String NAME_CONFIGURATION_BASE = "configurationBase";
    public static final String NAME_ECHO_FORMAT = "echoFormat";
    public static final String NAME_QUIET = "quiet";
    public static final String NAME_COLUMNS = "columns";
    public static final String NAME_SNIP = "snip";
    public static final String NAME_XPATH_ENGINE = "xpathEngine";
    public static final String NAME_XML_CATALOG_FILES = "xmlCatalogFiles";
    public static final String NAME_XML_CATALOG_PREFER = "xmlCatalogPrefer";
    public static final String NAME_VALIDATE_XML = "validateXml";
    public static final String NAME_XML_RENDERINGS = "xmlRenderings";
    public static final String VALUE_SOURCE = "source";
    public static final String VALUE_HOST = "host";
    public static final String VALUE_OUTPUT = "output";
    public static final String VALUE_OBJECTWRAPPER_SHARED_BEANS_WRAPPER = "shared";
    public static final String VALUE_TAG_SYNTAX_ANGLE_BRACKET = "angleBracket";
    public static final String VALUE_TAG_SYNTAX_SQUARE_BRACKET = "squareBracket";
    public static final String VALUE_TAG_SYNTAX_AUTO_DETECT = "autoDetect";
    public static final String VALUE_NONE = "none";
    public static final String VALUE_REALLY_QUIET = "reallyQuiet";
    public static final String VALUE_XML_CATALOG_PREFER_PUBLIC = "public";
    public static final String VALUE_XML_CATALOG_PREFER_SYSTEM = "system";
    public static final String VALUE_GLOBAL_DEFAULT = "globalDefault";
    public static final String DEFAULT_CFG_FILE_NAME = "config.fmpp";
    public static final String DEFAULT_CFG_FILE_NAME_OLD = "fmpp.cfg";
    public static final SettingType TYPE_ANY = new SettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            return value;
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            return value;
        }

        public Object merge(Settings settings, Object defValue, Object value) throws SettingException {
            throw new SettingException("Settings of type \"any\" can't be merged.");
        }
    };
    public static final SettingType TYPE_STRING = new SettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            if (value instanceof String) {
                return value;
            }
            if (value instanceof Number || value instanceof Boolean) {
                return String.valueOf(value);
            }
            throw new SettingException("The setting value should be a string, but now it was a " + Settings.typeName(value) + ".");
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            return value;
        }

        public Object merge(Settings settings, Object defValue, Object value) throws SettingException {
            throw new SettingException("Settings of type \"string\" can't be merged.");
        }
    };
    public static final SettingType TYPE_INTEGER = new SettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof Number) {
                Number n = (Number)value;
                double d = n.doubleValue();
                int i = n.intValue();
                if ((double)i != d) {
                    if (d < 2.147483647E9 && d > -2.147483648E9) {
                        throw new SettingException("The setting value should be an integer number, but now it was a fraction number.");
                    }
                    throw new SettingException("The setting value should be an integer number, but it was a too big number to store on 32 bits.");
                }
                return new Integer(i);
            }
            throw new SettingException("The setting value should be an integer number, but now it was a " + Settings.typeName(value) + ".");
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            try {
                value = value.trim();
                if (value.startsWith("+")) {
                    value.substring(1);
                }
                return new Integer(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new SettingException("Not a valid integer number: " + value, e);
            }
        }

        public Object merge(Settings settings, Object defValue, Object value) throws SettingException {
            throw new SettingException("Settings of type \"integer\" can't be merged.");
        }
    };
    public static final SettingType TYPE_BOOLEAN = new SettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            if (value instanceof Boolean) {
                return value;
            }
            throw new SettingException("The setting value should be a boolean, but now it was a " + Settings.typeName(value) + ".");
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            if ((value = value.trim().toLowerCase()).equals("true") || value.length() == 0) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return Boolean.FALSE;
            }
            throw new SettingException("Not a valid boolean: " + value);
        }

        public Object merge(Settings settings, Object defValue, Object value) throws SettingException {
            throw new SettingException("Settings of type \"boolean\" can't be merged.");
        }
    };
    public static final SettingType TYPE_SEQUENCE = new SequenceSettingType();
    public static final SettingType TYPE_LOCAL_DATA_MODEL = new SequenceSettingType(){

        protected EvaluationEnvironment getEvaluationEnvironment() {
            return new EvaluationEnvironment(){
                private int functionCallLevel;
                private int hashLevel;
                private int sequenceLevel;
                private boolean inCaseFunction;

                public Object evalFunctionCall(FunctionCall fc, fmpp.tdd.Interpreter ip) {
                    return fc;
                }

                public Object notify(int event, fmpp.tdd.Interpreter ip, String name, Object extra) {
                    if (event == 3) {
                        ++this.functionCallLevel;
                        if (this.functionCallLevel == 1 && name.equals(Settings.FUNCTION_CASE)) {
                            this.inCaseFunction = true;
                        }
                    } else if (event == -3) {
                        --this.functionCallLevel;
                        if (this.functionCallLevel == 0) {
                            this.inCaseFunction = false;
                        }
                    } else if (event == 5) {
                        ++this.hashLevel;
                        if (this.inCaseFunction && this.functionCallLevel == 1 && this.hashLevel == 1 && this.sequenceLevel == 0) {
                            return EvaluationEnvironment.RETURN_FRAGMENT;
                        }
                    } else if (event == -5) {
                        --this.hashLevel;
                    } else if (event == 4) {
                        if (this.inCaseFunction) {
                            ++this.sequenceLevel;
                        }
                    } else if (event == -4 && this.inCaseFunction) {
                        --this.sequenceLevel;
                    }
                    return null;
                }
            };
        }
    };
    public static final SettingType TYPE_HASH = new SettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            if (value instanceof Map) {
                return value;
            }
            if (value instanceof Dictionary) {
                return MiscUtil.dictionaryToMap((Dictionary)value);
            }
            throw new SettingException("The setting value should be a hash (a Map), but now it was a " + Settings.typeName(value) + ".");
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            try {
                return fmpp.tdd.Interpreter.evalAsHash(value, null, forceStr, null);
            }
            catch (EvalException e) {
                throw new SettingException("Failed to parse the text as TDD hash.", e);
            }
        }

        public Object merge(Settings settings, Object defValue, Object value) throws SettingException {
            Map m1 = (Map)defValue;
            Map m2 = (Map)value;
            HashMap m = new HashMap(m1.size() + m2.size());
            m.putAll(m1);
            m.putAll(m2);
            return m;
        }
    };
    public static final SettingType TYPE_CFG_RELATIVE_PATH = new SettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            if (value instanceof String) {
                File f = new File((String)value);
                if (f.isAbsolute()) {
                    return new FileWithSettingValue((String)value, (String)value);
                }
                return new FileWithSettingValue(settings.baseDir, (String)value, (String)value);
            }
            if (value instanceof FileWithSettingValue) {
                return value;
            }
            throw new SettingException("The setting value should be a string (a path), but now it was a " + Settings.typeName(value) + ".");
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            return this.convert(settings, value.trim());
        }

        public Object merge(Settings settings, Object defValue, Object value) throws SettingException {
            throw new SettingException("Settings of type \"path\" can't be merged.");
        }
    };
    public static final SettingType TYPE_CFG_RELATIVE_PATHS = new SequenceSettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            return this.convertList(settings, (List)super.convert(settings, value));
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            return this.convertList(settings, (List)super.convertString(settings, value, forceStr));
        }

        private List convertList(Settings settings, List ls) throws SettingException {
            int ln = ls.size();
            ArrayList<FileWithSettingValue> res = new ArrayList<FileWithSettingValue>(ln);
            for (int i = 0; i < ln; ++i) {
                Object o = ls.get(i);
                if (o instanceof String) {
                    File f = new File((String)o);
                    if (f.isAbsolute()) {
                        res.add(new FileWithSettingValue((String)o, (String)o));
                        continue;
                    }
                    res.add(new FileWithSettingValue(settings.baseDir, (String)o, (String)o));
                    continue;
                }
                if (o instanceof FileWithSettingValue) {
                    res.add((FileWithSettingValue)o);
                    continue;
                }
                throw new SettingException("All list items must be strings (paths), but the item at index " + i + " is a " + Settings.typeName(o) + ".");
            }
            return res;
        }
    };
    public static final SettingType TYPE_UNRESOLVED_CFG_RELATIVE_PATHS = new SequenceSettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            return this.convertList(settings, (List)super.convert(settings, value));
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            return this.convertList(settings, (List)super.convertString(settings, value, forceStr));
        }

        private List convertList(Settings settings, List ls) throws SettingException {
            int ln = ls.size();
            ArrayList<FileWithConfigurationBase> res = new ArrayList<FileWithConfigurationBase>(ln);
            for (int i = 0; i < ln; ++i) {
                Object o = ls.get(i);
                if (!(o instanceof FileWithConfigurationBase)) {
                    if (!(o instanceof String)) {
                        throw new SettingException("All list items must be strings (paths), but the item at index " + i + " is a " + Settings.typeName(o) + ".");
                    }
                    res.add(new FileWithConfigurationBase(settings.baseDir, (String)o, (String)o));
                    continue;
                }
                res.add((FileWithConfigurationBase)o);
            }
            return res;
        }
    };
    public static final SettingType TYPE_DATA_MODEL = new SettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            if (value instanceof Dictionary) {
                value = MiscUtil.dictionaryToMap((Dictionary)value);
            }
            if (value instanceof Map || value instanceof Fragment || value instanceof String) {
                DataList ls = new DataList(1);
                ls.add(value);
                return ls;
            }
            if (value instanceof DataList) {
                return value;
            }
            throw new SettingException("The setting value should be a hash, but now it was a " + Settings.typeName(value) + ".");
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            DataList ls = new DataList(1);
            ls.add(value);
            return ls;
        }

        public Object merge(Settings settings, Object defValue, Object value) throws SettingException {
            DataList l1 = (DataList)defValue;
            DataList l2 = (DataList)value;
            DataList ls = new DataList(l1.size() + l2.size());
            ls.addAll(l1);
            ls.addAll(l2);
            return ls;
        }
    };
    public static final SettingType TYPE_HASH_OF_SEQUENCE_OF_CFG_RELATIVE_PATHS = new SettingType(){

        public Object convert(Settings settings, Object value) throws SettingException {
            Map mapVal = (Map)TYPE_HASH.convert(settings, value);
            Iterator it = mapVal.entrySet().iterator();
            while (it.hasNext()) {
                Object convertedValue;
                Map.Entry ent = it.next();
                try {
                    convertedValue = TYPE_CFG_RELATIVE_PATHS.convert(settings, ent.getValue());
                }
                catch (SettingException e) {
                    throw new SettingException("Problem with a value in the hash: " + e.getMessage(), e.getCause());
                }
                ent.setValue(convertedValue);
            }
            return mapVal;
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            try {
                return this.convert(settings, fmpp.tdd.Interpreter.evalAsHash(value, null, forceStr, null));
            }
            catch (EvalException e) {
                throw new SettingException("Failed to parse the text as TDD hash.", e);
            }
        }

        public Object merge(Settings settings, Object defValue, Object value) throws SettingException {
            Map mDef = (Map)defValue;
            Map mPri = (Map)value;
            HashMap<String, List> mMerged = new HashMap<String, List>(mDef.size() + mPri.size());
            mMerged.putAll(mPri);
            Iterator it = mDef.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry ent = it.next();
                String key = (String)ent.getKey();
                List vDef = (List)ent.getValue();
                List vPri = (List)mMerged.get(key);
                if (vPri != null) {
                    ArrayList mergedList = new ArrayList(vPri.size() + vDef.size());
                    mergedList.addAll(vPri);
                    mergedList.addAll(vDef);
                    mMerged.put(key, mergedList);
                    continue;
                }
                mMerged.put(key, vDef);
            }
            return mMerged;
        }
    };
    private static final Map STD_DEFS = new HashMap();
    private static final Map STD_STDCMDL = new HashMap();
    private static final String FUNCTION_LAYER = "layer";
    private static final String FUNCTION_CASE = "case";
    private static final String LOCAL_DATA_BUILDER_BSH = "bsh";
    private File baseDir;
    private Map defs;
    private Map values = new HashMap();
    private Map cmdLineNames;
    private XmlDependentOps xmlDependentOps;
    private List progressListeners = new ArrayList();
    private Map engineAttributes = new HashMap();
    private static final String MSG_XML_RENDERING_OPT_ERROR = "Problem with the options of an XML rendering in the \"xmlRenderings\" setting: ";
    static /* synthetic */ Class class$freemarker$ext$beans$BeansWrapper;
    static /* synthetic */ Class class$fmpp$LocalDataBuilder;

    public Settings(File baseDir) throws SettingException {
        if (baseDir == null) {
            throw new IllegalArgumentException("Parameter \"baseDir\" can't be null.");
        }
        try {
            this.baseDir = baseDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new SettingException("Can't bring base path to canonical form: " + baseDir.getPath());
        }
        this.defs = STD_DEFS;
        this.cmdLineNames = STD_STDCMDL;
    }

    public void define(String name, SettingType type, boolean merge, boolean forceStr) throws SettingException {
        if (this.defs.containsKey(name = name.trim())) {
            throw new SettingException("Setting " + StringUtil.jQuote(name) + " is already defined.");
        }
        SettingDefinition def = new SettingDefinition(name, type, merge, forceStr);
        if (this.defs == STD_DEFS) {
            this.defs = new HashMap(STD_DEFS);
            this.cmdLineNames = new HashMap(STD_STDCMDL);
        }
        this.defs.put(def.name, def);
        this.cmdLineNames.put(Settings.getDashedName(name), name);
    }

    public boolean isDefined(String name) {
        return this.defs.containsKey(name);
    }

    public static Iterator getStandardSettingNames() {
        return Collections.unmodifiableSet(STD_DEFS.keySet()).iterator();
    }

    public void add(String name, Object value) throws SettingException {
        this.addOrSet(this.values, name, value, false);
    }

    public void addDefault(String name, Object value) throws SettingException {
        this.addOrSetDefault(this.values, name, value, false);
    }

    public void addWithString(String name, String value) throws SettingException {
        this.addOrSet(this.values, name, this.translateProperty(name, value), false);
    }

    public void addDefaultWithString(String name, String value) throws SettingException {
        this.addOrSetDefault(this.values, name, this.translateProperty(name, value), false);
    }

    public void add(Map settingMap) throws SettingException {
        this.addOrSet(settingMap, false);
    }

    public void addDefaults(Map settingMap) throws SettingException {
        this.addOrSetDefaults(settingMap, false);
    }

    public void addWithStrings(Properties props) throws SettingException {
        this.addOrSetWithStrings(props, false);
    }

    public void addDefaultsWithStrings(Properties props) throws SettingException {
        this.addOrSetDefaultsWithStrings(props, false);
    }

    public void set(String name, Object value) throws SettingException {
        this.addOrSet(this.values, name, value, true);
    }

    public void set(String name, boolean value) throws SettingException {
        this.set(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void set(String name, int value) throws SettingException {
        this.set(name, new Integer(value));
    }

    public void setDefault(String name, Object value) throws SettingException {
        this.addOrSetDefault(this.values, name, value, true);
    }

    public void setDefault(String name, boolean value) throws SettingException {
        this.setDefault(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setDefault(String name, int value) throws SettingException {
        this.setDefault(name, new Integer(value));
    }

    public void setWithString(String name, String value) throws SettingException {
        this.addOrSet(this.values, name, this.translateProperty(name, value), true);
    }

    public void setDefaultWithString(String name, String value) throws SettingException {
        this.addOrSetDefault(this.values, name, this.translateProperty(name, value), true);
    }

    public void set(Map settingMap) throws SettingException {
        this.addOrSet(settingMap, true);
    }

    public void setDefaults(Map settingMap) throws SettingException {
        this.addOrSetDefaults(settingMap, true);
    }

    public void setWithStrings(Properties props) throws SettingException {
        this.addOrSetWithStrings(props, true);
    }

    public void setDefaultsWithStrings(Properties props) throws SettingException {
        this.addOrSetDefaultsWithStrings(props, true);
    }

    public void load(File cfgFile) throws SettingException {
        this.load_common(cfgFile, false);
    }

    public void loadDefaults(File cfgFile) throws SettingException {
        this.load_common(cfgFile, true);
    }

    public Object get(String name) {
        return this.values.get(name);
    }

    public Object remove(String name) {
        return this.values.remove(name);
    }

    public Iterator getNames() {
        return this.values.keySet().iterator();
    }

    public void execute() throws SettingException, ProcessingException {
        BeansWrapper ow;
        String s = (String)this.get(NAME_OBJECT_WRAPPER);
        if (s != null) {
            Object bres;
            Interpreter intp = new Interpreter();
            try {
                intp.eval("import freemarker.template.ObjectWrapper;");
                intp.eval("import freemarker.ext.beans.BeansWrapper;");
                bres = intp.eval(s);
            }
            catch (EvalError e) {
                throw new SettingException("Failed to apply the value of the " + StringUtil.jQuote(NAME_OBJECT_WRAPPER) + " setting.", e);
            }
            if (bres == null) {
                throw new SettingException("Failed to apply the value of the " + StringUtil.jQuote(NAME_OBJECT_WRAPPER) + " setting: the result of the setting value " + "evaluation was null. (The typical reason is that " + "you forget the \"return\" statement. A rare but " + "rather evil reason is that you use a \"//\" " + "comment, and Ant eats the line-breaks, so you " + "comment out everything after the \"//\".)");
            }
            if (!(bres instanceof BeansWrapper)) {
                throw new SettingException("Failed to apply the value of the " + StringUtil.jQuote(NAME_OBJECT_WRAPPER) + " setting: the class of the resulting object must " + "extend " + (class$freemarker$ext$beans$BeansWrapper == null ? (class$freemarker$ext$beans$BeansWrapper = Settings.class$("freemarker.ext.beans.BeansWrapper")) : class$freemarker$ext$beans$BeansWrapper).getName() + ", but the " + bres.getClass().getName() + " class doesn't extend it.");
            }
            ow = (BeansWrapper)bres;
        } else {
            ow = null;
        }
        Engine eng = new Engine(ow);
        this.execute_common(eng);
    }

    public void execute(Engine eng) throws SettingException, ProcessingException {
        this.execute_common(eng);
    }

    public void addProgressListener(ProgressListener pl) {
        this.progressListeners.add(pl);
    }

    public void clearProgressListeners() {
        this.progressListeners.clear();
    }

    public Object setEngineAttribute(String name, Object value) {
        return this.engineAttributes.put(name, value);
    }

    public Object getEngineAttribute(String name) {
        return this.engineAttributes.get(name);
    }

    public Object removeAttribute(String name) {
        return this.engineAttributes.remove(name);
    }

    public void clearAttribues() {
        this.engineAttributes.clear();
    }

    public String dump() {
        return fmpp.tdd.Interpreter.dump(this.values);
    }

    public static int quietSettingValueToInt(String value, String name) throws SettingException {
        int level;
        if (value == null) {
            return 0;
        }
        if (value.length() == 0) {
            return 1;
        }
        if (value.equals("true")) {
            return 1;
        }
        if (value.equals("false")) {
            return 0;
        }
        if (value.equals(VALUE_REALLY_QUIET)) {
            return 2;
        }
        try {
            level = Integer.parseInt(value) + 1;
        }
        catch (NumberFormatException exc) {
            level = -123;
        }
        if (level < 0 || level > 2) {
            throw new SettingException("The value of the \"" + name + "\" setting has to be one of (case insensitive): " + "\"true\" (or empty string), \"false\", \"" + VALUE_REALLY_QUIET + "\", but now it was " + StringUtil.jQuote(value));
        }
        return level;
    }

    public static File getDefaultConfigurationFile(File dir) {
        File f = new File(dir, DEFAULT_CFG_FILE_NAME);
        if (f.isFile()) {
            return f.getAbsoluteFile();
        }
        f = new File(dir, DEFAULT_CFG_FILE_NAME_OLD);
        if (f.isFile()) {
            return f.getAbsoluteFile();
        }
        return null;
    }

    public void undashNames(Properties props) throws SettingException {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String convertedName = (String)this.cmdLineNames.get(name);
            if (convertedName == null || convertedName.equals(name)) {
                if (this.defs.containsKey(name)) continue;
                throw this.newUnknownSettingException(name);
            }
            if (props.containsKey(convertedName)) {
                throw new SettingException("Setting " + StringUtil.jQuote(convertedName) + " was specified twice in the Properties object, " + "with different but semantically equivalent " + "names.");
            }
            props.setProperty(convertedName, props.getProperty(name));
            props.remove(name);
        }
    }

    public void trimValues(Properties props) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = props.getProperty(name);
            String v2 = value.trim();
            if (v2 == value) continue;
            props.setProperty(name, v2);
        }
    }

    protected void doProcessing(Engine eng, File[] sources, File sourceFile, File outputFile) throws SettingException, ProcessingException {
        if (outputFile == null) {
            eng.process(sources);
        } else {
            eng.process(sourceFile, outputFile);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execute_common(Engine eng) throws SettingException, ProcessingException {
        Map m;
        int i;
        File f;
        File sourceFile;
        Boolean xmlCatalogPreferPublic;
        String s;
        Boolean b = (Boolean)this.get(NAME_EXPERT);
        if (b != null) {
            eng.setExpertMode(b);
        }
        if ((b = (Boolean)this.get(NAME_CASE_SENSITIVE)) != null) {
            eng.setCaseSensitive(b);
        }
        if ((s = (String)this.get(NAME_LOCALE)) != null) {
            eng.setLocale(s);
        }
        if ((s = (String)this.get(NAME_NUMBER_FORMAT)) != null) {
            eng.setNumberFormat(s);
        }
        if ((s = (String)this.get(NAME_DATE_FORMAT)) != null) {
            eng.setDateFormat(s);
        }
        if ((s = (String)this.get(NAME_TIME_FORMAT)) != null) {
            eng.setTimeFormat(s);
        }
        if ((s = (String)this.get(NAME_DATETIME_FORMAT)) != null) {
            eng.setDateTimeFormat(s);
        }
        if ((s = (String)this.get(NAME_TIME_ZONE)) != null) {
            eng.setTimeZone(TimeZone.getTimeZone(s));
        }
        if ((s = (String)this.get(NAME_TAG_SYNTAX)) != null) {
            if (s.equals(VALUE_TAG_SYNTAX_ANGLE_BRACKET)) {
                eng.setTagSyntax(1);
            } else if (s.equals(VALUE_TAG_SYNTAX_SQUARE_BRACKET)) {
                eng.setTagSyntax(2);
            } else {
                if (!s.equals(VALUE_TAG_SYNTAX_AUTO_DETECT)) throw new SettingException("The value of the " + StringUtil.jQuote(NAME_TAG_SYNTAX) + " setting should be one of " + "\"" + VALUE_TAG_SYNTAX_ANGLE_BRACKET + "\", \"" + VALUE_TAG_SYNTAX_SQUARE_BRACKET + "\", \"" + VALUE_TAG_SYNTAX_AUTO_DETECT + "\". Value " + StringUtil.jQuote(s) + " is invalid.");
                eng.setTagSyntax(0);
            }
        }
        if ((s = (String)this.get(NAME_SOURCE_ENCODING)) != null) {
            eng.setSourceEncoding(s);
        }
        if ((s = (String)this.get(NAME_OUTPUT_ENCODING)) != null) {
            eng.setOutputEncoding(s);
        }
        if ((s = (String)this.get(NAME_URL_ESCAPING_CHARSET)) != null) {
            eng.setUrlEscapingCharset(s);
        }
        if ((s = (String)this.get(NAME_XPATH_ENGINE)) != null) {
            eng.setXpathEngine(s);
        }
        if ((b = (Boolean)this.get(NAME_STOP_ON_ERROR)) != null) {
            eng.setStopOnError(b);
        }
        if ((b = (Boolean)this.get(NAME_IGNORE_CVS_FILES)) != null) {
            eng.setIgnoreCvsFiles(b);
        }
        if ((b = (Boolean)this.get(NAME_IGNORE_SVN_FILES)) != null) {
            eng.setIgnoreSvnFiles(b);
        }
        if ((b = (Boolean)this.get(NAME_IGNORE_TEMPORARY_FILES)) != null) {
            eng.setIgnoreTemporaryFiles(b);
        }
        if ((s = (String)this.get(NAME_XML_CATALOG_PREFER)) != null) {
            if (s.equals(VALUE_XML_CATALOG_PREFER_PUBLIC)) {
                xmlCatalogPreferPublic = Boolean.TRUE;
            } else if (s.equals(VALUE_XML_CATALOG_PREFER_SYSTEM)) {
                xmlCatalogPreferPublic = Boolean.FALSE;
            } else {
                if (!s.equals(VALUE_GLOBAL_DEFAULT)) throw new SettingException("The value of the " + StringUtil.jQuote(NAME_XML_CATALOG_PREFER) + " setting should be one of " + "\"" + VALUE_XML_CATALOG_PREFER_PUBLIC + "\", \"" + VALUE_XML_CATALOG_PREFER_SYSTEM + "\", \"" + VALUE_GLOBAL_DEFAULT + "\". Value " + StringUtil.jQuote(s) + " is invalid.");
                xmlCatalogPreferPublic = null;
            }
        } else {
            xmlCatalogPreferPublic = Boolean.TRUE;
        }
        List ls = (List)this.get(NAME_XML_CATALOG_FILES);
        if (ls != null) {
            try {
                this.loadXmlCatalogs(eng, ls, xmlCatalogPreferPublic, null);
            }
            catch (InstallationException e) {
                throw new SettingException("Failed to setup XML catalogs.", e);
            }
        }
        if ((b = (Boolean)this.get(NAME_VALIDATE_XML)) != null) {
            eng.setValidateXml(b);
        }
        if ((ls = (List)this.get(NAME_MODES)) != null) {
            try {
                Settings.loadProcessingModeChoosers(eng, ls);
            }
            catch (SettingException e) {
                throw new SettingException("Failed to apply the value of the \"modes\" setting.", e);
            }
        }
        if ((ls = (List)this.get(NAME_BORDERS)) != null) {
            try {
                Settings.loadBorderChoosers(eng, ls);
            }
            catch (SettingException e) {
                throw new SettingException("Failed to apply the value of the \"borders\" setting.", e);
            }
        }
        if ((ls = (List)this.get(NAME_TURNS)) != null) {
            try {
                Settings.loadTurnChoosers(eng, ls);
            }
            catch (SettingException e) {
                throw new SettingException("Failed to apply the value of the \"turns\" setting.", e);
            }
        }
        if ((ls = (List)this.get(NAME_REPLACE_EXTENSIONS)) != null) {
            try {
                Settings.loadReplaceExtensions(eng, ls);
            }
            catch (SettingException e) {
                throw new SettingException("Failed to apply the value of the \"replaceExtensions\" setting.", e);
            }
        }
        if ((ls = (List)this.get(NAME_REMOVE_EXTENSIONS)) != null) {
            try {
                Settings.loadRemoveExtensions(eng, ls);
            }
            catch (SettingException e) {
                throw new SettingException("Failed to apply the value of the \"removeExtensions\" setting.", e);
            }
        }
        if ((ls = (List)this.get(NAME_REMOVE_POSTFIXES)) != null) {
            try {
                Settings.loadRemovePostfixes(eng, ls);
            }
            catch (SettingException e) {
                throw new SettingException("Failed to apply the value of the \"removePostfixes\" setting.", e);
            }
        }
        if ((s = (String)this.get(NAME_SKIP_UNCHANGED)) != null) {
            if (s.equalsIgnoreCase(VALUE_NONE)) {
                eng.setSkipUnchanged(0);
            } else if (s.equalsIgnoreCase("all")) {
                eng.setSkipUnchanged(2);
            } else {
                if (!s.equalsIgnoreCase("static")) throw new SettingException("The value of the \"skipUnchanged\" setting can't be " + StringUtil.jQuote(s) + ". " + "It should be one of: none, all, static");
                eng.setSkipUnchanged(1);
            }
        }
        File outputFile = (File)this.get(NAME_OUTPUT_FILE);
        ArrayList<File> sources = (ArrayList<File>)this.get(NAME_SOURCES);
        if (sources != null) {
            sources = new ArrayList<File>(sources);
        }
        if (outputFile != null) {
            try {
                outputFile = outputFile.getCanonicalFile();
            }
            catch (IOException e) {
                throw new SettingException("Failed to bring the output file path to canonical form: " + outputFile.getPath(), e);
            }
            if (outputFile.exists() && outputFile.isDirectory()) {
                throw new SettingException("The output file can't be a directory: " + outputFile.getPath());
            }
            if (sources == null || sources.size() != 1) {
                throw new SettingException("Since you have set the \"outputFile\" setting, you must give exactly 1 source file. " + (sources == null || sources.size() == 0 ? "But there was no source file specified." : "But there were specified " + sources.size() + " source files."));
            }
            sourceFile = (FileWithConfigurationBase)sources.get(0);
            if (!sourceFile.isAbsolute()) {
                sourceFile = new File(((FileWithConfigurationBase)sourceFile).getConfigurationBase(), sourceFile.getPath());
            }
            try {
                sourceFile = sourceFile.getCanonicalFile();
            }
            catch (IOException e) {
                throw new SettingException("Failed to bring the source file path to canonical form: " + sourceFile.getPath(), e);
            }
            if (!sourceFile.exists()) {
                throw new SettingException("Source file not found: " + sourceFile.getPath());
            }
            if (sourceFile.isDirectory()) {
                throw new SettingException("This source file is not a file, but a directory: " + sourceFile.getPath());
            }
            if (!sourceFile.isFile()) {
                throw new SettingException("This source file is not a file: " + sourceFile.getPath());
            }
        } else {
            sourceFile = null;
        }
        if ((f = (File)this.get(NAME_SOURCE_ROOT)) == null) {
            if (sourceFile == null) throw new SettingException("The \"sourceRoot\" setting was not set. FMPP can't start working without that.");
            try {
                eng.setSourceRoot(sourceFile.getParentFile());
            }
            catch (IOException e) {
                throw new SettingException("Failed to apply the \"sourceRoot\" setting.", e);
            }
        }
        if (!f.exists()) {
            throw new SettingException("Source root directory not found: " + f.getPath());
        }
        if (!f.isDirectory()) {
            throw new SettingException("This source root directory is not a directoy: " + f.getPath());
        }
        try {
            eng.setSourceRoot(f);
        }
        catch (IOException e) {
            throw new SettingException("Failed to apply the \"sourceRoot\" setting.", e);
        }
        if (outputFile == null && sources != null) {
            f = eng.getSourceRoot();
            for (i = 0; i < sources.size(); ++i) {
                File sf = (File)sources.get(i);
                if (!sf.isAbsolute()) {
                    sf = new File(f, sf.getPath());
                    sources.set(i, sf);
                }
                if (i >= 4 || sf.exists()) continue;
                throw new SettingException("Source file or directory not found: " + ((File)sources.get(i)).getAbsolutePath());
            }
        }
        if ((f = (File)this.get(NAME_OUTPUT_ROOT)) == null) {
            if (outputFile == null) throw new SettingException("The \"outputRoot\" setting was not set. FMPP can't start working without that.");
            try {
                eng.setOutputRoot(outputFile.getParentFile());
            }
            catch (IOException e) {
                throw new SettingException("Failed to apply the \"outputRoot\" setting.", e);
            }
        }
        if (f.exists() && !f.isDirectory()) {
            throw new SettingException("This output root directory is not a directoy: " + f.getPath());
        }
        try {
            eng.setOutputRoot(f);
        }
        catch (IOException e) {
            throw new SettingException("Failed to apply the \"outputRoot\" setting.", e);
        }
        if (sources == null) {
            sources = new ArrayList(1);
            sources.add(eng.getSourceRoot());
        }
        if (!((f = (File)this.get(NAME_DATA_ROOT)) == null || f instanceof FileWithSettingValue && ((FileWithSettingValue)f).getSettingValue().equals(VALUE_SOURCE))) {
            try {
                eng.setDataRoot(f);
            }
            catch (IOException e) {
                throw new SettingException("Failed to apply the \"outputRoot\" setting.", e);
            }
        }
        if (!eng.getExpertMode()) {
            try {
                if (outputFile == null) {
                    if (eng.getSourceRoot().getCanonicalFile().equals(eng.getOutputRoot().getCanonicalFile())) {
                        throw new SettingException("Safety error! The source root and output root directories are identical. If this is intentional, use expert mode to allow this. (Set the \"expert\" setting to true.)");
                    }
                } else if (outputFile.getCanonicalFile().equals(sourceFile.getCanonicalFile())) {
                    throw new SettingException("Safety error! The source and output files are identical. If this is intentional, use expert mode to allow this. (Set the \"expert\" setting to true.)");
                }
            }
            catch (IOException e) {
                throw new SettingException("Unexpected path canonicalization error.", e);
            }
        }
        if ((m = (Map)this.get(NAME_FREEMARKER_LINKS)) != null) {
            try {
                Settings.loadFreemarkerLinks(eng, m);
            }
            catch (Exception e) {
                throw new SettingException("Failed to apply the \"freemarkerLinks\" setting.", e);
            }
        }
        if ((ls = (List)this.get(NAME_XML_RENDERINGS)) != null && ls.size() != 0) {
            try {
                this.loadXmlRenderings(eng, ls);
            }
            catch (InstallationException e) {
                throw new SettingException("Failed to apply the \"xmlRenderings\" setting.", e);
            }
        }
        Iterator it = this.engineAttributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            eng.setAttribute((String)ent.getKey(), ent.getValue());
        }
        it = this.progressListeners.iterator();
        while (it.hasNext()) {
            eng.addProgressListener((ProgressListener)((Object)it.next()));
        }
        ls = (List)this.get(NAME_DATA);
        if (ls != null) {
            eng.clearData();
            HashMap dataModel = new HashMap();
            for (i = 0; i < ls.size(); ++i) {
                Object e = ls.get(i);
                if (e instanceof String) {
                    try {
                        dataModel.putAll(fmpp.tdd.Interpreter.evalAsHash((String)e, new DataLoaderEvaluationEnvironment(eng), false, null));
                        continue;
                    }
                    catch (EvalException e2) {
                        throw new SettingException("Failed to apply the value of the \"data\" setting.", e2);
                    }
                }
                if (e instanceof Fragment) {
                    Fragment fr = (Fragment)e;
                    try {
                        Object object = fmpp.tdd.Interpreter.eval(fr, new DataLoaderEvaluationEnvironment(eng), false);
                        if (object instanceof Map) {
                            dataModel.putAll((Map)object);
                            continue;
                        }
                        if (object == null) continue;
                        throw new SettingException("The value of the \"data\" setting should be a hash, but it is a " + Settings.typeName(object) + " in " + fr.getFileName() + ".");
                    }
                    catch (EvalException e3) {
                        throw new SettingException("Failed to apply the value of the \"data\" setting.", e3);
                    }
                }
                if (!(e instanceof Map)) throw new BugException("Delayed step call can't be " + e.getClass().getName());
                dataModel.putAll((Map)e);
            }
            eng.addData(dataModel);
        }
        if ((s = (String)this.get(NAME_TEMPLATE_DATA)) != null) {
            try {
                eng.setTemplateDataModelBuilder(s);
            }
            catch (DataModelBuildingException e) {
                throw new SettingException("Failed to apply the value of the \"templateData\" setting.", e);
            }
        }
        if ((ls = (List)this.get(NAME_LOCAL_DATA)) != null) {
            eng.clearLocalDataBuilders();
            int layer = 0;
            boolean bl = false;
            for (i = 0; i < ls.size(); ++i) {
                boolean bl2;
                Object o = ls.get(i);
                if (!(o instanceof FunctionCall)) {
                    throw new SettingException("The value of the \"localData\" setting must be a sequence of TDD function calls, but there is an item of type " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
                }
                FunctionCall fc = (FunctionCall)o;
                if (fc.getName().equals(FUNCTION_LAYER)) {
                    if (fc.getParams().size() != 0) {
                        throw new SettingException("Problem with the value of the \"localData\" setting: Function \"layer\" doesn't allow arguments, but now it has " + fc.getParams().size() + " argument(s).");
                    }
                    if (!bl2) continue;
                    ++layer;
                    bl2 = false;
                    continue;
                }
                if (!fc.getName().equals(FUNCTION_CASE)) throw new SettingException("Sequence items in the \"localData\" setting must be a sequence of TDD function calls to \"layer\" or \"case\", but there is a call to " + StringUtil.jQuote(fc.getName()) + ".");
                bl2 = true;
                List params = fc.getParams();
                int paramCnt = params.size();
                if (paramCnt < 2) {
                    throw new SettingException("Problem with the value of the \"localData\" setting: Function call to \"case\" needs at least 2 parameters: pathPattern, data");
                }
                o = params.get(params.size() - 1);
                if (o instanceof String) {
                    Object bo;
                    Interpreter bship = new Interpreter();
                    try {
                        bship.set("engine", (Object)eng);
                        bo = bship.eval((String)o);
                    }
                    catch (EvalError e) {
                        throw new SettingException("Problem with the value of the \"localData\" setting: Failed to evaluate BeanShell expression.", e);
                    }
                    if (!(bo instanceof LocalDataBuilder)) {
                        throw new SettingException("Problem with the value of the \"localData\" setting: BeanShell expression " + StringUtil.jQuote((String)o) + " evaluates to an object which " + (o != null ? "doesn't implement " + (class$fmpp$LocalDataBuilder == null ? (class$fmpp$LocalDataBuilder = Settings.class$("fmpp.LocalDataBuilder")) : class$fmpp$LocalDataBuilder).getName() + ". (The class of the object is: " + o.getClass().getName() + ")" : "is null."));
                    }
                    LocalDataBuilder localDataBuilder = (LocalDataBuilder)bo;
                } else if (o instanceof Fragment) {
                    TddHashLocalDataBuilder tddHashLocalDataBuilder = new TddHashLocalDataBuilder((Fragment)o);
                } else if (o instanceof Map) {
                    MapLocalDataBuilder mapLocalDataBuilder = new MapLocalDataBuilder((Map)o);
                } else {
                    if (!(o instanceof FunctionCall)) throw new SettingException("Problem with the value of the \"localData\" setting: The last parameter to function \"case\" must be a function call or a hash, but now it was a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
                    FunctionCall fc2 = (FunctionCall)o;
                    String name = fc2.getName();
                    if (!name.equals(LOCAL_DATA_BUILDER_BSH)) throw new SettingException("Problem with the value of the \"localData\" setting: function call as the last parameter to \"case\" must refer to a predefined local data builder, but there is no predefined local data builder with name \"" + fc2.getName() + "\".");
                    try {
                        BshLocalDataBuilder bshLocalDataBuilder = BshLocalDataBuilder.createInstanceForSetting(name, fc2.getParams());
                    }
                    catch (SettingException e) {
                        throw new SettingException("Problem with the value of the \"localData\" setting.", e);
                    }
                }
                for (int x = 0; x < paramCnt - 1; ++x) {
                    void var19_46;
                    o = params.get(x);
                    if (!(o instanceof String)) {
                        throw new SettingException("Problem with the value of the \"localData\" setting: Parameters before the last parameter to function \"case\" must be strings (path patterns), but parameter at position " + (x + 1) + " is a " + (o instanceof Fragment ? "hash" : fmpp.tdd.Interpreter.getTypeName(o)) + ".");
                    }
                    eng.addLocalDataBuilder(layer, (String)o, (LocalDataBuilder)var19_46);
                }
            }
        }
        if (outputFile == null) {
            int ln = sources.size();
            File[] fileArray = new File[ln];
            for (i = 0; i < ln; ++i) {
                fileArray[i] = (File)sources.get(i);
            }
            this.doProcessing(eng, fileArray, null, null);
            return;
        } else {
            this.doProcessing(eng, null, sourceFile, outputFile);
        }
    }

    private void addOrSet(Map m, String name, Object value, boolean set) throws SettingException {
        Object oldValue;
        SettingDefinition def = (SettingDefinition)this.defs.get(name);
        if (def == null) {
            throw this.newUnknownSettingException(name);
        }
        try {
            value = def.type.convert(this, value);
        }
        catch (SettingException e) {
            throw new SettingException("Problem with the value of setting " + StringUtil.jQuote(name) + ": " + e.getMessage(), e.getCause());
        }
        if (!set && def.merge && (oldValue = m.get(name)) != null) {
            try {
                value = def.type.merge(this, oldValue, value);
            }
            catch (SettingException e) {
                throw new SettingException("Problem with the value of setting " + StringUtil.jQuote(name) + ": " + e.getMessage(), e.getCause());
            }
        }
        m.put(name, value);
    }

    private void addOrSetDefault(Map m, String name, Object value, boolean set) throws SettingException {
        SettingDefinition def = (SettingDefinition)this.defs.get(name);
        if (def == null) {
            throw this.newUnknownSettingException(name);
        }
        try {
            value = def.type.convert(this, value);
        }
        catch (SettingException e) {
            throw new SettingException("Problem with the value of setting " + StringUtil.jQuote(name) + ": " + e.getMessage(), e.getCause());
        }
        Object oldValue = m.get(name);
        if (oldValue != null) {
            if (!set && def.merge) {
                try {
                    value = def.type.merge(this, value, oldValue);
                }
                catch (SettingException e) {
                    throw new SettingException("Problem with the value of setting " + StringUtil.jQuote(name) + ": " + e.getMessage(), e.getCause());
                }
            } else {
                return;
            }
        }
        m.put(name, value);
    }

    private void addOrSetWithString(Map m, String name, String value, boolean set) throws SettingException {
        this.addOrSet(m, name, this.translateProperty(name, value), set);
    }

    private void addOrSetDefaultWithString(Map m, String name, String value, boolean set) throws SettingException {
        this.addOrSetDefault(m, name, this.translateProperty(name, value), set);
    }

    private void addOrSet(Map settingMap, boolean set) throws SettingException {
        HashMap changed = new HashMap();
        Iterator it = settingMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            String name = (String)ent.getKey();
            Object value = ent.getValue();
            Object oldValue = this.values.get(name);
            if (oldValue != null) {
                changed.put(name, oldValue);
            }
            this.addOrSet(changed, name, value, set);
        }
        this.values.putAll(changed);
    }

    private void addOrSetDefaults(Map settingMap, boolean set) throws SettingException {
        HashMap changed = new HashMap();
        Iterator it = settingMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            String name = (String)ent.getKey();
            Object value = ent.getValue();
            Object oldValue = this.values.get(name);
            if (oldValue != null) {
                changed.put(name, oldValue);
            }
            this.addOrSetDefault(changed, name, value, set);
        }
        this.values.putAll(changed);
    }

    private void addOrSetWithStrings(Properties props, boolean set) throws SettingException {
        HashMap changed = new HashMap();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = props.getProperty(name);
            Object oldValue = this.values.get(name);
            if (oldValue != null) {
                changed.put(name, oldValue);
            }
            this.addOrSetWithString(changed, name, value, set);
        }
        this.values.putAll(changed);
    }

    private void addOrSetDefaultsWithStrings(Properties props, boolean set) throws SettingException {
        HashMap changed = new HashMap();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = props.getProperty(name);
            Object oldValue = this.values.get(name);
            if (oldValue != null) {
                changed.put(name, oldValue);
            }
            this.addOrSetDefaultWithString(changed, name, value, set);
        }
        this.values.putAll(changed);
    }

    private Object translateProperty(String name, String value) throws SettingException {
        SettingDefinition def = (SettingDefinition)this.defs.get(name);
        if (def == null) {
            throw this.newUnknownSettingException(name);
        }
        try {
            return def.type.convertString(this, value, def.forceStr);
        }
        catch (SettingException e) {
            throw new SettingException("Problem with the value of setting " + StringUtil.jQuote(name) + ": " + e.getMessage(), e.getCause());
        }
    }

    private SettingException newUnknownSettingException(String name) {
        String s = this.findSimilar(name);
        if (s == null) {
            return new SettingException("Unknown setting " + StringUtil.jQuote(name) + ".");
        }
        return new SettingException("Unknown setting " + StringUtil.jQuote(name) + ". Maybe you meant to write " + StringUtil.jQuote(s) + ".");
    }

    public static String getDashedName(String name) {
        int ln = name.length();
        StringBuffer sb = new StringBuffer(ln + 4);
        for (int i = 0; i < ln; ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("-");
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String findSimilar(String name) {
        String lName;
        String dName;
        String s = (String)this.cmdLineNames.get(name);
        if (s != null) {
            return s;
        }
        String lNameV1 = name.toLowerCase();
        String lNameV2 = lNameV1 + "s";
        String lNameV3 = lNameV1 + "es";
        String lNameV4 = lNameV1.endsWith("s") ? lNameV1.substring(0, lNameV1.length() - 1) : null;
        String lNameV5 = lNameV1.endsWith("es") ? lNameV1.substring(0, lNameV1.length() - 2) : null;
        Iterator it = this.defs.keySet().iterator();
        while (it.hasNext()) {
            dName = (String)it.next();
            lName = dName.toLowerCase();
            if (!lName.equals(lNameV1) && !lName.equals(lNameV2) && !lName.equals(lNameV3) && (lNameV4 == null || !lName.equals(lNameV4)) && (lNameV5 == null || !lName.equals(lNameV5))) continue;
            return dName;
        }
        it = this.cmdLineNames.keySet().iterator();
        while (it.hasNext()) {
            dName = (String)it.next();
            lName = dName.toLowerCase();
            if (!lName.equals(lNameV1) && !lName.equals(lNameV2) && !lName.equals(lNameV3) && (lNameV4 == null || !lName.equals(lNameV4)) && (lNameV5 == null || !lName.equals(lNameV5))) continue;
            return dName;
        }
        return null;
    }

    private static void stdDef(String name, SettingType type, boolean merge, boolean forceStr) {
        SettingDefinition def = new SettingDefinition(name, type, merge, forceStr);
        if (STD_DEFS.containsKey(def.name)) {
            throw new BugException("Setting " + StringUtil.jQuote(def.name) + " is already defined.");
        }
        STD_DEFS.put(def.name, def);
        STD_STDCMDL.put(Settings.getDashedName(def.name), def.name);
    }

    private static String typeName(Object value) {
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof List || value.getClass().isArray() || value instanceof Vector) {
            return "sequence";
        }
        if (value instanceof Map || value instanceof Dictionary) {
            return "hash";
        }
        if (value instanceof FunctionCall) {
            return "function call";
        }
        return value.getClass().getName();
    }

    public static void fixVersion08SettingNames(Properties props) throws SettingException {
        Settings.fixOldSettingName(props, OLD_NAME_REMOVE_EXTENSION, NAME_REMOVE_EXTENSIONS);
        Settings.fixOldSettingName(props, OLD_NAME_REMOVE_POSTFIX, NAME_REMOVE_POSTFIXES);
        Settings.fixOldSettingName(props, OLD_NAME_REPLACE_EXTENSION, NAME_REPLACE_EXTENSIONS);
    }

    private static void fixOldSettingName(Properties props, String oldName, String newName) throws SettingException {
        Settings.fixOldSettingName_inner(props, oldName, newName);
        Settings.fixOldSettingName_inner(props, Settings.getDashedName(oldName), Settings.getDashedName(newName));
    }

    private static void fixOldSettingName_inner(Properties props, String oldName, String newName) throws SettingException {
        String s = props.getProperty(oldName);
        if (s != null) {
            props.remove(oldName);
            s = (String)props.setProperty(newName, s);
            if (s != null) {
                throw new SettingException("Old and new setting names are used together: Old \"" + oldName + "\" and new (use this!) \"" + newName + "\".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load_common(File cfgFile, boolean defaults) throws SettingException {
        File baseOverride = (File)this.get(NAME_CONFIGURATION_BASE);
        File inheritOverride = (File)this.get(NAME_INHERIT_CONFIGURATION);
        HashMap savedSettings = this.values;
        boolean done = false;
        try {
            this.values = new HashMap();
            this.load_inner(cfgFile, false, baseOverride, inheritOverride);
            done = true;
        }
        finally {
            if (done) {
                Map newSettings = this.values;
                this.values = savedSettings;
                savedSettings = new HashMap(this.values);
                done = false;
                try {
                    if (defaults) {
                        this.addDefaults(newSettings);
                    } else {
                        this.add(newSettings);
                    }
                    done = true;
                }
                finally {
                    if (!done) {
                        this.values = savedSettings;
                    }
                }
            } else {
                this.values = savedSettings;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load_inner(File cfgFile, boolean inherited, File baseOverride, File inheritOverride) throws SettingException {
        if (cfgFile instanceof FileWithSettingValue && ((FileWithSettingValue)cfgFile).getSettingValue().equals(VALUE_NONE)) {
            return;
        }
        try {
            Map loaded;
            String s;
            boolean tddMode;
            File f;
            if (cfgFile.isDirectory()) {
                f = new File(cfgFile, DEFAULT_CFG_FILE_NAME);
                if (!f.exists()) {
                    f = new File(cfgFile, DEFAULT_CFG_FILE_NAME_OLD);
                    if (!f.exists()) {
                        throw new IOException("No file with name \"config.fmpp\" or \"fmpp.cfg\" exists in this directory: " + cfgFile.getAbsolutePath());
                    }
                    cfgFile = f;
                } else {
                    cfgFile = f;
                }
            }
            boolean bl = tddMode = !(s = (cfgFile = cfgFile.getCanonicalFile()).getName().toLowerCase()).endsWith(".cfg") && !s.endsWith(".properties");
            if (tddMode) {
                String text;
                FileInputStream in = new FileInputStream(cfgFile);
                try {
                    text = fmpp.tdd.Interpreter.loadTdd(in, "ISO-8859-1");
                }
                finally {
                    ((InputStream)in).close();
                }
                FirstPhaseEvaluationEnvironment ee = new FirstPhaseEvaluationEnvironment(this);
                loaded = fmpp.tdd.Interpreter.evalAsHash(text, ee, false, cfgFile.getAbsolutePath());
            } else {
                Properties props = new Properties();
                FileInputStream in = new FileInputStream(cfgFile);
                try {
                    props.load(in);
                }
                finally {
                    ((InputStream)in).close();
                }
                Settings.fixVersion08SettingNames(props);
                this.undashNames(props);
                this.trimValues(props);
                loaded = props;
            }
            File oldBaseDir = this.baseDir;
            try {
                if (baseOverride != null) {
                    this.baseDir = baseOverride;
                } else {
                    this.baseDir = cfgFile.getParentFile().getCanonicalFile();
                    f = this.load_getMetaSetting(loaded, NAME_CONFIGURATION_BASE, tddMode);
                    if (f != null) {
                        this.baseDir = f;
                    }
                }
                loaded.remove(NAME_CONFIGURATION_BASE);
                if (!tddMode) {
                    loaded.remove(Settings.getDashedName(NAME_CONFIGURATION_BASE));
                }
                File inherit = inheritOverride != null ? inheritOverride : this.load_getMetaSetting(loaded, NAME_INHERIT_CONFIGURATION, tddMode);
                loaded.remove(NAME_INHERIT_CONFIGURATION);
                if (!tddMode) {
                    loaded.remove(Settings.getDashedName(NAME_INHERIT_CONFIGURATION));
                }
                if (inherited) {
                    if (tddMode) {
                        this.addDefaults(loaded);
                    } else {
                        this.addDefaultsWithStrings((Properties)loaded);
                    }
                } else if (tddMode) {
                    this.add(loaded);
                } else {
                    this.addWithStrings((Properties)loaded);
                }
                if (inherit != null) {
                    this.load_inner(inherit, true, null, null);
                }
            }
            finally {
                this.baseDir = oldBaseDir;
            }
        }
        catch (Throwable e) {
            throw new SettingException((inherited ? "Error loading inherited configuration file: " : "Error loading configuration file: ") + cfgFile.getAbsolutePath(), e);
        }
    }

    private File load_getMetaSetting(Map m, String name, boolean tddMode) throws SettingException, IOException {
        Object o = m.get(name);
        if (!tddMode) {
            Object o2 = m.get(Settings.getDashedName(name));
            if (o == null) {
                o = o2;
            } else if (o2 != null) {
                throw new SettingException("Setting " + StringUtil.jQuote(name) + " was specified twice, with different names: " + StringUtil.jQuote(name) + " and " + StringUtil.jQuote(Settings.getDashedName(name)) + ".");
            }
        }
        if (o != null) {
            if (!(o instanceof String)) {
                throw new SettingException("Setting " + StringUtil.jQuote(name) + " must be a string (a path), but now it was a(n) " + Settings.typeName(o) + ".");
            }
            File f = new File((String)o);
            if (f.isAbsolute()) {
                return new FileWithSettingValue(f.getCanonicalPath(), (String)o);
            }
            return new FileWithSettingValue(new File(this.baseDir, f.getPath()).getCanonicalPath(), (String)o);
        }
        return null;
    }

    private static void loadBorderChoosers(Engine eng, List ls) throws SettingException {
        eng.clearFooterChoosers();
        eng.clearHeaderChoosers();
        int layer = 0;
        boolean layerUsed = false;
        Iterator it = ls.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof FunctionCall)) {
                throw new SettingException("All top-level sequence items must be function calls, but one of them is a(n) " + Settings.typeName(obj) + ".");
            }
            FunctionCall f = (FunctionCall)obj;
            List params = f.getParams();
            Iterator it2 = params.iterator();
            while (it2.hasNext()) {
                obj = it2.next();
                if (obj instanceof String) continue;
                throw new SettingException("All function call arguments must be strings, but one of them is a(n) " + Settings.typeName(obj) + ".");
            }
            String header = null;
            String footer = null;
            int i = 0;
            if (f.getName().equals("header")) {
                if (params.size() < 1) {
                    throw new SettingException("\"header\" function call needs at least 1 argument.");
                }
                header = (String)params.get(i++);
            } else if (f.getName().equals("footer")) {
                if (params.size() < 1) {
                    throw new SettingException("\"footer\" function call needs at least 1 argument.");
                }
                footer = (String)params.get(i++);
            } else if (f.getName().equals("border")) {
                if (params.size() < 2) {
                    throw new SettingException("\"border\" function call needs at least 2 arguments, but it has " + params.size() + " argument(s).");
                }
                header = (String)params.get(i++);
                footer = (String)params.get(i++);
            } else if (f.getName().equals(FUNCTION_LAYER)) {
                if (params.size() != 0) {
                    throw new SettingException("\"layer\" function call doesn't allow arguments, but now it has " + params.size() + " argument(s).");
                }
                if (layerUsed) {
                    ++layer;
                    layerUsed = false;
                }
            } else {
                throw new SettingException("Invalid function: \"" + f.getName() + "\". " + "Function should be one of: " + "\"header\", \"footer\", \"border\", \"" + FUNCTION_LAYER + "\".");
            }
            if (header == null && footer == null) continue;
            layerUsed = true;
            try {
                if (i == params.size()) {
                    if (header != null) {
                        eng.addHeaderChooser(layer, "**", header);
                    }
                    if (footer == null) continue;
                    eng.addFooterChooser(layer, "**", footer);
                    continue;
                }
                while (i < params.size()) {
                    if (header != null) {
                        eng.addHeaderChooser(layer, (String)params.get(i), header);
                    }
                    if (footer != null) {
                        eng.addFooterChooser(layer, (String)params.get(i), footer);
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException e) {
                throw new SettingException("FMPP engine rejects the value.", e);
            }
        }
    }

    private static void loadTurnChoosers(Engine eng, List ls) throws SettingException {
        eng.clearTurnChoosers();
        Iterator it = ls.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof FunctionCall)) {
                throw new SettingException("All top-level sequence items must be function calls, but one of them is a(n) " + Settings.typeName(obj) + ".");
            }
            FunctionCall f = (FunctionCall)obj;
            if (!f.getName().equals("turn")) {
                throw new SettingException("Only \"turn\" function allowed here, not " + StringUtil.jQuote(f.getName()));
            }
            List params = f.getParams();
            if (params.size() < 2) {
                throw new SettingException("\"turn\" function call needs at least two parameters, but it has " + params.size() + " parameter(s).");
            }
            obj = params.get(0);
            if (!(obj instanceof Integer)) {
                throw new SettingException("The first argument to \"turn\" function call must be an integer, but it is a(n) " + Settings.typeName(obj) + ".");
            }
            int turn = (Integer)obj;
            for (int i = 1; i < params.size(); ++i) {
                obj = params.get(i);
                if (!(obj instanceof String)) {
                    throw new SettingException("The arguments to \"turn\" function call after the first argument must be strings, but one of them is a(n) " + Settings.typeName(obj) + ".");
                }
                try {
                    eng.addTurnChooser((String)obj, turn);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new SettingException("FMPP engine rejects the value.", e);
                }
            }
        }
    }

    private static void loadRemoveExtensions(Engine eng, List ls) throws SettingException {
        eng.clearRemoveExtensions();
        Iterator it = ls.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof String)) {
                throw new SettingException("All sequence items must be strings, but one of the items is a(n) " + Settings.typeName(obj) + ".");
            }
            try {
                eng.addRemoveExtension((String)obj);
            }
            catch (IllegalArgumentException e) {
                throw new SettingException("FMPP engine rejects the value.", e);
            }
        }
    }

    private static void loadReplaceExtensions(Engine eng, List ls) throws SettingException {
        if (ls.size() % 2 != 0) {
            throw new SettingException("The number of elements in the sequence must be even, but it is " + ls.size() + ".");
        }
        eng.clearReplaceExtensions();
        Iterator it = ls.iterator();
        while (it.hasNext()) {
            Object obj1 = it.next();
            if (!(obj1 instanceof String)) {
                throw new SettingException("All sequence items must be strings, but one of them is a(n) " + Settings.typeName(obj1) + ".");
            }
            Object obj2 = it.next();
            if (!(obj2 instanceof String)) {
                throw new SettingException("All sequence items must be strings, but one of them is a(n) " + Settings.typeName(obj2) + ".");
            }
            try {
                eng.addReplaceExtension((String)obj1, (String)obj2);
            }
            catch (IllegalArgumentException e) {
                throw new SettingException("FMPP engine rejects the value.", e);
            }
        }
    }

    private static void loadRemovePostfixes(Engine eng, List ls) throws SettingException {
        eng.clearRemovePostfixes();
        Iterator it = ls.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof String)) {
                throw new SettingException("All sequence items must be strings, but one of them is a(n) " + Settings.typeName(obj) + ".");
            }
            try {
                eng.addRemovePostfix((String)obj);
            }
            catch (IllegalArgumentException e) {
                throw new SettingException("FMPP engine rejects the value.", e);
            }
        }
    }

    private static void loadProcessingModeChoosers(Engine eng, List ls) throws SettingException {
        eng.clearModeChoosers();
        Iterator it = ls.iterator();
        while (it.hasNext()) {
            int pmode;
            Object obj = it.next();
            if (!(obj instanceof FunctionCall)) {
                throw new SettingException("All sequence items must be function calls, but one of them is a(n) " + Settings.typeName(obj) + ".");
            }
            FunctionCall f = (FunctionCall)obj;
            if (f.getName().equals("execute")) {
                pmode = 1;
            } else if (f.getName().equals("copy")) {
                pmode = 2;
            } else if (f.getName().equals("ignore")) {
                pmode = 3;
            } else if (f.getName().equals("renderXml")) {
                pmode = 4;
            } else {
                throw new SettingException("Invalid function: \"" + f.getName() + "\". " + "Function should be one of: " + "\"execute\", \"copy\", \"ignore\".");
            }
            List paths = f.getParams();
            Iterator it2 = paths.iterator();
            while (it2.hasNext()) {
                obj = it2.next();
                if (!(obj instanceof String)) {
                    throw new SettingException("Arguments to \"" + f.getName() + "\" function must be strings, but " + "one of them is a(n) " + Settings.typeName(obj) + ".");
                }
                try {
                    eng.addModeChooser((String)obj, pmode);
                }
                catch (IllegalArgumentException e) {
                    throw new SettingException("FMPP engine rejects the value.", e);
                }
            }
        }
    }

    private static void loadFreemarkerLinks(Engine eng, Map m) throws IOException, SettingException {
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            String name = (String)ent.getKey();
            if (name.startsWith("@")) {
                throw new SettingException("The FreeMarker link name itself can't start with @. The @ prefix is used only when you refer to a FreeMarker link. For example, if the link name is \"foo\", then you can refer to it as <#include '/@foo/something.ftl'>.");
            }
            List files = (List)ent.getValue();
            int ln = files.size();
            for (int i = 0; i < ln; ++i) {
                eng.addFreemarkerLink(name, (File)files.get(i));
            }
        }
    }

    private void loadXmlCatalogs(Engine eng, List ls, Boolean preferPublic, Boolean allowCatalogPI) throws InstallationException {
        StringBuffer catalogs = new StringBuffer();
        Iterator it = ls.iterator();
        while (it.hasNext()) {
            catalogs.append(((File)it.next()).getAbsolutePath());
            if (!it.hasNext()) continue;
            catalogs.append(';');
        }
        XmlDependentOps xmlOps = this.getXmlDependentOps("Setup XML catalogs.");
        eng.setXmlEntityResolver(xmlOps.createCatalogResolver(catalogs.toString(), preferPublic, allowCatalogPI));
    }

    private void loadXmlRenderings(Engine eng, List ls) throws SettingException, InstallationException {
        Iterator it = ls.iterator();
        XmlDependentOps xmlOps = this.getXmlDependentOps("Setup XML renderings.");
        while (it.hasNext()) {
            String defaultXmlns;
            Map xmlns;
            boolean copy;
            Object o = it.next();
            if (!(o instanceof Map)) {
                throw new SettingException("Problem with the value of a sequence item of the \"xmlRenderings\" setting: The items of the sequence must be hashes, but one of the items is a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
            }
            Map m = (Map)o;
            XmlRenderingConfiguration xrc = new XmlRenderingConfiguration();
            o = m.get("copy");
            if (o == null) {
                copy = false;
            } else {
                if (!(o instanceof Boolean)) {
                    throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: The value of the \"copy\" option must be a boolean, but now it was a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
                }
                copy = (Boolean)o;
            }
            xrc.setCopy(copy);
            o = m.get("template");
            if (o == null) {
                if (!copy) {
                    throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: The \"template\" option must be specified, since the \"copy\" option is unspecified or false.");
                }
            } else {
                if (copy) {
                    throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: You can't use the \"template\" option together with the \"copy\" option.");
                }
                if (!(o instanceof String)) {
                    throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: The value of the \"template\" option must be a string, but now it was a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
                }
                xrc.setTemplate((String)o);
            }
            if ((o = m.get("xmlns")) != null) {
                if (!(o instanceof Map)) {
                    throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: The value of the \"xmlns\" option must be a hash, but now it was a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
                }
                xmlns = (Map)o;
                if ((o = xmlns.get("D")) != null && !(o instanceof String)) {
                    throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: The values stored in the \"xmlns\" map must be strings, but \"D\" is a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
                }
                defaultXmlns = (String)o;
            } else {
                xmlns = null;
                defaultXmlns = null;
            }
            Iterator it2 = m.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry ent = it2.next();
                String name = (String)ent.getKey();
                Object value = ent.getValue();
                if (name.equals("template") || name.equals("copy")) continue;
                if (name.equals("ifSourceIs")) {
                    if (!(value instanceof List)) {
                        o = new ArrayList(1);
                        ((List)o).add(value);
                        value = o;
                    }
                    Iterator sourcesIt = ((List)value).iterator();
                    while (sourcesIt.hasNext()) {
                        o = sourcesIt.next();
                        if (!(o instanceof String)) {
                            throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: The value of the \"ifSourceIs\" option must be a sequence of strings, but one of its items is a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
                        }
                        xrc.addSourcePathPattern((String)o);
                    }
                    continue;
                }
                if (name.equals("ifDocumentElementIs")) {
                    if (!(value instanceof List)) {
                        o = new ArrayList(1);
                        ((List)o).add(value);
                        value = o;
                    }
                    Iterator elementsIt = ((List)value).iterator();
                    while (elementsIt.hasNext()) {
                        o = elementsIt.next();
                        if (!(o instanceof String)) {
                            throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: The value of the \"ifDocumentElementIs\" option must be a sequence strings, but one of its items is a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
                        }
                        String s = (String)o;
                        int cidx = s.indexOf(58);
                        if (cidx == -1) {
                            xrc.addDocumentElement(defaultXmlns, s);
                            continue;
                        }
                        String prefix = s.substring(0, cidx);
                        Object e = o = xmlns == null ? null : (Object)xmlns.get(prefix);
                        if (o == null) {
                            throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: The value of the \"ifDocumentElementIs\" option uses the " + StringUtil.jQuote(prefix) + " XML name-space prefix, but that " + "prefix is not defined with the " + "\"xmlns\" option.");
                        }
                        if (!(o instanceof String)) {
                            throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: Prefixes defined with the \"xmlns\" option must be associated with strings, but the " + StringUtil.jQuote(prefix) + " prefix is associated with a " + fmpp.tdd.Interpreter.getTypeName(o) + ".");
                        }
                        xrc.addDocumentElement((String)o, s.substring(cidx + 1));
                    }
                    continue;
                }
                if (name.equals("localDataBuilder")) {
                    if (!(value instanceof List)) {
                        o = new ArrayList(1);
                        ((List)o).add(value);
                        value = o;
                    }
                    Iterator ldbIt = ((List)value).iterator();
                    while (ldbIt.hasNext()) {
                        o = ldbIt.next();
                        if (!(o instanceof String)) {
                            throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: The value of \"localDataBulder\" must be a string (a BeanShell expression) but now it was a " + fmpp.tdd.Interpreter.getTypeName(value) + ".");
                        }
                        Interpreter bship = new Interpreter();
                        try {
                            bship.set("engine", (Object)eng);
                            o = bship.eval((String)o);
                        }
                        catch (EvalError e) {
                            throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: Failed to evaluate the value of \"localDataBulder\" as BeanShell script.", e);
                        }
                        if (!(o instanceof LocalDataBuilder)) {
                            throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: Problem with the value of the \"localDataBulder\" option: BeanShell expression " + StringUtil.jQuote((String)value) + " evaluates to an object which " + (o != null ? "doesn't implement " + (class$fmpp$LocalDataBuilder == null ? (class$fmpp$LocalDataBuilder = Settings.class$("fmpp.LocalDataBuilder")) : class$fmpp$LocalDataBuilder).getName() + ". (The class of the " + "object is: " + o.getClass().getName() + ")" : "is null."));
                        }
                        xrc.addLocalDataBuilder((LocalDataBuilder)o);
                    }
                    continue;
                }
                if (!xmlOps.isXmlDataLoaderOption(name)) {
                    throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: Unknown option: " + name);
                }
                if (name.equals("namespaceAware") && Boolean.FALSE.equals(value)) {
                    throw new SettingException("Problem with the options of an XML rendering in the \"xmlRenderings\" setting: It's not allowed to set the \"namespaceAware\" option to false for XML renderings.");
                }
                xrc.addXmlDataLoaderOption(name, value);
            }
            eng.addXmlRenderingConfiguration(xrc);
        }
    }

    private XmlDependentOps getXmlDependentOps(String requiredForThis) throws InstallationException {
        if (this.xmlDependentOps == null) {
            Class cl;
            MiscUtil.checkXmlSupportAvailability(requiredForThis);
            try {
                cl = MiscUtil.classForName("fmpp.setting.XmlDependentOpsImpl");
            }
            catch (ClassNotFoundException e) {
                throw new BugException("Failed to get fmpp.setting.XmlDependentOpsImpl.", e);
            }
            catch (SecurityException e) {
                throw new BugException("Failed to get fmpp.setting.XmlDependentOpsImpl.", e);
            }
            try {
                this.xmlDependentOps = (XmlDependentOps)cl.newInstance();
            }
            catch (IllegalArgumentException e) {
                throw new BugException("Failed to instantiate fmpp.setting.XmlDependentOpsImpl", e);
            }
            catch (IllegalAccessException e) {
                throw new BugException("Failed to instantiate fmpp.setting.XmlDependentOpsImpl", e);
            }
            catch (InstantiationException e) {
                throw new BugException("Failed to instantiate fmpp.setting.XmlDependentOpsImpl", e);
            }
        }
        return this.xmlDependentOps;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Settings.stdDef(NAME_SKIP_UNCHANGED, TYPE_STRING, false, true);
        Settings.stdDef(NAME_TURNS, TYPE_SEQUENCE, true, false);
        Settings.stdDef(NAME_SOURCES, TYPE_UNRESOLVED_CFG_RELATIVE_PATHS, true, true);
        Settings.stdDef(NAME_SOURCE_ROOT, TYPE_CFG_RELATIVE_PATH, false, true);
        Settings.stdDef(NAME_OUTPUT_ROOT, TYPE_CFG_RELATIVE_PATH, false, true);
        Settings.stdDef(NAME_OUTPUT_FILE, TYPE_CFG_RELATIVE_PATH, false, true);
        Settings.stdDef(NAME_DATA_ROOT, TYPE_CFG_RELATIVE_PATH, false, true);
        Settings.stdDef(NAME_OBJECT_WRAPPER, TYPE_STRING, false, true);
        Settings.stdDef(NAME_FREEMARKER_LINKS, TYPE_HASH_OF_SEQUENCE_OF_CFG_RELATIVE_PATHS, true, true);
        Settings.stdDef(NAME_INHERIT_CONFIGURATION, TYPE_CFG_RELATIVE_PATH, false, true);
        Settings.stdDef(NAME_MODES, TYPE_SEQUENCE, true, true);
        Settings.stdDef(NAME_BORDERS, TYPE_SEQUENCE, true, true);
        Settings.stdDef(NAME_DATA, TYPE_DATA_MODEL, true, false);
        Settings.stdDef(NAME_LOCAL_DATA, TYPE_LOCAL_DATA_MODEL, true, false);
        Settings.stdDef(NAME_TEMPLATE_DATA, TYPE_STRING, false, true);
        Settings.stdDef(NAME_SOURCE_ENCODING, TYPE_STRING, false, true);
        Settings.stdDef(NAME_OUTPUT_ENCODING, TYPE_STRING, false, true);
        Settings.stdDef(NAME_URL_ESCAPING_CHARSET, TYPE_STRING, false, true);
        Settings.stdDef(NAME_LOCALE, TYPE_STRING, false, true);
        Settings.stdDef(NAME_NUMBER_FORMAT, TYPE_STRING, false, true);
        Settings.stdDef(NAME_DATE_FORMAT, TYPE_STRING, false, true);
        Settings.stdDef(NAME_TIME_FORMAT, TYPE_STRING, false, true);
        Settings.stdDef(NAME_DATETIME_FORMAT, TYPE_STRING, false, true);
        Settings.stdDef(NAME_TIME_ZONE, TYPE_STRING, false, true);
        Settings.stdDef(NAME_TAG_SYNTAX, TYPE_STRING, false, true);
        Settings.stdDef(NAME_CASE_SENSITIVE, TYPE_BOOLEAN, false, false);
        Settings.stdDef(NAME_STOP_ON_ERROR, TYPE_BOOLEAN, false, false);
        Settings.stdDef(NAME_REMOVE_EXTENSIONS, TYPE_SEQUENCE, true, true);
        Settings.stdDef(NAME_REMOVE_POSTFIXES, TYPE_SEQUENCE, true, true);
        Settings.stdDef(NAME_REPLACE_EXTENSIONS, TYPE_SEQUENCE, true, true);
        Settings.stdDef(NAME_IGNORE_CVS_FILES, TYPE_BOOLEAN, false, false);
        Settings.stdDef(NAME_IGNORE_SVN_FILES, TYPE_BOOLEAN, false, false);
        Settings.stdDef(NAME_IGNORE_TEMPORARY_FILES, TYPE_BOOLEAN, false, false);
        Settings.stdDef(NAME_EXPERT, TYPE_BOOLEAN, false, false);
        Settings.stdDef(NAME_LOG_FILE, TYPE_CFG_RELATIVE_PATH, false, true);
        Settings.stdDef(NAME_APPEND_LOG_FILE, TYPE_BOOLEAN, false, false);
        Settings.stdDef(NAME_CONFIGURATION_BASE, TYPE_CFG_RELATIVE_PATH, false, true);
        Settings.stdDef(NAME_ECHO_FORMAT, TYPE_STRING, false, true);
        Settings.stdDef(NAME_QUIET, TYPE_STRING, false, true);
        Settings.stdDef(NAME_COLUMNS, TYPE_INTEGER, false, false);
        Settings.stdDef(NAME_SNIP, TYPE_BOOLEAN, false, false);
        Settings.stdDef(NAME_XPATH_ENGINE, TYPE_STRING, false, true);
        Settings.stdDef(NAME_XML_CATALOG_FILES, TYPE_CFG_RELATIVE_PATHS, true, false);
        Settings.stdDef(NAME_XML_CATALOG_PREFER, TYPE_STRING, false, false);
        Settings.stdDef(NAME_VALIDATE_XML, TYPE_BOOLEAN, false, false);
        Settings.stdDef(NAME_XML_RENDERINGS, TYPE_SEQUENCE, true, false);
    }

    private static class SequenceSettingType
    implements SettingType {
        private SequenceSettingType() {
        }

        public Object convert(Settings settings, Object value) throws SettingException {
            if (value instanceof List) {
                return value;
            }
            if (value instanceof Vector) {
                return new ArrayList((Vector)value);
            }
            if (value.getClass().isArray()) {
                int ln = Array.getLength(value);
                ArrayList<Object> ls = new ArrayList<Object>(ln);
                for (int i = 0; i < ln; ++i) {
                    ls.add(Array.get(value, i));
                }
                return ls;
            }
            ArrayList<Object> ls = new ArrayList<Object>(1);
            ls.add(value);
            return ls;
        }

        public Object convertString(Settings settings, String value, boolean forceStr) throws SettingException {
            List ls;
            try {
                ls = fmpp.tdd.Interpreter.evalAsSequence(value, this.getEvaluationEnvironment(), forceStr, null);
            }
            catch (EvalException e) {
                throw new SettingException("Failed to parse the text as TDD sequence.", e);
            }
            if (ls.size() == 1 && ls.get(0) instanceof List) {
                return ls.get(0);
            }
            return ls;
        }

        public Object merge(Settings settings, Object defValue, Object value) throws SettingException {
            List l1 = (List)defValue;
            List l2 = (List)value;
            ArrayList ls = new ArrayList(l1.size() + l2.size());
            ls.addAll(l2);
            ls.addAll(l1);
            return ls;
        }

        protected EvaluationEnvironment getEvaluationEnvironment() {
            return null;
        }
    }

    private static class FirstPhaseEvaluationEnvironment
    implements EvaluationEnvironment {
        private int hashKeyLevel;
        private int hashLevel;
        private int sequenceLevel;
        private int functionCallLevel;
        private Settings settings;
        private boolean inLocalData;
        private boolean inFunctionCase;

        private FirstPhaseEvaluationEnvironment(Settings settings) {
            this.settings = settings;
        }

        public Object evalFunctionCall(FunctionCall fc, fmpp.tdd.Interpreter ip) throws Exception {
            return fc;
        }

        public Object notify(int event, fmpp.tdd.Interpreter ip, String name, Object extra) throws SettingException {
            if (event == 1) {
                ++this.hashKeyLevel;
                if (this.hashKeyLevel == 1) {
                    if (!this.settings.defs.containsKey(name)) {
                        String similar = this.settings.findSimilar(name);
                        throw new SettingException("No setting with name " + StringUtil.jQuote(name) + " exists." + (similar == null ? "" : " Maybe you meant to write " + StringUtil.jQuote(similar) + "."));
                    }
                    if (name.equals(Settings.NAME_DATA)) {
                        return EvaluationEnvironment.RETURN_FRAGMENT;
                    }
                    if (name.equals(Settings.NAME_LOCAL_DATA)) {
                        this.inLocalData = true;
                    }
                }
            } else if (event == -1) {
                --this.hashKeyLevel;
                if (this.hashKeyLevel == 0) {
                    this.inLocalData = false;
                }
            } else if (event == 4) {
                ++this.sequenceLevel;
            } else if (event == -4) {
                --this.sequenceLevel;
            } else if (event == 5) {
                ++this.hashLevel;
                if (this.inFunctionCase && this.sequenceLevel == 1 && this.hashLevel == 2 && this.functionCallLevel == 1) {
                    return EvaluationEnvironment.RETURN_FRAGMENT;
                }
            } else if (event == -5) {
                --this.hashLevel;
            } else if (event == 3) {
                ++this.functionCallLevel;
                if (this.inLocalData && this.sequenceLevel == 1 && this.hashLevel == 1 && this.functionCallLevel == 1 && name.equals(Settings.FUNCTION_CASE)) {
                    this.inFunctionCase = true;
                }
            } else if (event == -3) {
                --this.functionCallLevel;
                if (this.functionCallLevel == 0) {
                    this.inFunctionCase = false;
                }
            }
            return null;
        }
    }

    private static interface SettingType {
        public Object convert(Settings var1, Object var2) throws SettingException;

        public Object convertString(Settings var1, String var2, boolean var3) throws SettingException;

        public Object merge(Settings var1, Object var2, Object var3) throws SettingException;
    }

    private static class DataList
    extends ArrayList {
        public DataList() {
        }

        public DataList(int initialCapacity) {
            super(initialCapacity);
        }

        public DataList(Collection c) {
            super(c);
        }
    }

    private static class SettingDefinition {
        private final String name;
        private final SettingType type;
        private final boolean merge;
        private final boolean forceStr;

        private SettingDefinition(String name, SettingType type, boolean merge, boolean forceStr) {
            this.name = name;
            this.type = type;
            this.merge = merge;
            this.forceStr = forceStr;
        }
    }
}

