/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.ant.taskdefs;

import com.nokia.helium.antlint.AntFile;
import com.nokia.helium.antlint.AntProjectVisitor;
import com.nokia.helium.antlint.ant.types.Checker;
import com.nokia.helium.antlint.checks.Check;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Visitor;
import org.dom4j.io.SAXReader;

public class AntLintTask
extends Task {
    private List<Checker> checkerList = new Vector<Checker>();
    private List<FileSet> antFileSetList = new ArrayList<FileSet>();
    private List<AntFile> antFilelist = new ArrayList<AntFile>();
    private List<Check> checkList = new ArrayList<Check>();

    public void addChecker(Checker checker) {
        this.checkerList.add(checker);
    }

    public void addFileset(FileSet set) {
        this.antFileSetList.add(set);
    }

    public final void execute() {
        try {
            this.initialize();
            this.startAntLintCheck();
        }
        catch (Exception e) {
            throw new BuildException("Exception occured while running AntLint task " + e.getMessage());
        }
        int errorCount = 0;
        for (AntFile antFile : this.antFilelist) {
            errorCount += antFile.getErrorCount();
            this.log(antFile.toString());
        }
        if (errorCount > 0) {
            throw new BuildException(errorCount + " errors found.");
        }
    }

    private void initialize() {
        Check check = null;
        for (Checker checker : this.checkerList) {
            check = this.getCheckObject(checker.getName());
            if (check == null) continue;
            check.setChecker(checker);
            this.checkList.add(check);
        }
    }

    private Check getCheckObject(String checkerName) {
        Check check = null;
        try {
            Class<?> clazz = Class.forName("com.nokia.helium.antlint.checks." + checkerName);
            if (clazz != null) {
                check = (Check)clazz.newInstance();
            }
        }
        catch (Throwable th) {
            throw new BuildException("Error in Antlint configuration:", th);
        }
        return check;
    }

    private void startAntLintCheck() throws Exception {
        this.runOneTimeCheck();
        for (FileSet fs : this.antFileSetList) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            String basedir = ds.getBasedir().getPath();
            for (int i = 0; i < srcFiles.length; ++i) {
                String antFileName = basedir + File.separator + srcFiles[i];
                this.getProject().log("*************** Ant File: " + antFileName);
                this.run(antFileName);
                SAXReader saxReader = new SAXReader();
                Document doc = saxReader.read(new File(antFileName));
                this.treeWalk(doc);
            }
            Collections.sort(this.antFilelist);
        }
    }

    private void treeWalk(Document document) {
        Element rootElement = document.getRootElement();
        AntProjectVisitor visitorRootElement = new AntProjectVisitor(this.checkList);
        rootElement.accept((Visitor)visitorRootElement);
    }

    private void runOneTimeCheck() {
        AntFile antFile = new AntFile("General");
        this.antFilelist.add(antFile);
        for (Check check : this.checkList) {
            if (!check.isEnabled()) continue;
            check.setAntFile(antFile);
            check.run();
        }
    }

    private void run(String antFileName) {
        AntFile antFile = new AntFile(antFileName);
        this.antFilelist.add(antFile);
        for (Check check : this.checkList) {
            if (!check.isEnabled()) continue;
            check.setAntFile(antFile);
            check.run(antFileName);
        }
    }
}

