/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.dom4j.Element;

public class CheckProjectName
extends AbstractCheck {
    @Override
    public void run(Element node) {
        if (node.getName().equals("project")) {
            String text = node.attributeValue("name");
            if (text != null && !text.isEmpty()) {
                this.checkProjectName(text);
            } else {
                this.log("Project name not specified!");
            }
        }
    }

    private void checkProjectName(String text) {
        try {
            Pattern p1 = Pattern.compile(this.getPattern());
            Matcher m1 = p1.matcher(text);
            if (!m1.matches()) {
                this.log("INVALID Project Name: " + text);
            }
        }
        catch (Exception e) {
            throw new BuildException("Not able to match Project Name for " + text);
        }
    }
}

