/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core;

import com.nokia.helium.core.PPInputSource;
import com.nokia.helium.core.PropertiesSource;
import com.nokia.helium.core.TemplateInputSource;
import com.nokia.helium.core.TemplateProcessorException;
import com.nokia.helium.core.XMLTemplateSource;
import freemarker.core.InvalidReferenceException;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class TemplateProcessor {
    private Logger log = Logger.getLogger(TemplateProcessor.class);

    private HashMap<String, Object> getTemplateMap(List<TemplateInputSource> inputSources) {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        try {
            for (TemplateInputSource source : inputSources) {
                if (source instanceof XMLTemplateSource) {
                    XMLTemplateSource xmlSource = (XMLTemplateSource)source;
                    File inputFile = xmlSource.getSourceLocation();
                    if (inputFile.exists()) {
                        templateMap.put(xmlSource.getSourceName(), NodeModel.parse((File)inputFile));
                        continue;
                    }
                    this.log.debug((Object)("TemplateProcessor: input file " + inputFile + " for the template does not exists"));
                    continue;
                }
                if (source instanceof PropertiesSource) {
                    PropertiesSource propSource = (PropertiesSource)source;
                    templateMap.put(propSource.getSourceName(), propSource.getProperties());
                    continue;
                }
                if (!(source instanceof PPInputSource)) continue;
                PPInputSource ppSource = (PPInputSource)source;
                templateMap.put(ppSource.getSourceName(), ppSource.getPPHash());
            }
        }
        catch (IOException e) {
            throw new TemplateProcessorException("I/O Error during template conversion: " + e.getMessage());
        }
        catch (SAXException e1) {
            throw new TemplateProcessorException("XML parser error: " + e1.getMessage());
        }
        catch (ParserConfigurationException e3) {
            throw new TemplateProcessorException("Parser error: " + e3.getMessage());
        }
        return templateMap;
    }

    public void convertTemplate(String templateFile, String outputFile, List<TemplateInputSource> sourceList) {
        this.convertTemplate(new File(templateFile), new File(outputFile), sourceList);
    }

    public void convertTemplate(File templateFile, File outputFile, List<TemplateInputSource> sourceList) {
        if (templateFile == null) {
            throw new TemplateProcessorException("Template file not defined.");
        }
        this.convertTemplate(templateFile.getParent(), templateFile.getName(), outputFile.toString(), sourceList);
    }

    public void convertTemplate(String templateDir, String templateFile, String outputFile, List<TemplateInputSource> sourceList) {
        Configuration cfg = new Configuration();
        File templateDirFile = new File(templateDir);
        if (templateDir != null && templateDirFile.exists()) {
            try {
                cfg.setDirectoryForTemplateLoading(templateDirFile);
                this.log.debug((Object)("diamonds:TemplateProcessor:adding template directory loader: " + templateDir));
            }
            catch (IOException ie) {
                throw new TemplateProcessorException("Template directory configuring error: " + ie);
            }
        } else {
            throw new TemplateProcessorException("Template directory does not exist: " + templateDirFile.getAbsolutePath());
        }
        try {
            Template template = cfg.getTemplate(templateFile);
            HashMap<String, Object> templateMap = this.getTemplateMap(sourceList);
            template.process(templateMap, (Writer)new FileWriter(outputFile));
        }
        catch (InvalidReferenceException ivx) {
            throw new TemplateProcessorException("Invalid reference in config: " + (Object)((Object)ivx));
        }
        catch (TemplateException e2) {
            throw new TemplateProcessorException("TemplateException: " + (Object)((Object)e2));
        }
        catch (IOException e) {
            throw new TemplateProcessorException("I/O Error during template conversion: " + e);
        }
    }
}

