/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.imaker.ant.types;

import com.nokia.helium.imaker.IMaker;
import com.nokia.helium.imaker.IMakerException;
import com.nokia.helium.imaker.ant.Command;
import com.nokia.helium.imaker.ant.IMakerCommandSet;
import com.nokia.helium.imaker.ant.types.MakefileSelector;
import com.nokia.helium.imaker.ant.types.VariableGroup;
import com.nokia.helium.imaker.ant.types.VariableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.PatternSet;

public class Configuration
extends DataType
implements IMakerCommandSet {
    private Vector<PatternSet> makefiles = new Vector();
    private Vector<MakefileSelector> selectors = new Vector();
    private Vector<PatternSet> targets = new Vector();
    private Vector<VariableSet> variables = new Vector();
    private Vector<VariableGroup> variablegroups = new Vector();
    private boolean regionalVariation;

    public PatternSet createMakefileSet() {
        PatternSet makefile = new PatternSet();
        this.makefiles.add(makefile);
        return makefile;
    }

    public Vector<PatternSet> getMakefileSet() {
        return this.makefiles;
    }

    public void add(MakefileSelector filter) {
        this.selectors.add(filter);
    }

    public PatternSet createTargetSet() {
        PatternSet target = new PatternSet();
        this.targets.add(target);
        return target;
    }

    public Vector<PatternSet> getTargetSet() {
        return this.targets;
    }

    public VariableSet createVariableSet() {
        VariableSet var = new VariableSet();
        this.variables.add(var);
        return var;
    }

    public VariableGroup createVariableGroup() {
        VariableGroup var = new VariableGroup();
        this.variablegroups.add(var);
        return var;
    }

    public Vector<VariableSet> getVariableSet() {
        return this.variables;
    }

    @Deprecated
    public void setRegionalVariation(boolean value) {
        this.log(this.getDataTypeName() + ": the usage of the regionalVariation attribute is now ignored.", 1);
        this.regionalVariation = value;
    }

    public boolean getRegionalVariation() {
        return this.regionalVariation;
    }

    protected boolean isIncluded(String name, Vector<PatternSet> patterns) {
        for (PatternSet patternSet : patterns) {
            String[] includes;
            if (patternSet.isReference()) {
                patternSet = (PatternSet)patternSet.getRefid().getReferencedObject();
            }
            if ((includes = patternSet.getIncludePatterns(this.getProject())) == null) continue;
            for (String pattern : includes) {
                if (!Pattern.matches(pattern, name)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isExcluded(String name, Vector<PatternSet> patterns) {
        for (PatternSet patternSet : patterns) {
            String[] excludes;
            if (patternSet.isReference()) {
                patternSet = (PatternSet)patternSet.getRefid().getReferencedObject();
            }
            if ((excludes = patternSet.getExcludePatterns(this.getProject())) == null) continue;
            for (String pattern : excludes) {
                if (!Pattern.matches(pattern, name)) continue;
                return true;
            }
        }
        return false;
    }

    protected Matcher getMakefileMatcher() {
        Matcher matcher = new Matcher();
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (PatternSet patternSet : this.makefiles) {
            String[] patterns;
            if (patternSet.isReference()) {
                patternSet = (PatternSet)patternSet.getRefid().getReferencedObject();
            }
            if ((patterns = patternSet.getIncludePatterns(this.getProject())) != null) {
                for (String pattern : patterns) {
                    includes.add(pattern);
                }
            }
            if ((patterns = patternSet.getExcludePatterns(this.getProject())) == null) continue;
            for (String pattern : patterns) {
                excludes.add(pattern);
            }
        }
        matcher.setIncludes(includes.toArray(new String[includes.size()]));
        matcher.setExcludes(excludes.toArray(new String[excludes.size()]));
        return matcher;
    }

    @Override
    public List<List<Command>> getCommands(IMaker imaker) {
        ArrayList<List<Command>> cmdSet = new ArrayList<List<Command>>();
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (this.variablegroups.size() == 0) {
            this.variablegroups.add(new VariableGroup());
        }
        try {
            for (String configuration : this.getConfigurations(imaker.getConfigurations())) {
                this.log("Including configuration: " + configuration);
                for (String target : imaker.getTargets(configuration)) {
                    if (!this.isIncluded(target, this.targets) || this.isExcluded(target, this.targets)) continue;
                    this.log("Including target: " + target);
                    for (VariableGroup group : this.variablegroups) {
                        if (group.isReference()) {
                            group = (VariableGroup)((Object)group.getRefid().getReferencedObject());
                        }
                        Command cmd = new Command();
                        cmd.setCommand("imaker");
                        cmd.addArgument("-f");
                        cmd.addArgument(configuration);
                        for (VariableSet vs : this.variables) {
                            cmd.addVariables(vs.toMap());
                        }
                        cmd.addVariables(group.toMap());
                        cmd.setTarget(target);
                        cmds.add(cmd);
                    }
                }
            }
        }
        catch (IMakerException e) {
            throw new BuildException(e.getMessage());
        }
        if (cmds.size() > 0) {
            cmdSet.add(cmds);
        }
        return cmdSet;
    }

    protected Set<String> getConfigurations(List<String> configurations) {
        HashSet<String> result = new HashSet<String>();
        if (this.makefiles.size() > 0) {
            Matcher matcher = this.getMakefileMatcher();
            for (String configuration : configurations) {
                if (!matcher.match(configuration)) continue;
                result.add(configuration);
            }
        }
        for (MakefileSelector selector : this.selectors) {
            result.addAll(selector.selectMakefile(configurations));
        }
        return result;
    }

    public class Matcher
    extends DirectoryScanner {
        public boolean match(String path) {
            String vpath = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            return this.isIncluded(vpath) && !this.isExcluded(vpath);
        }
    }
}

