/*
 * Decompiled with CFR 0.152.
 */
package com.kirkk.analyzer.textui;

import com.kirkk.analyzer.textui.Summary;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JarAnalyzerTask
extends Task {
    private File srcdir;
    private File destfile;
    private String packageFilter;
    private String jarFilter;
    private String summaryclass;

    public void setJarFilter(String string) {
        this.jarFilter = string;
    }

    public void setPackageFilter(String string) {
        this.packageFilter = string;
    }

    public void setSrcdir(File file) {
        this.srcdir = file;
    }

    public void setDestfile(File file) {
        this.destfile = file;
    }

    public void setSummaryclass(String string) {
        this.summaryclass = string;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            Class<?> clazz = Class.forName(this.summaryclass);
            Summary summary = (Summary)clazz.newInstance();
            summary.createSummary(this.srcdir, this.destfile, this.packageFilter, this.jarFilter);
            this.log(this.destfile + " successfully created");
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private void validateAttributes() {
        if (null == this.srcdir) {
            throw new BuildException("Missing srcdir");
        }
        if (null == this.destfile) {
            throw new BuildException("Missing destfile");
        }
        if (!this.srcdir.exists() || !this.srcdir.isDirectory()) {
            throw new BuildException("srcdir must be a valid directory");
        }
        if (this.destfile.isDirectory()) {
            throw new BuildException("srcdir must be a file");
        }
        if (null == this.summaryclass) {
            throw new BuildException("Missing summaryclass");
        }
    }
}

