/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.StringPair;
import info.bliki.wiki.filter.WPList;
import info.bliki.wiki.filter.WPTable;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.DefaultEventListener;
import info.bliki.wiki.model.IEventListener;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.DdTag;
import info.bliki.wiki.tags.DlTag;
import info.bliki.wiki.tags.DtTag;
import info.bliki.wiki.tags.HTMLBlockTag;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.HrTag;
import info.bliki.wiki.tags.PTag;
import info.bliki.wiki.tags.TableOfContentTag;
import info.bliki.wiki.tags.WPBoldItalicTag;
import info.bliki.wiki.tags.WPPreTag;
import info.bliki.wiki.tags.WPTag;
import info.bliki.wiki.tags.util.IBodyTag;
import info.bliki.wiki.tags.util.INoBodyParsingTag;
import info.bliki.wiki.tags.util.TagStack;
import info.bliki.wiki.tags.util.WikiTagNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.validator.EmailValidator;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracParser
extends AbstractParser {
    static final String[] HEADER_STRINGS = new String[]{"=", "==", "===", "====", "=====", "======"};
    static final int TokenNotFound = -2;
    static final int TokenIgnore = -1;
    static final int TokenSTART = 0;
    static final int TokenEOF = 1;
    static final int TokenBOLD = 3;
    static final int TokenITALIC = 4;
    static final int TokenBOLDITALIC = 5;
    static final HTMLTag BOLD = new WPTag("b");
    static final HTMLTag ITALIC = new WPTag("i");
    static final HTMLTag BOLDITALIC = new WPBoldItalicTag();
    static final HTMLTag STRONG = new WPTag("strong");
    static final HTMLTag EM = new WPTag("em");
    private List<Object> fTableOfContent = null;
    private TableOfContentTag fTableOfContentTag = null;
    private HashSet<String> fToCSet = null;
    private int fHeadCounter = 0;
    private int fSectionCounter = 1;
    private boolean fHtmlCodes = true;
    private boolean fNoToC = false;
    private boolean fRenderTemplate = false;
    private boolean fForceToC = false;
    private IEventListener fEventListener = null;
    static final int RECURSION_LIMIT = 25;

    public TracParser(String stringSource, boolean renderTemplate) {
        this(stringSource, null);
    }

    public TracParser(String stringSource, IEventListener wikiListener) {
        super(stringSource);
        this.fEventListener = wikiListener == null ? DefaultEventListener.CONST : wikiListener;
    }

    private void createContentToken(boolean whiteStart, int whiteStartPosition, int diff) {
        if (whiteStart) {
            try {
                int whiteEndPosition = this.fCurrentPosition - diff;
                int count = whiteEndPosition - whiteStartPosition;
                if (count > 0) {
                    this.fWikiModel.append(new ContentToken(new String(this.fSource, whiteStartPosition, count)));
                }
            }
            finally {
                this.fWhiteStart = false;
            }
        }
    }

    protected final boolean isCharBefore(char testedChar) {
        try {
            return this.fSource[this.fCurrentPosition - 2] == testedChar;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    protected final boolean getNextChar(char testedChar) {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (this.fCurrentCharacter != testedChar) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final int getNextChar(char testedChar1, char testedChar2) {
        int result;
        block5: {
            int temp = this.fCurrentPosition;
            try {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                if (this.fCurrentCharacter == testedChar1) {
                    result = 0;
                    break block5;
                }
                if (this.fCurrentCharacter == testedChar2) {
                    result = 1;
                    break block5;
                }
                this.fCurrentPosition = temp;
                return -1;
            }
            catch (IndexOutOfBoundsException e) {
                this.fCurrentPosition = temp;
                return -1;
            }
        }
        return result;
    }

    protected final boolean getNextCharAsDigit() {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (!Character.isDigit(this.fCurrentCharacter)) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final boolean getNextCharAsDigit(int radix) {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (Character.digit(this.fCurrentCharacter, radix) == -1) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final int getNumberOfChar(char testedChar) {
        int number = 0;
        try {
            while ((this.fCurrentCharacter = this.fSource[this.fCurrentPosition++]) == testedChar) {
                ++number;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        --this.fCurrentPosition;
        return number;
    }

    protected boolean getNextCharAsWikiPluginIdentifierPart() {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (!Encoder.isWikiPluginIdentifierPart(this.fCurrentCharacter)) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    protected int getNextToken() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 27[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean handleSourroundingTags1(String tagName, TagToken tag) {
        this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 2);
        if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(tag)) {
            this.fWikiModel.popNode();
        } else {
            this.fWikiModel.pushNode(new HTMLTag(tagName));
        }
        return true;
    }

    private boolean handleSourroundingTags2(char testChar, String tagName, TagToken tag) {
        if (this.fSource[this.fCurrentPosition] == testChar) {
            ++this.fCurrentPosition;
            this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 2);
            if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(tag)) {
                this.fWikiModel.popNode();
            } else {
                this.fWikiModel.pushNode(new HTMLTag(tagName));
            }
            return true;
        }
        return false;
    }

    private void createContentTag(int startPosition, int endPosition, TagToken tag) {
        this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 1);
        this.fWikiModel.pushNode(tag);
        int count = endPosition - startPosition;
        if (count > 0) {
            this.fWikiModel.append(new ContentToken(new String(this.fSource, startPosition, count)));
        }
        this.fWikiModel.popNode();
    }

    private void addParagraph() {
        this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 2);
        this.reduceTokenStack(Configuration.HTML_PARAGRAPH_OPEN);
        this.fWikiModel.pushNode(new PTag());
    }

    private boolean parseHTMLCommentTags() {
        int htmlStartPosition = this.fCurrentPosition;
        String htmlCommentString = this.fStringSource.substring(this.fCurrentPosition - 1, this.fCurrentPosition + 3);
        if (htmlCommentString.equals("<!--")) {
            String htmlCommentContent;
            this.fCurrentPosition += 3;
            if (this.readUntil("-->") && (htmlCommentContent = new String(this.fSource, htmlStartPosition + 3, this.fCurrentPosition - htmlStartPosition - 6)) != null) {
                this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - htmlStartPosition + 1);
                return true;
            }
        }
        return false;
    }

    private boolean parseISBNLinks() {
        String urlString;
        boolean foundISBN;
        int urlStartPosition;
        block5: {
            urlStartPosition = this.fCurrentPosition;
            foundISBN = false;
            try {
                urlString = this.fStringSource.substring(this.fCurrentPosition - 1, this.fCurrentPosition + 4);
                if (urlString.equalsIgnoreCase("isbn ")) {
                    this.fCurrentPosition += 4;
                    this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                    this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 6);
                    this.fWhiteStart = false;
                    foundISBN = true;
                    char ch = this.fSource[this.fCurrentPosition++];
                    while (ch >= '0' && ch <= '9' || ch == '-') {
                        ch = this.fSource[this.fCurrentPosition++];
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (foundISBN) break block5;
                this.fCurrentPosition = urlStartPosition;
            }
        }
        if (foundISBN) {
            urlString = new String(this.fSource, urlStartPosition - 1, this.fCurrentPosition - urlStartPosition);
            --this.fCurrentPosition;
            this.fWikiModel.appendISBNLink(urlString);
            return true;
        }
        return false;
    }

    private boolean parseFTPLinks() {
        String urlString;
        boolean foundUrl;
        int urlStartPosition;
        block6: {
            urlStartPosition = this.fCurrentPosition;
            foundUrl = false;
            try {
                urlString = this.fStringSource.substring(this.fCurrentPosition - 1, this.fCurrentPosition + 2);
                if (urlString.equalsIgnoreCase("ftp")) {
                    this.fCurrentPosition += 2;
                    this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                    if (this.fCurrentCharacter == ':' && this.fSource[this.fCurrentPosition++] == '/' && this.fSource[this.fCurrentPosition++] == '/') {
                        this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 6);
                        this.fWhiteStart = false;
                        foundUrl = true;
                        while (Encoder.isUrlIdentifierPart(this.fSource[this.fCurrentPosition++])) {
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (foundUrl) break block6;
                this.fCurrentPosition = urlStartPosition;
            }
        }
        if (foundUrl) {
            urlString = new String(this.fSource, urlStartPosition - 1, this.fCurrentPosition - urlStartPosition);
            --this.fCurrentPosition;
            this.fWikiModel.appendExternalLink(urlString, urlString, true);
            return true;
        }
        return false;
    }

    private boolean parseHTTPLinks() {
        boolean foundUrl;
        int urlStartPosition;
        block7: {
            urlStartPosition = this.fCurrentPosition;
            foundUrl = false;
            try {
                int diff = 7;
                String urlString = this.fStringSource.substring(this.fCurrentPosition - 1, this.fCurrentPosition + 3);
                if (urlString.equalsIgnoreCase("http")) {
                    this.fCurrentPosition += 3;
                    this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                    if (this.fCurrentCharacter == 's') {
                        this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                        ++diff;
                    }
                    if (this.fCurrentCharacter == ':' && this.fSource[this.fCurrentPosition++] == '/' && this.fSource[this.fCurrentPosition++] == '/') {
                        this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, diff);
                        this.fWhiteStart = false;
                        foundUrl = true;
                        while (Encoder.isUrlIdentifierPart(this.fSource[this.fCurrentPosition++])) {
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (foundUrl) break block7;
                this.fCurrentPosition = urlStartPosition;
            }
        }
        if (foundUrl) {
            String urlString = new String(this.fSource, urlStartPosition - 1, this.fCurrentPosition - urlStartPosition);
            --this.fCurrentPosition;
            this.fWikiModel.appendExternalLink(urlString, urlString, true);
            return true;
        }
        return false;
    }

    private boolean parseMailtoLinks() {
        String urlString2;
        int urlStartPosition = this.fCurrentPosition;
        int tempPosition = this.fCurrentPosition;
        boolean foundUrl = false;
        try {
            urlString2 = this.fStringSource.substring(this.fCurrentPosition - 1, this.fCurrentPosition + 6);
            if (urlString2.equalsIgnoreCase("mailto:")) {
                tempPosition += 6;
                this.fCurrentCharacter = this.fSource[tempPosition++];
                foundUrl = true;
                while (!Character.isWhitespace(this.fSource[tempPosition++])) {
                }
            }
        }
        catch (IndexOutOfBoundsException urlString2) {
            // empty catch block
        }
        if (foundUrl) {
            urlString2 = new String(this.fSource, urlStartPosition - 1, tempPosition - urlStartPosition);
            String email = urlString2.substring(7);
            if (EmailValidator.getInstance().isValid(email)) {
                this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 1);
                this.fWhiteStart = false;
                this.fCurrentPosition = tempPosition;
                --this.fCurrentPosition;
                this.fWikiModel.appendMailtoLink(urlString2, urlString2, true);
                return true;
            }
        }
        this.fCurrentPosition = urlStartPosition;
        return false;
    }

    private boolean parseCamelCaseNames(char firstChar) {
        if (firstChar >= 'A' && firstChar <= 'Z') {
            if (this.isCharBefore('!')) {
                return false;
            }
            int startPosition = this.fCurrentPosition;
            int lowerCaseCounter = 0;
            try {
                boolean camelCase = true;
                StringBuilder camelCasePageName = new StringBuilder(20);
                camelCasePageName.append(firstChar);
                while (true) {
                    char ch;
                    if ((ch = this.fSource[this.fCurrentPosition++]) >= 'a' && ch <= 'z') {
                        camelCasePageName.append(ch);
                        if (camelCase) {
                            ++lowerCaseCounter;
                        }
                        camelCase = false;
                        continue;
                    }
                    if (ch >= 'A' && ch <= 'Z') {
                        camelCasePageName.append(ch);
                        camelCase = true;
                        continue;
                    }
                    if (ch != '/') break;
                    camelCasePageName.append(ch);
                    camelCase = false;
                }
                if (lowerCaseCounter >= 2) {
                    --this.fCurrentPosition;
                    this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - startPosition + 1);
                    this.fWhiteStart = false;
                    String camelCaseStr = camelCasePageName.toString();
                    this.fWikiModel.appendInternalLink(camelCaseStr, null, camelCaseStr, null);
                    return true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            this.fCurrentPosition = startPosition;
        }
        return false;
    }

    private boolean parseWikiLink() {
        int startLinkPosition = this.fCurrentPosition;
        if (this.getNextChar('[')) {
            return this.parseWikiTag();
        }
        this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 1);
        this.fWhiteStart = false;
        if (this.readUntilChar(']')) {
            String name = new String(this.fSource, startLinkPosition, this.fCurrentPosition - startLinkPosition - 1);
            if (this.fWikiModel.parseBBCodes() && name.length() > 0) {
                StringBuilder bbCode = new StringBuilder(name.length());
                char ch = name.charAt(0);
                if ('a' <= ch && ch <= 'z') {
                    bbCode.append(ch);
                    if (this.parsePHPBBCode(name, bbCode)) {
                        return true;
                    }
                }
            }
            if (this.handleHTTPLink(name)) {
                return true;
            }
            this.fCurrentPosition = startLinkPosition;
        }
        return false;
    }

    private boolean parseWikiTag() {
        int startLinkPosition = this.fCurrentPosition;
        this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 2);
        int temp = this.fCurrentPosition;
        if (this.findWikiLinkEnd()) {
            int endLinkPosition = this.fCurrentPosition - 2;
            String name = new String(this.fSource, startLinkPosition, endLinkPosition - startLinkPosition);
            temp = this.fCurrentPosition;
            StringBuilder suffixBuffer = new StringBuilder();
            try {
                while (true) {
                    this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                    if (!Character.isLetterOrDigit(this.fCurrentCharacter)) {
                        --this.fCurrentPosition;
                        break;
                    }
                    suffixBuffer.append(this.fCurrentCharacter);
                }
                String suffix = suffixBuffer.toString();
                this.fEventListener.onWikiLink(this.fSource, startLinkPosition, endLinkPosition, suffix);
                this.fWikiModel.appendRawWikipediaLink(name, suffix);
                return true;
            }
            catch (IndexOutOfBoundsException e) {
                this.fCurrentPosition = temp;
                this.fEventListener.onWikiLink(this.fSource, startLinkPosition, endLinkPosition, "");
                this.fWikiModel.appendRawWikipediaLink(name, "");
                return true;
            }
        }
        this.fWhiteStart = true;
        this.fWhiteStartPosition = startLinkPosition - 2;
        this.fCurrentPosition = temp + 1;
        return false;
    }

    private boolean parsePreformattedHorizontalRuler() {
        if (this.isStartOfLine() && !this.isEmptyLine(1)) {
            if (this.fWikiModel.stackSize() == 0 || !(this.fWikiModel.peekNode() instanceof HTMLBlockTag)) {
                this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 2);
                this.reduceTokenStack(Configuration.HTML_PRE_OPEN);
                this.fWikiModel.pushNode(new WPPreTag());
            }
            return true;
        }
        return false;
    }

    private boolean parseHorizontalRuler() {
        if (this.isStartOfLine()) {
            int tempCurrPosition = this.fCurrentPosition;
            try {
                int pos;
                if (this.fSource[tempCurrPosition++] == '-' && this.fSource[tempCurrPosition++] == '-' && this.fSource[tempCurrPosition++] == '-' && (pos = this.isEndOfLine('-', tempCurrPosition)) > 0) {
                    HrTag hr = new HrTag();
                    this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 2);
                    this.reduceTokenStack(hr);
                    this.fCurrentPosition = pos;
                    this.fWikiModel.append(hr);
                    this.fWhiteStart = false;
                    return true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            this.fCurrentPosition = tempCurrPosition;
        }
        return false;
    }

    private boolean parseDefinitionLists() {
        if (this.isStartOfLine()) {
            this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 1);
            int startHeadPosition = this.fCurrentPosition;
            if (this.readUntilEOL()) {
                DlTag dl = new DlTag();
                DtTag dt = new DtTag();
                this.reduceTokenStack(dl);
                String head = new String(this.fSource, startHeadPosition, this.fCurrentPosition - startHeadPosition);
                int index = head.indexOf(" : ");
                if (index > 0) {
                    this.fWikiModel.pushNode(dl);
                    this.fWikiModel.pushNode(dt);
                    TracParser.parseRecursive(head.substring(0, index).trim(), this.fWikiModel, false, true);
                    this.fWikiModel.popNode();
                    this.fWikiModel.pushNode(new DdTag());
                    TracParser.parseRecursive(head.substring(index + 2).trim(), this.fWikiModel, false, true);
                    this.fWikiModel.popNode();
                    this.fWikiModel.popNode();
                } else {
                    index = head.indexOf(":");
                    if (index > 0) {
                        this.fWikiModel.pushNode(dl);
                        this.fWikiModel.pushNode(dt);
                        TracParser.parseRecursive(head.substring(0, index).trim(), this.fWikiModel, false, true);
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new DdTag());
                        TracParser.parseRecursive(head.substring(index + 1).trim(), this.fWikiModel, false, true);
                        this.fWikiModel.popNode();
                        this.fWikiModel.popNode();
                    } else {
                        this.fWikiModel.pushNode(dl);
                        this.fWikiModel.pushNode(dt);
                        TracParser.parseRecursive(head.trim(), this.fWikiModel, false, true);
                        this.fWikiModel.popNode();
                        this.fWikiModel.popNode();
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean parseSimpleDefinitionLists() {
        if (this.isStartOfLine()) {
            this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 1);
            int levelHeader = this.getNumberOfChar(':') + 1;
            int startHeadPosition = this.fCurrentPosition;
            if (this.readUntilEOL()) {
                this.reduceTokenStack(Configuration.HTML_DL_OPEN);
                String head = new String(this.fSource, startHeadPosition, this.fCurrentPosition - startHeadPosition);
                int i = 0;
                while (i < levelHeader) {
                    this.fWikiModel.pushNode(new DlTag());
                    this.fWikiModel.pushNode(new DdTag());
                    ++i;
                }
                TracParser.parseRecursive(head.trim(), this.fWikiModel, false, true);
                i = 0;
                while (i < levelHeader) {
                    this.fWikiModel.popNode();
                    this.fWikiModel.popNode();
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private boolean parseLists() {
        if (this.isStartOfLine()) {
            this.setPosition(this.fCurrentPosition - 2);
            WPList list = this.wpList();
            if (list != null && !list.isEmpty()) {
                this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 1);
                this.reduceTokenStack(list);
                this.fCurrentPosition = this.getPosition() - 1;
                this.fWikiModel.append(list);
                return true;
            }
        }
        return false;
    }

    private boolean parseSectionHeaders() {
        if (this.isStartOfLine()) {
            int headerStartPosition = this.fCurrentPosition - 1;
            int endIndex = this.fStringSource.indexOf("\n", this.fCurrentPosition);
            if (endIndex < 0) {
                endIndex = this.fStringSource.length();
            }
            int headerEndPosition = endIndex;
            while (headerEndPosition > 0) {
                char ch;
                if (!Character.isWhitespace(ch = this.fSource[--headerEndPosition])) break;
            }
            if (headerEndPosition < 0 || headerEndPosition <= headerStartPosition) {
                return false;
            }
            int level = 0;
            while (headerStartPosition < headerEndPosition) {
                if (this.fSource[headerStartPosition] == '=' && this.fSource[headerEndPosition] == '=') {
                    ++headerStartPosition;
                    --headerEndPosition;
                    if (++level != 6) continue;
                    ++headerEndPosition;
                    break;
                }
                ++headerEndPosition;
                break;
            }
            if (level == 0) {
                return false;
            }
            this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 1);
            this.reduceTokenStack();
            String head = "";
            if (headerEndPosition > headerStartPosition) {
                head = new String(this.fSource, headerStartPosition, headerEndPosition - headerStartPosition);
            }
            this.fEventListener.onHeader(this.fSource, headerStartPosition, headerEndPosition, level);
            this.fCurrentPosition = endIndex;
            this.handleHead(head, level);
            return true;
        }
        return false;
    }

    private boolean parseTable() {
        if (this.isStartOfLine()) {
            this.setPosition(this.fCurrentPosition - 1);
            WPTable table = this.tracTable(this.fTableOfContentTag);
            if (table != null) {
                this.createContentToken(this.fWhiteStart, this.fWhiteStartPosition, 1);
                this.reduceTokenStack(table);
                this.fCurrentPosition = this.getPosition();
                this.fWikiModel.append(table);
                return true;
            }
        }
        return false;
    }

    private boolean parseTemplate() {
        int templateEndPosition;
        int templateStartPosition;
        if (this.fSource[this.fCurrentPosition] == '{' && this.fSource[templateStartPosition = this.fCurrentPosition + 1] != '{' && (templateEndPosition = this.findTemplateEnd(this.fSource, templateStartPosition)) > 0) {
            this.fEventListener.onTemplate(this.fSource, templateStartPosition, templateEndPosition - 2);
            return true;
        }
        return false;
    }

    private boolean isStartOfLine() {
        return this.fCurrentPosition >= 2 ? this.fSource[this.fCurrentPosition - 2] == '\n' : this.fCurrentPosition == 1;
    }

    private boolean isStartOfList() {
        return this.fCurrentPosition >= 3 ? this.fSource[this.fCurrentPosition - 3] == '\n' && this.fSource[this.fCurrentPosition - 2] == ' ' : this.fCurrentPosition == 2 && this.fSource[0] == ' ';
    }

    private int isEndOfLine(char testChar, int currentPosition) {
        int tempPosition = currentPosition;
        try {
            char ch;
            while ((ch = this.fSource[tempPosition]) == testChar) {
                ++tempPosition;
            }
            do {
                if ((ch = this.fSource[tempPosition++]) != '\n') continue;
                return tempPosition;
            } while (Character.isWhitespace(ch));
            return -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    private void createTag(TagToken tag, WikiTagNode tagNode, int startMacroPosition) {
        String macroBodyString = "";
        String command = tagNode.getTagName();
        if (tag != null && tag instanceof IBodyTag && !tagNode.isEmptyXmlTag()) {
            String endTag = String.valueOf(command) + '>';
            int index0 = Utils.indexOfIgnoreCase(this.fStringSource, "</", endTag, startMacroPosition);
            if (index0 >= 0) {
                macroBodyString = this.fStringSource.substring(startMacroPosition, index0);
                this.fCurrentPosition = index0 + endTag.length() + 2;
            } else {
                macroBodyString = new String(this.fSource, startMacroPosition, this.fSource.length - startMacroPosition);
                this.fCurrentPosition = this.fSource.length;
            }
        } else {
            macroBodyString = null;
            this.fCurrentPosition = startMacroPosition;
        }
        this.handleTag(tag, tagNode, macroBodyString);
    }

    private boolean handleHTTPLink(String name) {
        if (name != null) {
            boolean isEmail = false;
            String urlString = name.trim();
            String lowerCaseName = urlString.toLowerCase();
            if (lowerCaseName.startsWith("wiki:") && lowerCaseName.length() > 5) {
                int index = 5;
                int urlStart = 5;
                int urlEnd = urlString.length();
                if (lowerCaseName.charAt(5) == '\"') {
                    if ((index = lowerCaseName.indexOf(34, index + 1)) < 0) {
                        index = 6;
                    } else {
                        urlStart = 6;
                        urlEnd = index;
                    }
                }
                int spaceIndex = urlString.indexOf(32, index);
                String alias = "";
                if (spaceIndex != -1) {
                    alias = urlString.substring(spaceIndex + 1);
                    urlString = urlEnd < spaceIndex ? urlString.substring(urlStart, urlEnd) : urlString.substring(urlStart, spaceIndex);
                } else {
                    alias = urlString = urlString.substring(urlStart, urlEnd);
                }
                this.fWikiModel.appendInternalLink(urlString, null, alias, null);
                return true;
            }
            if (lowerCaseName.startsWith("\"") && lowerCaseName.length() > 1) {
                int index = 1;
                int urlStart = 1;
                int urlEnd = urlString.length();
                if ((index = lowerCaseName.indexOf(34, index + 1)) < 0) {
                    return false;
                }
                urlStart = 1;
                urlEnd = index;
                urlString = urlString.substring(urlStart, urlEnd);
                this.fWikiModel.appendInternalLink(urlString, null, urlString, null);
                return true;
            }
            boolean prefixCheck = lowerCaseName.startsWith("http://");
            if (!prefixCheck) {
                prefixCheck = lowerCaseName.startsWith("https://");
            }
            if (!prefixCheck) {
                prefixCheck = lowerCaseName.startsWith("ftp://");
            }
            if (!prefixCheck) {
                prefixCheck = lowerCaseName.startsWith("mailto:");
                isEmail = true;
            }
            if (prefixCheck) {
                int spaceIndex = urlString.indexOf(32);
                String alias = "";
                if (spaceIndex != -1) {
                    alias = urlString.substring(spaceIndex + 1);
                    urlString = urlString.substring(0, spaceIndex);
                } else {
                    alias = urlString;
                }
                if (isEmail) {
                    String email = spaceIndex > 7 ? urlString.substring(7, spaceIndex) : urlString.substring(7);
                    if (EmailValidator.getInstance().isValid(email)) {
                        this.fWikiModel.appendMailtoLink(urlString, alias, false);
                        return true;
                    }
                } else {
                    this.fWikiModel.appendExternalLink(urlString, alias, false);
                    return true;
                }
            }
        }
        return false;
    }

    private void addToTableOfContent(List<Object> toc, String head, String anchor, int headLevel) {
        if (headLevel == 1) {
            toc.add(new StringPair(head, anchor));
        } else {
            if (toc.size() > 0 && toc.get(toc.size() - 1) instanceof List) {
                this.addToTableOfContent((List)toc.get(toc.size() - 1), head, anchor, --headLevel);
                return;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            toc.add(list);
            this.addToTableOfContent(list, head, anchor, --headLevel);
        }
    }

    private void handleHead(String head, int headLevel) {
        if (head != null) {
            String anchor = Encoder.encodeUrl(head.trim());
            this.createTableOfContent(false);
            if (!this.fNoToC && ++this.fHeadCounter > 3) {
                this.fTableOfContentTag.setShowToC(true);
            }
            if (this.fToCSet.contains(anchor)) {
                String newAnchor = anchor;
                int i = 2;
                while (i < Integer.MAX_VALUE) {
                    newAnchor = String.valueOf(anchor) + '_' + Integer.toString(i);
                    if (!this.fToCSet.contains(newAnchor)) break;
                    ++i;
                }
                anchor = newAnchor;
            }
            this.addToTableOfContent(this.fTableOfContent, head, anchor, headLevel);
            if (this.fWikiModel.getRecursionLevel() == 1) {
                this.fWikiModel.buildEditLinkUrl(this.fSectionCounter++);
            }
            TagNode aTagNode = new TagNode("a");
            aTagNode.addAttribute("name", anchor, true);
            aTagNode.addAttribute("id", anchor, true);
            this.fWikiModel.append(aTagNode);
            WPTag headTagNode = new WPTag("h" + headLevel);
            headTagNode.addChild(new ContentToken(head));
            this.fWikiModel.append(headTagNode);
        }
    }

    private void createTableOfContent(boolean isTOCIdentifier) {
        this.fTableOfContentTag = this.fWikiModel.getTableOfContentTag(isTOCIdentifier);
        if (this.fTableOfContentTag != null && this.fTableOfContent == null) {
            this.fTableOfContent = this.fTableOfContentTag.getTableOfContent();
        }
        this.fToCSet = new HashSet();
    }

    private void handleTag(TagToken tag, WikiTagNode tagNode, String bodyString) {
        String command = tagNode.getTagName();
        try {
            if (tag instanceof EndTagToken) {
                this.fWikiModel.append(tag);
            } else {
                this.fWikiModel.pushNode(tag);
                if (bodyString != null) {
                    if (tag instanceof INoBodyParsingTag) {
                        ((TagNode)tag).addChild(new ContentToken(bodyString));
                    } else {
                        TracParser.parseRecursive(bodyString.trim(), this.fWikiModel, false, true);
                    }
                }
                if (tag instanceof IBodyTag) {
                    this.fWikiModel.popNode();
                }
            }
        }
        catch (IllegalArgumentException e) {
            TagNode divTagNode = new TagNode("div");
            divTagNode.addAttribute("class", "error", true);
            divTagNode.addChild(new ContentToken("IllegalArgumentException: " + command + " - " + e.getMessage()));
            this.fWikiModel.append(divTagNode);
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
            TagNode divTagNode = new TagNode("div");
            divTagNode.addAttribute("class", "error", true);
            divTagNode.addChild(new ContentToken(String.valueOf(command) + ": " + e.getMessage()));
            this.fWikiModel.append(divTagNode);
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void runParser() {
        int token = 0;
        while ((token = this.getNextToken()) != 1) {
            switch (token) {
                case 5: {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLDITALIC)) {
                        this.fWikiModel.popNode();
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 1 && this.fWikiModel.peekNode().equals(BOLD) && this.fWikiModel.getNode(this.fWikiModel.stackSize() - 2).equals(ITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.popNode();
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 1 && this.fWikiModel.peekNode().equals(ITALIC) && this.fWikiModel.getNode(this.fWikiModel.stackSize() - 2).equals(BOLD)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.popNode();
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLD)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("i"));
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(ITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("b"));
                        break;
                    }
                    this.fWikiModel.pushNode(new WPBoldItalicTag());
                    break;
                }
                case 3: {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLDITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("i"));
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLD)) {
                        this.fWikiModel.popNode();
                        break;
                    }
                    this.fWikiModel.pushNode(new WPTag("b"));
                    break;
                }
                case 4: {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLDITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("b"));
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(ITALIC)) {
                        this.fWikiModel.popNode();
                        break;
                    }
                    this.fWikiModel.pushNode(new WPTag("i"));
                }
            }
        }
        this.reduceTokenStack();
        if (!this.fNoToC && this.fTableOfContentTag != null && (this.fHeadCounter > 3 || this.fForceToC)) {
            this.fTableOfContentTag.setShowToC(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void reduceTokenStack() {
        if (this.fWikiModel.stackSize() != 0) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.fWikiModel.popNode();
lbl5:
            // 2 sources

            ** while (this.fWikiModel.stackSize() > 0)
        }
lbl6:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    private void reduceTokenStack(TagToken node) {
        block4: {
            allowedParents = node.getParents();
            if (allowedParents == null) ** GOTO lbl16
            index = -1;
            while (this.fWikiModel.stackSize() > 0) {
                tag = this.fWikiModel.peekNode();
                index = allowedParents.indexOf("|" + tag.getName() + "|");
                if (index < 0) {
                    this.fWikiModel.popNode();
                    if (!tag.getName().equals(node.getName())) {
                        continue;
                    }
                }
                break block4;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                this.fWikiModel.popNode();
lbl16:
                // 2 sources

                ** while (this.fWikiModel.stackSize() > 0)
            }
        }
    }

    private void reduceStackUntilToken(TagToken node) {
        int index = -1;
        String allowedParents = node.getParents();
        while (this.fWikiModel.stackSize() > 0) {
            TagToken tag = this.fWikiModel.peekNode();
            if (node.getName().equals(tag.getName())) {
                this.fWikiModel.popNode();
                break;
            }
            if (allowedParents == null) {
                this.fWikiModel.popNode();
                continue;
            }
            index = allowedParents.indexOf("|" + tag.getName() + "|");
            if (index >= 0) break;
            this.fWikiModel.popNode();
        }
    }

    public boolean isNoToC() {
        return this.fNoToC;
    }

    @Override
    public void setNoToC(boolean noToC) {
        this.fNoToC = noToC;
    }

    public static void parse(String rawWikiText, IWikiModel wikiModel) {
        try {
            wikiModel.setUp();
            StringBuilder buf = new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
            TracParser.parseRecursive(rawWikiText, wikiModel, false, false);
        }
        finally {
            wikiModel.tearDown();
        }
    }

    public static void parseRecursive(String rawWikitext, IWikiModel wikiModel) {
        TracParser.parseRecursive(rawWikitext, wikiModel, false, true);
    }

    public static TagStack parseRecursive(String rawWikitext, IWikiModel wikiModel, boolean createOnlyLocalStack, boolean noTOC) {
        AbstractParser parser = wikiModel.createNewInstance(rawWikitext);
        return parser.parseRecursiveInternal(rawWikitext, wikiModel, createOnlyLocalStack, noTOC);
    }

    public boolean isTemplate() {
        return this.fRenderTemplate;
    }
}

