/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.Messages;
import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.HTMLConverter;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.LaTeXConverter;
import info.bliki.wiki.filter.MagicWord;
import info.bliki.wiki.filter.PDFConverter;
import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.filter.TracParser;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.IConfiguration;
import info.bliki.wiki.model.IEventListener;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.model.Reference;
import info.bliki.wiki.model.SemanticAttribute;
import info.bliki.wiki.model.SemanticRelation;
import info.bliki.wiki.tags.TableOfContentTag;
import info.bliki.wiki.tags.WPATag;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import info.bliki.wiki.tags.util.TagStack;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTracModel
implements IWikiModel {
    protected ArrayList<String> fCategoryNamespaces;
    protected ArrayList<String> fTemplateNamespaces;
    protected ArrayList<String> fImageNamespaces;
    protected ArrayList<Reference> fReferences;
    protected Map<String, Integer> fReferenceNames;
    protected int fRecursionLevel;
    protected boolean fReplaceColon;
    protected TagStack fTagStack;
    private boolean fInitialized = false;
    private int fNumber;
    private IConfiguration fConfiguration;
    private IEventListener fWikiListener = null;
    private ResourceBundle fResourceBundle;
    protected String fRedirectLink = null;
    protected TableOfContentTag fTableOfContentTag = null;

    public AbstractTracModel() {
        this(Configuration.DEFAULT_CONFIGURATION);
    }

    public AbstractTracModel(Configuration configuration) {
        this(configuration, Locale.ENGLISH);
    }

    public AbstractTracModel(Configuration configuration, Locale locale) {
        this(configuration, Messages.getResourceBundle(locale));
    }

    public AbstractTracModel(Configuration configuration, ResourceBundle resourceBundle) {
        this.fConfiguration = configuration;
        this.fResourceBundle = resourceBundle;
        this.initialize();
    }

    @Override
    public void addCategory(String categoryName, String sortKey) {
    }

    @Override
    public SourceCodeFormatter addCodeFormatter(String key, SourceCodeFormatter value) {
        return this.fConfiguration.addCodeFormatter(key, value);
    }

    @Override
    public String addInterwikiLink(String key, String value) {
        return this.fConfiguration.addInterwikiLink(key, value);
    }

    @Override
    public void addLink(String topicName) {
    }

    @Override
    public boolean addSemanticAttribute(String attribute, String attributeValue) {
        return false;
    }

    @Override
    public boolean addSemanticRelation(String relation, String relationValue) {
        return false;
    }

    @Override
    public void addTemplate(String template) {
    }

    @Override
    public ITemplateFunction addTemplateFunction(String key, ITemplateFunction value) {
        return this.fConfiguration.addTemplateFunction(key, value);
    }

    @Override
    public TagToken addTokenTag(String key, TagToken value) {
        return this.fConfiguration.addTokenTag(key, value);
    }

    @Override
    public String[] addToReferences(String reference, String nameAttribute) {
        Integer index;
        String[] result = new String[2];
        result[1] = null;
        if (this.fReferences == null) {
            this.fReferences = new ArrayList();
            this.fReferenceNames = new HashMap<String, Integer>();
        }
        if (nameAttribute != null && (index = this.fReferenceNames.get(nameAttribute)) != null) {
            result[0] = index.toString();
            Reference ref = this.fReferences.get(index - 1);
            int count = ref.incCounter();
            result[1] = count >= "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".length() ? String.valueOf(nameAttribute) + '_' + 'Z' : String.valueOf(nameAttribute) + '_' + "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".charAt(count);
            return result;
        }
        if (nameAttribute != null) {
            this.fReferences.add(new Reference(reference, nameAttribute));
            index = this.fReferences.size();
            this.fReferenceNames.put(nameAttribute, index);
            result[1] = String.valueOf(nameAttribute) + "_a";
        } else {
            this.fReferences.add(new Reference(reference));
        }
        result[0] = Integer.toString(this.fReferences.size());
        return result;
    }

    @Override
    public void append(BaseToken contentNode) {
        this.fTagStack.append(contentNode);
    }

    @Override
    public void appendExternalImageLink(String imageSrc, String imageAltText) {
        TagNode spanTagNode = new TagNode("span");
        this.append(spanTagNode);
        spanTagNode.addAttribute("class", "image", true);
        TagNode imgTagNode = new TagNode("img");
        spanTagNode.addChild(imgTagNode);
        imgTagNode.addAttribute("src", imageSrc, true);
        imgTagNode.addAttribute("alt", imageAltText, true);
        imgTagNode.addAttribute("rel", "nofollow", true);
    }

    @Override
    public void appendExternalLink(String link, String linkName, boolean withoutSquareBrackets) {
        String ext;
        int indx = (link = Utils.escapeXml(link, true, false, false)).lastIndexOf(".");
        if (indx > 0 && indx < link.length() - 3 && ((ext = link.substring(indx + 1)).equalsIgnoreCase("gif") || ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("bmp"))) {
            this.appendExternalImageLink(link, linkName);
            return;
        }
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", link, true);
        aTagNode.addAttribute("class", "externallink", true);
        aTagNode.addAttribute("title", link, true);
        aTagNode.addAttribute("rel", "nofollow", true);
        aTagNode.addChild(new ContentToken(linkName));
    }

    @Override
    public void appendInternalImageLink(String hrefImageLink, String srcImageLink, ImageFormat imageFormat) {
        int pxSize = imageFormat.getSize();
        String caption = imageFormat.getCaption();
        TagNode divTagNode = new TagNode("div");
        divTagNode.addAttribute("id", "image", true);
        divTagNode.addAttribute("href", hrefImageLink, true);
        divTagNode.addAttribute("src", srcImageLink, true);
        divTagNode.addObjectAttribute("wikiobject", imageFormat);
        if (pxSize != -1) {
            divTagNode.addAttribute("style", "width:" + pxSize + "px", true);
        }
        this.pushNode(divTagNode);
        if (caption != null && caption.length() > 0) {
            TagNode captionTagNode = new TagNode("div");
            String clazzValue = "caption";
            String type = imageFormat.getType();
            if (type != null) {
                clazzValue = String.valueOf(type) + clazzValue;
            }
            captionTagNode.addAttribute("class", clazzValue, true);
            this.pushNode(captionTagNode);
            TracParser.parseRecursive(caption, this);
            this.popNode();
        }
        this.popNode();
    }

    @Override
    public void appendInternalLink(String topic, String hashSection, String topicDescription, String cssClass) {
        WPATag aTagNode = new WPATag();
        this.append(aTagNode);
        aTagNode.addAttribute("id", "w", true);
        String href = topic;
        if (hashSection != null) {
            href = String.valueOf(href) + '#' + hashSection;
        }
        aTagNode.addAttribute("href", href, true);
        aTagNode.addObjectAttribute("wikilink", topic);
        ContentToken text = new ContentToken(topicDescription);
        aTagNode.addChild(text);
    }

    @Override
    public void appendInterWikiLink(String namespace, String title, String linkText) {
        String hrefLink = this.getInterwikiMap().get(namespace.toLowerCase());
        if (hrefLink == null) {
            hrefLink = "#";
        }
        String encodedtopic = Encoder.encodeTitleUrl(title);
        if (this.replaceColon()) {
            encodedtopic = encodedtopic.replaceAll(":", "/");
        }
        hrefLink = hrefLink.replace("${title}", encodedtopic);
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", hrefLink, true);
        aTagNode.addChild(new ContentToken(linkText));
    }

    @Override
    public void appendISBNLink(String isbnPureText) {
        StringBuffer isbnUrl = new StringBuffer(isbnPureText.length() + 100);
        isbnUrl.append("http://www.amazon.com/exec/obidos/ASIN/");
        int index = 0;
        while (index < isbnPureText.length()) {
            if (isbnPureText.charAt(index) >= '0' && isbnPureText.charAt(index) <= '9') {
                isbnUrl.append(isbnPureText.charAt(index));
            }
            ++index;
        }
        String isbnString = isbnUrl.toString();
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", isbnString, true);
        aTagNode.addAttribute("class", "external text", true);
        aTagNode.addAttribute("title", isbnString, true);
        aTagNode.addAttribute("rel", "nofollow", true);
        aTagNode.addChild(new ContentToken(isbnPureText));
    }

    @Override
    public void appendMailtoLink(String link, String linkName, boolean withoutSquareBrackets) {
        String ext;
        int indx = (link = Utils.escapeXml(link, true, false, false)).lastIndexOf(".");
        if (indx > 0 && indx < link.length() - 3 && ((ext = link.substring(indx + 1)).equalsIgnoreCase("gif") || ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("bmp"))) {
            this.appendExternalImageLink(link, linkName);
            return;
        }
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", link, true);
        aTagNode.addAttribute("class", "external free", true);
        aTagNode.addAttribute("title", link, true);
        aTagNode.addAttribute("rel", "nofollow", true);
        aTagNode.addChild(new ContentToken(linkName));
    }

    @Override
    public void appendRawWikipediaLink(String rawLinkText, String suffix) {
        String rawTopicName = rawLinkText;
        if (rawTopicName != null) {
            String viewableLinkDescription;
            int trimLeftIndex = 0;
            while (trimLeftIndex < rawTopicName.length() && rawTopicName.charAt(trimLeftIndex) <= ' ') {
                ++trimLeftIndex;
            }
            if (trimLeftIndex > 0) {
                rawTopicName = rawTopicName.substring(trimLeftIndex);
            }
            int pipeIndex = rawTopicName.lastIndexOf(124);
            String alias = "";
            if (-1 != pipeIndex) {
                alias = rawTopicName.substring(pipeIndex + 1);
                rawTopicName = rawTopicName.substring(0, pipeIndex);
                if (alias.length() == 0) {
                    alias = rawTopicName;
                    int index = alias.indexOf(58);
                    if (index != -1) {
                        alias = alias.substring(index + 1).trim();
                    } else {
                        index = alias.indexOf(40);
                        if (index != -1) {
                            alias = alias.substring(0, index).trim();
                        } else {
                            index = alias.indexOf(44);
                            if (index != -1) {
                                alias = alias.substring(0, index).trim();
                            }
                        }
                    }
                }
            }
            int hashIndex = rawTopicName.lastIndexOf(35);
            String hash = "";
            if (-1 != hashIndex && hashIndex != rawTopicName.length() - 1) {
                hash = rawTopicName.substring(hashIndex + 1);
                rawTopicName = rawTopicName.substring(0, hashIndex);
            }
            int trimRightIndex = rawTopicName.length() - 1;
            while (trimRightIndex >= 0 && rawTopicName.charAt(trimRightIndex) <= ' ') {
                --trimRightIndex;
            }
            if (trimRightIndex != rawTopicName.length() - 1) {
                rawTopicName = rawTopicName.substring(0, trimRightIndex + 1);
            }
            if (this.appendRawNamespaceLinks(rawTopicName = Encoder.encodeHtml(rawTopicName), viewableLinkDescription = -1 != pipeIndex ? String.valueOf(alias) + suffix : (rawTopicName.length() > 0 && rawTopicName.charAt(0) == ':' ? String.valueOf(rawTopicName.substring(1)) + suffix : String.valueOf(rawTopicName) + suffix), -1 == pipeIndex)) {
                return;
            }
            int indx = rawTopicName.indexOf(58);
            String namespace = null;
            if (indx >= 0) {
                namespace = rawTopicName.substring(0, indx);
            }
            if (namespace != null && this.isImageNamespace(namespace)) {
                this.parseInternalImageLink(namespace, rawLinkText);
                return;
            }
            if (rawTopicName.length() > 0 && rawTopicName.charAt(0) == ':') {
                rawTopicName = rawTopicName.substring(1);
            }
            if (rawTopicName.length() > 0 && rawTopicName.charAt(0) == ':') {
                rawTopicName = rawTopicName.substring(1);
            }
            this.addLink(rawTopicName);
            if (-1 != hashIndex) {
                this.appendInternalLink(rawTopicName, hash, viewableLinkDescription, null);
            } else {
                this.appendInternalLink(rawTopicName, null, viewableLinkDescription, null);
            }
        }
    }

    @Override
    public boolean appendRawNamespaceLinks(String rawNamespaceTopic, String viewableLinkDescription, boolean containsNoPipe) {
        int colonIndex = rawNamespaceTopic.indexOf(58);
        if (colonIndex != -1) {
            String title;
            String nameSpace = rawNamespaceTopic.substring(0, colonIndex);
            if (this.isSemanticWebActive() && rawNamespaceTopic.length() > colonIndex + 1) {
                String attributeValue;
                if (rawNamespaceTopic.charAt(colonIndex + 1) == ':') {
                    String relationValue = rawNamespaceTopic.substring(colonIndex + 2);
                    if (this.addSemanticRelation(nameSpace, relationValue)) {
                        if (containsNoPipe) {
                            viewableLinkDescription = relationValue;
                        }
                        if (viewableLinkDescription.trim().length() > 0) {
                            this.appendInternalLink(relationValue, null, viewableLinkDescription, null);
                        }
                        return true;
                    }
                } else if (rawNamespaceTopic.charAt(colonIndex + 1) == '=' && this.addSemanticAttribute(nameSpace, attributeValue = rawNamespaceTopic.substring(colonIndex + 2))) {
                    this.append(new ContentToken(attributeValue));
                    return true;
                }
            }
            if (this.isCategoryNamespace(nameSpace)) {
                String category = rawNamespaceTopic.substring(colonIndex + 1);
                if (category != null && category.length() > 0) {
                    this.addCategory(category, "");
                    return true;
                }
            } else if (this.isInterWiki(nameSpace) && (title = rawNamespaceTopic.substring(colonIndex + 1)) != null && title.length() > 0) {
                this.appendInterWikiLink(nameSpace, title, viewableLinkDescription);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean appendRedirectLink(String redirectLink) {
        this.fRedirectLink = redirectLink;
        return true;
    }

    @Override
    public void appendSignature(Appendable writer, int numberOfTildes) throws IOException {
        switch (numberOfTildes) {
            case 3: {
                writer.append("~~~");
                break;
            }
            case 4: {
                writer.append("~~~~");
                break;
            }
            case 5: {
                writer.append("~~~~~");
            }
        }
    }

    @Override
    public void appendStack(TagStack stack) {
        if (stack != null) {
            this.fTagStack.append(stack);
        }
    }

    @Override
    public void buildEditLinkUrl(int section) {
    }

    @Override
    public int decrementRecursionLevel() {
        return --this.fRecursionLevel;
    }

    @Override
    public String get2ndCategoryNamespace() {
        return this.getCategoryNamespace();
    }

    @Override
    public String get2ndImageNamespace() {
        return this.getImageNamespace();
    }

    @Override
    public String get2ndTemplateNamespace() {
        return this.getTemplateNamespace();
    }

    @Override
    public String getCategoryNamespace() {
        return "Category";
    }

    @Override
    public Map<String, SourceCodeFormatter> getCodeFormatterMap() {
        return this.fConfiguration.getCodeFormatterMap();
    }

    @Override
    public String getImageNamespace() {
        return "Image";
    }

    @Override
    public Map<String, String> getInterwikiMap() {
        return this.fConfiguration.getInterwikiMap();
    }

    @Override
    public int getNextNumber() {
        return this.fNumber++;
    }

    @Override
    public TagToken getNode(int offset) {
        return (TagToken)this.fTagStack.get(offset);
    }

    @Override
    public String getRawWikiContent(String namespace, String templateName, Map<String, String> templateParameters) {
        if (this.isTemplateNamespace(namespace) && MagicWord.isMagicWord(templateName)) {
            return MagicWord.processMagicWord(templateName);
        }
        return null;
    }

    @Override
    public int getRecursionLevel() {
        return this.fRecursionLevel;
    }

    @Override
    public String getRedirectLink() {
        return this.fRedirectLink;
    }

    @Override
    public List<Reference> getReferences() {
        return this.fReferences;
    }

    @Override
    public List<SemanticAttribute> getSemanticAttributes() {
        return null;
    }

    @Override
    public List<SemanticRelation> getSemanticRelations() {
        return null;
    }

    @Override
    public TableOfContentTag getTableOfContentTag(boolean isTOCIdentifier) {
        if (this.fTableOfContentTag == null) {
            TableOfContentTag tableOfContentTag = new TableOfContentTag("div");
            tableOfContentTag.addAttribute("id", "tableofcontent", true);
            tableOfContentTag.setShowToC(false);
            tableOfContentTag.setTOCIdentifier(isTOCIdentifier);
            this.fTableOfContentTag = tableOfContentTag;
        } else if (isTOCIdentifier) {
            TableOfContentTag tableOfContentTag = (TableOfContentTag)this.fTableOfContentTag.clone();
            this.fTableOfContentTag.setShowToC(false);
            tableOfContentTag.setShowToC(true);
            tableOfContentTag.setTOCIdentifier(isTOCIdentifier);
            this.fTableOfContentTag = tableOfContentTag;
        } else {
            return this.fTableOfContentTag;
        }
        this.append(this.fTableOfContentTag);
        return this.fTableOfContentTag;
    }

    @Override
    public ITemplateFunction getTemplateFunction(String name) {
        return this.getTemplateMap().get(name);
    }

    @Override
    public Map<String, ITemplateFunction> getTemplateMap() {
        return this.fConfiguration.getTemplateMap();
    }

    @Override
    public String getTemplateNamespace() {
        return "Template";
    }

    @Override
    public Map<String, TagToken> getTokenMap() {
        return this.fConfiguration.getTokenMap();
    }

    @Override
    public IEventListener getWikiListener() {
        return this.fWikiListener;
    }

    @Override
    public int incrementRecursionLevel() {
        return ++this.fRecursionLevel;
    }

    private void initialize() {
        this.fNumber = 0;
        if (!this.fInitialized) {
            this.fWikiListener = null;
            this.fCategoryNamespaces = new ArrayList();
            this.fTemplateNamespaces = new ArrayList();
            this.fImageNamespaces = new ArrayList();
            this.fTagStack = new TagStack();
            this.fReferences = null;
            this.fReferenceNames = null;
            this.fRecursionLevel = 0;
            this.fReplaceColon = false;
            this.fCategoryNamespaces.add("Category");
            this.fTemplateNamespaces.add("Template");
            this.fImageNamespaces.add("Image");
            this.fInitialized = true;
        }
    }

    @Override
    public boolean isCategoryNamespace(String namespace) {
        int i = 0;
        while (i < this.fCategoryNamespaces.size()) {
            if (namespace.equalsIgnoreCase(this.fCategoryNamespaces.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isEditorMode() {
        return false;
    }

    @Override
    public boolean isImageNamespace(String namespace) {
        int i = 0;
        while (i < this.fImageNamespaces.size()) {
            if (namespace.equalsIgnoreCase(this.fImageNamespaces.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isInterWiki(String namespace) {
        return this.getInterwikiMap().containsKey(namespace.toLowerCase());
    }

    @Override
    public boolean isMathtranRenderer() {
        return false;
    }

    @Override
    public boolean isNamespace(String namespace) {
        return this.isImageNamespace(namespace) || this.isTemplateNamespace(namespace) || this.isCategoryNamespace(namespace);
    }

    @Override
    public boolean isPreviewMode() {
        return false;
    }

    @Override
    public boolean isSemanticWebActive() {
        return false;
    }

    @Override
    public boolean isTemplateNamespace(String namespace) {
        int i = 0;
        while (i < this.fTemplateNamespaces.size()) {
            if (namespace.equalsIgnoreCase(this.fTemplateNamespaces.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isTemplateTopic() {
        return false;
    }

    @Override
    public boolean parseBBCodes() {
        return false;
    }

    @Override
    public void parseEvents(IEventListener listener, String rawWikiText) {
        this.initialize();
        if (rawWikiText == null) {
            return;
        }
        this.fWikiListener = listener;
        TracParser.parse(rawWikiText, this);
        this.fInitialized = false;
    }

    @Override
    public String parseTemplates(String rawWikiText) {
        return this.parseTemplates(rawWikiText, false);
    }

    @Override
    public String parseTemplates(String rawWikiText, boolean parseOnlySignature) {
        if (rawWikiText == null) {
            return "";
        }
        this.initialize();
        StringBuilder buf = new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
        try {
            TemplateParser.parse(rawWikiText, this, buf, parseOnlySignature, false);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            buf.append("<span class=\"error\">TemplateParser exception: " + ioe.getClass().getSimpleName() + "</span>");
        }
        return buf.toString();
    }

    @Override
    public TagToken peekNode() {
        return this.fTagStack.peek();
    }

    @Override
    public TagToken popNode() {
        return this.fTagStack.pop();
    }

    @Override
    public boolean pushNode(TagToken node) {
        return this.fTagStack.push(node);
    }

    @Override
    public String render(ITextConverter converter, String rawWikiText) {
        this.initialize();
        if (rawWikiText == null) {
            return "";
        }
        TracParser.parse(rawWikiText, this);
        StringBuilder buf = new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
        List<BaseToken> list = this.fTagStack.getNodeList();
        try {
            converter.nodesToText(list, buf, this);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        this.fInitialized = false;
        return buf.toString();
    }

    @Override
    public String render(String rawWikiText) {
        return this.render(new HTMLConverter(), rawWikiText);
    }

    public String renderLaTeX(String rawWikiText) {
        return this.render(new LaTeXConverter(), rawWikiText);
    }

    @Override
    public String renderPDF(String rawWikiText) {
        return this.render(new PDFConverter(), rawWikiText);
    }

    @Override
    public boolean replaceColon() {
        return true;
    }

    @Override
    public void setSemanticWebActive(boolean semanticWeb) {
    }

    @Override
    public void setUp() {
        this.fRecursionLevel = 0;
    }

    @Override
    public boolean showSyntax(String tagName) {
        return true;
    }

    @Override
    public int stackSize() {
        return this.fTagStack.size();
    }

    @Override
    public TagStack swapStack(TagStack stack) {
        TagStack temp = this.fTagStack;
        this.fTagStack = stack;
        return temp;
    }

    @Override
    public void tearDown() {
    }

    public List<BaseToken> toNodeList(String rawWikiText) {
        this.initialize();
        if (rawWikiText == null) {
            return new ArrayList<BaseToken>();
        }
        TracParser.parse(rawWikiText, this);
        this.fInitialized = false;
        return this.fTagStack.getNodeList();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    @Override
    public AbstractParser createNewInstance(String rawWikitext) {
        return new TracParser(rawWikitext, this.getWikiListener());
    }
}

