/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.jpa;

import com.nokia.helium.jpa.ORMEntityManager;
import com.nokia.helium.jpa.ORMUtil;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.apache.log4j.Logger;

public class ORMReader {
    private static Logger log = Logger.getLogger(ORMReader.class);
    private static final int READ_CACHE_LIMIT = 30000;
    private ORMEntityManager manager;
    private int startPos;

    public ORMReader(String dbPath) {
        ORMUtil.initializeORM(dbPath);
        this.manager = ORMUtil.getEntityManager(dbPath);
    }

    public List executeNativeQuery(String queryString, String type) {
        int maxResults = 30000;
        String queryWithSubSet = queryString + " OFFSET " + this.startPos + " ROWS FETCH FIRST " + maxResults + " ROW ONLY";
        Query query = null;
        try {
            query = this.manager.getEntityManager().createNativeQuery(queryWithSubSet, Class.forName(type));
        }
        catch (Exception ex) {
            log.debug((Object)"Exception during native query", (Throwable)ex);
        }
        query.setHint("eclipselink.maintain-cache", (Object)"false");
        List results = query.getResultList();
        int resultsSize = results.size();
        this.startPos = resultsSize == 0 || resultsSize < 30000 ? (this.startPos += resultsSize) : (this.startPos += maxResults);
        return results;
    }

    public Object executeSingleResult(String queryString, String type) {
        log.debug((Object)("executeSingleResult: " + queryString));
        Query query = this.manager.getEntityManager().createQuery(queryString);
        query.setHint("eclipselink.persistence-context.reference-mode", (Object)"WEAK");
        query.setHint("eclipselink.maintain-cache", (Object)"false");
        query.setHint("eclipselink.read-only", (Object)"true");
        Object obj = null;
        try {
            obj = query.getSingleResult();
        }
        catch (NoResultException nex) {
            log.debug((Object)"no results:", (Throwable)nex);
        }
        catch (NonUniqueResultException nux) {
            log.debug((Object)"more than one result returned:", (Throwable)nux);
        }
        return obj;
    }

    public List executeQuery(String queryString) {
        int maxResults = 30000;
        Query query = this.manager.getEntityManager().createQuery(queryString);
        query.setHint("eclipselink.persistence-context.reference-mode", (Object)"WEAK");
        query.setHint("eclipselink.maintain-cache", (Object)"false");
        query.setHint("eclipselink.read-only", (Object)"true");
        query.setFirstResult(this.startPos);
        query.setMaxResults(maxResults);
        List results = query.getResultList();
        int resultsSize = results.size();
        log.debug((Object)("result size: " + resultsSize));
        this.startPos = results.size() == 0 || resultsSize < 30000 ? (this.startPos += resultsSize) : (this.startPos += maxResults);
        return results;
    }
}

