/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.diff;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

public class HgDiffConsumer
extends HgConsumer {
    private static final String INDEX_TOKEN = "diff -r ";
    private static final String FILE_SEPARATOR_TOKEN = "===";
    private static final String START_REVISION_TOKEN = "---";
    private static final String END_REVISION_TOKEN = "+++";
    private static final String ADDED_LINE_TOKEN = "+";
    private static final String REMOVED_LINE_TOKEN = "-";
    private static final String UNCHANGED_LINE_TOKEN = " ";
    private static final String CHANGE_SEPARATOR_TOKEN = "@@";
    private static final String NO_NEWLINE_TOKEN = "\\ No newline at end of file";
    private static final int HASH_ID_LEN = 12;
    private ScmLogger logger;
    private String currentFile;
    private StringBuffer currentDifference;
    private List changedFiles = new ArrayList();
    private Map differences = new HashMap();
    private StringBuffer patch = new StringBuffer();
    private File workingDirectory;

    public HgDiffConsumer(ScmLogger logger, File workingDirectory) {
        super(logger);
        this.logger = logger;
        this.workingDirectory = workingDirectory;
    }

    public void consumeLine(String line) {
        if (line.startsWith(INDEX_TOKEN)) {
            this.currentFile = line.substring(INDEX_TOKEN.length() + 12 + 1);
            this.changedFiles.add(new ScmFile(this.currentFile, ScmFileStatus.MODIFIED));
            this.currentDifference = new StringBuffer();
            this.differences.put(this.currentFile, this.currentDifference);
            this.patch.append(line).append("\n");
            return;
        }
        if (this.currentFile == null) {
            this.logger.warn("Unparseable line: '" + line + "'");
            this.patch.append(line).append("\n");
            return;
        }
        if (line.startsWith(FILE_SEPARATOR_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(START_REVISION_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(END_REVISION_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(ADDED_LINE_TOKEN) || line.startsWith(REMOVED_LINE_TOKEN) || line.startsWith(UNCHANGED_LINE_TOKEN) || line.startsWith(CHANGE_SEPARATOR_TOKEN) || line.equals(NO_NEWLINE_TOKEN)) {
            this.currentDifference.append(line).append("\n");
            this.patch.append(line).append("\n");
        } else {
            this.logger.warn("Unparseable line: '" + line + "'");
            this.patch.append(line).append("\n");
            this.currentFile = null;
            this.currentDifference = null;
        }
    }

    public List getChangedFiles() {
        return this.changedFiles;
    }

    public Map getDifferences() {
        return this.differences;
    }

    public String getPatch() {
        return this.patch.toString();
    }
}

