/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.diamonds;

import com.nokia.helium.core.PropertiesSource;
import com.nokia.helium.core.TemplateProcessor;
import com.nokia.helium.diamonds.DiamondsClient;
import com.nokia.helium.diamonds.DiamondsConfig;
import com.nokia.helium.diamonds.DiamondsException;
import com.nokia.helium.diamonds.DiamondsListener;
import com.nokia.helium.diamonds.DiamondsProperties;
import com.nokia.helium.diamonds.XMLMerger;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.FileUtils;

public class DiamondsListenerImpl
implements DiamondsListener {
    private static ArrayList<File> finalLogList = new ArrayList();
    private static DiamondsClient diamondsClient;
    private static boolean isInitialized;
    private static ArrayList<String> deferLogList;
    private TemplateProcessor templateProcessor;
    private Project project;
    private SimpleDateFormat timeFormat;
    private Date buildStartTime;
    private Logger log = Logger.getLogger(DiamondsListenerImpl.class);

    public DiamondsListenerImpl() {
        this.templateProcessor = new TemplateProcessor();
        this.timeFormat = new SimpleDateFormat(DiamondsConfig.getDiamondsProperties().getProperty("tstampformat"));
    }

    @Override
    public final void buildBegin(BuildEvent buildEvent) throws DiamondsException {
        this.project = buildEvent.getProject();
        this.buildStartTime = new Date();
    }

    @Override
    public final void buildEnd(BuildEvent buildEvent) throws DiamondsException {
        if (DiamondsListenerImpl.isInitialized()) {
            this.log.debug((Object)"diamonds:DiamondsListenerImpl:sending final data to diamonds.");
            String output = DiamondsConfig.getOutputDir() + File.separator + "diamonds-finish.xml";
            File outputFile = new File(output);
            String finishTemplateFile = "diamonds_finish.xml.ftl";
            try {
                Properties tempProperties = new Properties();
                tempProperties.put("build.end.time", this.timeFormat.format(new Date()));
                ArrayList<PropertiesSource> sourceList = new ArrayList<PropertiesSource>();
                sourceList.add(new PropertiesSource("ant", (Map)this.project.getProperties()));
                sourceList.add(new PropertiesSource("diamonds", tempProperties));
                this.templateProcessor.convertTemplate(DiamondsConfig.getTemplateDir(), finishTemplateFile, output, sourceList);
            }
            catch (Exception e) {
                throw new DiamondsException("failed to convert the build finish template: " + e.getMessage());
            }
            try {
                this.log.info((Object)"Sending final data to diamonds.");
                diamondsClient.sendData(output, DiamondsConfig.getDiamondsProperties().getDiamondsBuildID());
            }
            catch (Exception e) {
                throw new DiamondsException("Failed to send data to diamonds: " + e.getMessage());
            }
            DiamondsListenerImpl.mergeToFullResults(outputFile);
            isInitialized = false;
            DiamondsProperties props = DiamondsConfig.getDiamondsProperties();
            String smtpServer = this.project.getProperty(props.getProperty("smtpserver"));
            String ldapServer = this.project.getProperty(props.getProperty("ldapserver"));
            try {
                File first = finalLogList.remove(0);
                String outputDir = DiamondsConfig.getOutputDir();
                File fullResultsFile = new File(outputDir + File.separator + "diamonds-full-results.xml");
                FileUtils.getFileUtils().copyFile(first, fullResultsFile);
                XMLMerger merger = new XMLMerger(fullResultsFile);
                HashSet<File> h = new HashSet<File>(finalLogList);
                for (File f : h) {
                    try {
                        merger.merge(f);
                    }
                    catch (XMLMerger.XMLMergerException xe) {
                        this.log.debug((Object)"Error during the merge: ", (Throwable)xe);
                    }
                }
                diamondsClient.sendDataByMail(fullResultsFile.getAbsolutePath(), smtpServer, ldapServer);
            }
            catch (Exception e) {
                this.log.error((Object)"Error sending diamonds final log: ", (Throwable)e);
            }
        }
    }

    @Override
    public void targetBegin(BuildEvent buildEvent) throws DiamondsException {
        this.initDiamondsClient();
    }

    @Override
    public void targetEnd(BuildEvent buildEvent) throws DiamondsException {
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void mergeToFullResults(File xmlFile) throws DiamondsException {
        finalLogList.add(xmlFile);
    }

    protected String getSourceFile(String inputName) {
        return DiamondsConfig.getOutputDir() + File.separator + inputName + ".xml";
    }

    protected DiamondsClient getDiamondsClient() {
        return diamondsClient;
    }

    protected TemplateProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    protected boolean getIsInitialized() {
        return isInitialized;
    }

    protected SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    protected ArrayList<String> getDeferLogList() {
        return deferLogList;
    }

    protected void initDiamondsClient() throws DiamondsException {
        String outputDir = DiamondsConfig.getOutputDir();
        if (!isInitialized) {
            String startTemplateFile = "diamonds_start.xml.ftl";
            String output = outputDir + File.separator + "diamonds-start.log.xml";
            File outputFile = new File(output);
            try {
                Properties tempProperties = new Properties();
                tempProperties.put("build.start.time", this.timeFormat.format(this.buildStartTime));
                ArrayList<PropertiesSource> sourceList = new ArrayList<PropertiesSource>();
                sourceList.add(new PropertiesSource("ant", (Map)this.project.getProperties()));
                sourceList.add(new PropertiesSource("diamonds", tempProperties));
                DiamondsProperties diamondsProperties = DiamondsConfig.getDiamondsProperties();
                this.templateProcessor.convertTemplate(DiamondsConfig.getTemplateDir(), startTemplateFile, output, sourceList);
                DiamondsListenerImpl.mergeToFullResults(outputFile);
                this.log.info((Object)"Initializing diamonds client");
                diamondsClient = new DiamondsClient(this.project.getProperty(diamondsProperties.getProperty("host")), this.project.getProperty(diamondsProperties.getProperty("port")), this.project.getProperty(diamondsProperties.getProperty("path")), this.project.getProperty(diamondsProperties.getProperty("mail")));
                String buildID = diamondsClient.getBuildId(outputFile.getAbsolutePath());
                if (buildID != null) {
                    diamondsProperties.setDiamondsBuildID(buildID);
                    this.project.setProperty(diamondsProperties.getProperty("buildid-property"), diamondsProperties.getDiamondsBuildID());
                    this.log.info((Object)("Got build id from diamonds: " + buildID));
                } else {
                    diamondsProperties.setDiamondsBuildID(buildID);
                    this.project.setProperty(diamondsProperties.getProperty("buildid-property"), "default");
                    this.log.info((Object)"diamonds build id set to default and in record only mode");
                }
                if (deferLogList.size() > 0) {
                    this.log.debug((Object)"diamonds:DiamondsListenerImpl: sending DefferList");
                    ListIterator<String> defferList = deferLogList.listIterator();
                    while (defferList.hasNext()) {
                        String mergedDeferFile = defferList.next();
                        DiamondsListenerImpl.mergeToFullResults(new File(mergedDeferFile));
                        diamondsClient.sendData(mergedDeferFile, DiamondsConfig.getDiamondsProperties().getDiamondsBuildID());
                    }
                    deferLogList.clear();
                }
                isInitialized = true;
            }
            catch (Exception e) {
                throw new DiamondsException("failed to connect to diamonds: " + e.getMessage());
            }
        }
    }

    static {
        deferLogList = new ArrayList();
    }
}

