/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

class HtmlTag {
    private static final int MAX_TEXT_LEN = 60;
    private final String mId;
    private final int mLineNo;
    private final int mPosition;
    private final String mText;
    private final boolean mClosedTag;
    private final boolean mIncomplete;

    HtmlTag(String aId, int aLineNo, int aPosition, boolean aClosedTag, boolean aIncomplete, String aText) {
        this.mId = !"".equals(aId) && aId.charAt(0) == '/' ? aId.substring(1) : aId;
        this.mLineNo = aLineNo;
        this.mPosition = aPosition;
        this.mText = aText;
        this.mClosedTag = aClosedTag;
        this.mIncomplete = aIncomplete;
    }

    public String getId() {
        return this.mId;
    }

    public boolean isCloseTag() {
        if (this.mPosition == this.mText.length() - 1) {
            return false;
        }
        return this.mText.charAt(this.mPosition + 1) == '/';
    }

    public boolean isClosedTag() {
        return this.mClosedTag;
    }

    public boolean isIncompleteTag() {
        return this.mIncomplete;
    }

    public int getLineno() {
        return this.mLineNo;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public String toString() {
        int startOfText = this.mPosition;
        int endOfText = Math.min(startOfText + 60, this.mText.length());
        return this.mText.substring(startOfText, endOfText);
    }
}

