/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import java.math.BigInteger;

public abstract class AbstractComplexityCheck
extends Check {
    private static final BigInteger INITIAL_VALUE = BigInteger.ONE;
    private final FastStack<BigInteger> mValueStack = FastStack.newInstance();
    private BigInteger mCurrentValue = BigInteger.ZERO;
    private int mMax;

    public AbstractComplexityCheck(int aMax) {
        this.mMax = aMax;
    }

    protected abstract String getMessageID();

    protected void visitTokenHook(DetailAST aAST) {
    }

    protected void leaveTokenHook(DetailAST aAST) {
    }

    public final int[] getRequiredTokens() {
        return new int[]{8, 9, 11, 12};
    }

    public final int getMax() {
        return this.mMax;
    }

    public final void setMax(int aMax) {
        this.mMax = aMax;
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.visitMethodDef();
                break;
            }
            default: {
                this.visitTokenHook(aAST);
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.leaveMethodDef(aAST);
                break;
            }
            default: {
                this.leaveTokenHook(aAST);
            }
        }
    }

    protected final BigInteger getCurrentValue() {
        return this.mCurrentValue;
    }

    protected final void setCurrentValue(BigInteger aValue) {
        this.mCurrentValue = aValue;
    }

    protected final void incrementCurrentValue(BigInteger aBy) {
        this.setCurrentValue(this.getCurrentValue().add(aBy));
    }

    protected final void pushValue() {
        this.mValueStack.push(this.mCurrentValue);
        this.mCurrentValue = INITIAL_VALUE;
    }

    protected final BigInteger popValue() {
        this.mCurrentValue = this.mValueStack.pop();
        return this.mCurrentValue;
    }

    private void visitMethodDef() {
        this.pushValue();
    }

    private void leaveMethodDef(DetailAST aAST) {
        BigInteger max = BigInteger.valueOf(this.mMax);
        if (this.mCurrentValue.compareTo(max) > 0) {
            this.log(aAST, this.getMessageID(), this.mCurrentValue, max);
        }
        this.popValue();
    }
}

