/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.ClassLoaderResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public abstract class ResourceLoader {
    public static Class loadClass(String name) throws ClassNotFoundException {
        Class caller = ClassLoaderResolver.getCallerClass(1);
        ClassLoader loader = ClassLoaderResolver.getClassLoader(caller);
        return Class.forName(name, false, loader);
    }

    public static URL getResource(String name) {
        Class caller = ClassLoaderResolver.getCallerClass(1);
        ClassLoader loader = ClassLoaderResolver.getClassLoader(caller);
        if (loader != null) {
            return loader.getResource(name);
        }
        return ClassLoader.getSystemResource(name);
    }

    public static InputStream getResourceAsStream(String name) {
        Class caller = ClassLoaderResolver.getCallerClass(1);
        ClassLoader loader = ClassLoaderResolver.getClassLoader(caller);
        if (loader != null) {
            return loader.getResourceAsStream(name);
        }
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public static Enumeration getResources(String name) throws IOException {
        Class caller = ClassLoaderResolver.getCallerClass(1);
        ClassLoader loader = ClassLoaderResolver.getClassLoader(caller);
        if (loader != null) {
            return loader.getResources(name);
        }
        return ClassLoader.getSystemResources(name);
    }

    public static Class loadClass(String name, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(name, false, loader != null ? loader : ClassLoader.getSystemClassLoader());
    }

    public static URL getResource(String name, ClassLoader loader) {
        if (loader != null) {
            return loader.getResource(name);
        }
        return ClassLoader.getSystemResource(name);
    }

    public static InputStream getResourceAsStream(String name, ClassLoader loader) {
        if (loader != null) {
            return loader.getResourceAsStream(name);
        }
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public static Enumeration getResources(String name, ClassLoader loader) throws IOException {
        if (loader != null) {
            return loader.getResources(name);
        }
        return ClassLoader.getSystemResources(name);
    }

    private ResourceLoader() {
    }
}

