/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core.ant.listener;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public class TargetTimesLogGeneratorListener
implements BuildListener {
    private String targetTimesLogCsv;
    private List<String> targetTimesTable;
    private Project project;
    private Date targetStartTime;
    private boolean isInitialized;

    public void buildStarted(BuildEvent event) {
    }

    private void initialize(Project project) {
        this.project = project;
        this.targetTimesLogCsv = project.getProperty("target.times.log.file");
        this.targetTimesTable = new ArrayList<String>();
        this.isInitialized = true;
        if (this.targetTimesLogCsv == null) {
            this.project.log("TargetTimesLog csv file will not be generated. Reason: Property 'target.times.log.file' not set");
        }
    }

    public void buildFinished(BuildEvent event) {
        if (this.targetTimesLogCsv != null) {
            DataOutputStream timesLogOut = null;
            try {
                File dir = new File(this.targetTimesLogCsv).getParentFile();
                dir.mkdirs();
                if (dir.exists()) {
                    FileOutputStream timesLogFileStream = new FileOutputStream(this.targetTimesLogCsv, true);
                    timesLogOut = new DataOutputStream(timesLogFileStream);
                    for (String s : this.targetTimesTable) {
                        timesLogOut.writeBytes(s + "\n");
                    }
                    timesLogOut.close();
                }
            }
            catch (Exception ex) {
                this.project.log("Exception has occurred", (Throwable)ex, 1);
                ex.printStackTrace();
            }
        }
    }

    public void targetStarted(BuildEvent event) {
        if (!this.isInitialized) {
            this.initialize(event.getProject());
        }
        this.targetStartTime = new Date();
    }

    public void targetFinished(BuildEvent event) {
        String targetName = event.getTarget().getName();
        long time = this.getTargetRunTime();
        this.targetTimesTable.add(targetName + "," + time);
    }

    private long getTargetRunTime() {
        Date targetFinishTime = new Date();
        long targetLengthMSecs = targetFinishTime.getTime() - this.targetStartTime.getTime();
        return TimeUnit.MILLISECONDS.toSeconds(targetLengthMSecs);
    }

    public void messageLogged(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }
}

