/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.taskdefs.Sleep;

public class RetryTask
extends Task
implements TaskContainer {
    private Task nestedTask;
    private int retryCount = 1;
    private int sleepTime;

    public synchronized void addTask(Task t) {
        if (this.nestedTask != null) {
            throw new BuildException("The retry task container accepts a single nested task (which may be a sequential task container)");
        }
        this.nestedTask = t;
    }

    public void setRetryCount(int n) {
        this.retryCount = n;
    }

    public void setSleepTime(int n) {
        this.sleepTime = n;
    }

    public void execute() {
        if (this.nestedTask == null) {
            throw new BuildException("The nested retry task not defined");
        }
        StringBuffer errorMessages = new StringBuffer();
        String br = this.getProject().getProperty("line.separator");
        for (int i = 0; i <= this.retryCount; ++i) {
            try {
                this.nestedTask.perform();
                break;
            }
            catch (Exception e) {
                errorMessages.append(e.getMessage());
                if (i >= this.retryCount) {
                    StringBuffer exceptionMessage = new StringBuffer();
                    exceptionMessage.append("Task [").append(this.nestedTask.getTaskName());
                    exceptionMessage.append("] failed after [").append(this.retryCount);
                    exceptionMessage.append("] attempts; giving up.").append(br);
                    exceptionMessage.append("Error messages:").append(br);
                    exceptionMessage.append(errorMessages);
                    throw new BuildException(exceptionMessage.toString(), this.getLocation());
                }
                this.log("Attempt [" + i + "]:  error occurred; retrying...", e, 2);
                errorMessages.append(br);
                if (this.sleepTime <= 0) continue;
                Sleep sleepTimer = new Sleep();
                sleepTimer.setMilliseconds(this.sleepTime);
                sleepTimer.execute();
                continue;
            }
        }
    }
}

