/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class SearchEngine {
    private IvySettings settings;

    public SearchEngine(IvySettings settings) {
        this.settings = settings;
    }

    public String[] listTokenValues(String token, Map otherTokenValues) {
        LinkedHashSet<String> r = new LinkedHashSet<String>();
        Iterator iter = this.settings.getResolvers().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            r.addAll(Arrays.asList(resolver.listTokenValues(token, otherTokenValues)));
        }
        return r.toArray(new String[r.size()]);
    }

    public OrganisationEntry[] listOrganisationEntries() {
        ArrayList<OrganisationEntry> entries = new ArrayList<OrganisationEntry>();
        Iterator iter = this.settings.getResolvers().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            entries.addAll(Arrays.asList(resolver.listOrganisations()));
        }
        return entries.toArray(new OrganisationEntry[entries.size()]);
    }

    public String[] listOrganisations() {
        HashSet<String> orgs = new HashSet<String>();
        Iterator iter = this.settings.getResolvers().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            OrganisationEntry[] entries = resolver.listOrganisations();
            if (entries == null) continue;
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] == null) continue;
                orgs.add(entries[i].getOrganisation());
            }
        }
        return orgs.toArray(new String[orgs.size()]);
    }

    public ModuleEntry[] listModuleEntries(OrganisationEntry org) {
        ArrayList<ModuleEntry> entries = new ArrayList<ModuleEntry>();
        Iterator iter = this.settings.getResolvers().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            entries.addAll(Arrays.asList(resolver.listModules(org)));
        }
        return entries.toArray(new ModuleEntry[entries.size()]);
    }

    public String[] listModules(String org) {
        ArrayList<String> mods = new ArrayList<String>();
        Iterator iter = this.settings.getResolvers().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            ModuleEntry[] entries = resolver.listModules(new OrganisationEntry(resolver, org));
            if (entries == null) continue;
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] == null) continue;
                mods.add(entries[i].getModule());
            }
        }
        return mods.toArray(new String[mods.size()]);
    }

    public RevisionEntry[] listRevisionEntries(ModuleEntry module) {
        ArrayList<RevisionEntry> entries = new ArrayList<RevisionEntry>();
        Iterator iter = this.settings.getResolvers().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            entries.addAll(Arrays.asList(resolver.listRevisions(module)));
        }
        return entries.toArray(new RevisionEntry[entries.size()]);
    }

    public String[] listRevisions(String org, String module) {
        ArrayList<String> revs = new ArrayList<String>();
        Iterator iter = this.settings.getResolvers().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            RevisionEntry[] entries = resolver.listRevisions(new ModuleEntry(new OrganisationEntry(resolver, org), module));
            if (entries == null) continue;
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] == null) continue;
                revs.add(entries[i].getRevision());
            }
        }
        return revs.toArray(new String[revs.size()]);
    }

    public ModuleId[] listModules(ModuleId criteria, PatternMatcher matcher) {
        ArrayList<ModuleId> ret = new ArrayList<ModuleId>();
        Matcher orgMatcher = matcher.getMatcher(criteria.getOrganisation());
        Matcher modMatcher = matcher.getMatcher(criteria.getName());
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        String[] orgs = this.listTokenValues("organisation", tokenValues);
        for (int i = 0; i < orgs.length; ++i) {
            if (!orgMatcher.matches(orgs[i])) continue;
            tokenValues.put("organisation", orgs[i]);
            String[] mods = this.listTokenValues("module", tokenValues);
            for (int j = 0; j < mods.length; ++j) {
                if (!modMatcher.matches(mods[j])) continue;
                ret.add(new ModuleId(orgs[i], mods[j]));
            }
        }
        return ret.toArray(new ModuleId[ret.size()]);
    }

    public ModuleRevisionId[] listModules(ModuleRevisionId criteria, PatternMatcher matcher) {
        ArrayList<ModuleRevisionId> ret = new ArrayList<ModuleRevisionId>();
        Matcher orgMatcher = matcher.getMatcher(criteria.getOrganisation());
        Matcher modMatcher = matcher.getMatcher(criteria.getName());
        Matcher branchMatcher = matcher.getMatcher(criteria.getBranch());
        Matcher revMatcher = matcher.getMatcher(criteria.getRevision());
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        String[] orgs = this.listTokenValues("organisation", tokenValues);
        for (int i = 0; i < orgs.length; ++i) {
            if (!orgMatcher.matches(orgs[i])) continue;
            tokenValues.put("organisation", orgs[i]);
            String[] mods = this.listTokenValues("module", tokenValues);
            for (int j = 0; j < mods.length; ++j) {
                if (!modMatcher.matches(mods[j])) continue;
                tokenValues.put("module", mods[j]);
                String[] branches = this.listTokenValues("branch", tokenValues);
                if (branches == null || branches.length == 0) {
                    branches = new String[]{this.settings.getDefaultBranch(new ModuleId(orgs[i], mods[j]))};
                }
                for (int k = 0; k < branches.length; ++k) {
                    if (branches[k] != null && !branchMatcher.matches(branches[k])) continue;
                    tokenValues.put("branch", tokenValues);
                    String[] revs = this.listTokenValues("revision", tokenValues);
                    for (int l = 0; l < revs.length; ++l) {
                        if (!revMatcher.matches(revs[l])) continue;
                        ret.add(ModuleRevisionId.newInstance(orgs[i], mods[j], branches[k], revs[l]));
                    }
                    tokenValues.remove("revision");
                }
                tokenValues.remove("branch");
            }
            tokenValues.remove("module");
        }
        return ret.toArray(new ModuleRevisionId[ret.size()]);
    }

    public Collection findModuleRevisionIds(DependencyResolver resolver, ModuleRevisionId pattern, PatternMatcher matcher) {
        ArrayList<ModuleRevisionId> mrids = new ArrayList<ModuleRevisionId>();
        String resolverName = resolver.getName();
        Message.verbose("looking for modules matching " + pattern + " using " + matcher.getName());
        Namespace fromNamespace = null;
        if (resolver instanceof AbstractResolver) {
            fromNamespace = ((AbstractResolver)resolver).getNamespace();
        }
        ArrayList<ModuleEntry> modules = new ArrayList<ModuleEntry>();
        OrganisationEntry[] orgs = resolver.listOrganisations();
        if (orgs == null || orgs.length == 0) {
            String org = pattern.getOrganisation();
            if (fromNamespace != null) {
                org = NameSpaceHelper.transform(pattern.getModuleId(), fromNamespace.getFromSystemTransformer()).getOrganisation();
            }
            modules.addAll(Arrays.asList(resolver.listModules(new OrganisationEntry(resolver, org))));
        } else {
            Matcher orgMatcher = matcher.getMatcher(pattern.getOrganisation());
            for (int i = 0; i < orgs.length; ++i) {
                String org;
                String systemOrg = org = orgs[i].getOrganisation();
                if (fromNamespace != null) {
                    systemOrg = NameSpaceHelper.transformOrganisation(org, fromNamespace.getToSystemTransformer());
                }
                if (!orgMatcher.matches(systemOrg)) continue;
                modules.addAll(Arrays.asList(resolver.listModules(new OrganisationEntry(resolver, org))));
            }
        }
        Message.debug("found " + modules.size() + " modules for " + pattern.getOrganisation() + " on " + resolverName);
        boolean foundModule = false;
        Iterator iter = modules.iterator();
        while (iter.hasNext()) {
            ModuleId foundMid;
            ModuleEntry mEntry = (ModuleEntry)iter.next();
            ModuleId systemMid = foundMid = new ModuleId(mEntry.getOrganisation(), mEntry.getModule());
            if (fromNamespace != null) {
                systemMid = NameSpaceHelper.transform(foundMid, fromNamespace.getToSystemTransformer());
            }
            if (!MatcherHelper.matches(matcher, pattern.getModuleId(), systemMid)) continue;
            foundModule = true;
            RevisionEntry[] rEntries = resolver.listRevisions(mEntry);
            Message.debug("found " + rEntries.length + " revisions for [" + mEntry.getOrganisation() + ", " + mEntry.getModule() + "] on " + resolverName);
            boolean foundRevision = false;
            for (int j = 0; j < rEntries.length; ++j) {
                ModuleRevisionId foundMrid;
                RevisionEntry rEntry = rEntries[j];
                ModuleRevisionId systemMrid = foundMrid = ModuleRevisionId.newInstance(mEntry.getOrganisation(), mEntry.getModule(), rEntry.getRevision());
                if (fromNamespace != null) {
                    systemMrid = fromNamespace.getToSystemTransformer().transform(foundMrid);
                }
                if (!MatcherHelper.matches(matcher, pattern, systemMrid)) continue;
                foundRevision = true;
                mrids.add(systemMrid);
            }
            if (foundRevision) continue;
            Message.debug("no revision found matching " + pattern + " in [" + mEntry.getOrganisation() + "," + mEntry.getModule() + "] using " + resolverName);
        }
        if (!foundModule) {
            Message.debug("no module found matching " + pattern + " using " + resolverName);
        }
        return mrids;
    }
}

