/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.extendable;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.util.extendable.DefaultExtendableItem;
import org.xml.sax.Attributes;

public final class ExtendableItemHelper {
    private ExtendableItemHelper() {
    }

    public static Map getExtraAttributes(Attributes attributes, String prefix) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).startsWith(prefix)) continue;
            ret.put(attributes.getQName(i).substring(prefix.length()), attributes.getValue(i));
        }
        return ret;
    }

    public static Map getExtraAttributes(Attributes attributes, String[] ignoredAttNames) {
        HashMap<String, String> ret = new HashMap<String, String>();
        List<String> ignored = Arrays.asList(ignoredAttNames);
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (ignored.contains(attributes.getQName(i))) continue;
            ret.put(attributes.getQName(i), attributes.getValue(i));
        }
        return ret;
    }

    public static void fillExtraAttributes(DefaultExtendableItem item, Attributes attributes, String[] ignoredAttNames) {
        Map att = ExtendableItemHelper.getExtraAttributes(attributes, ignoredAttNames);
        Iterator iter = att.keySet().iterator();
        while (iter.hasNext()) {
            String attName = (String)iter.next();
            String attValue = (String)att.get(attName);
            item.setExtraAttribute(attName, attValue);
        }
    }
}

