/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ivy.util.filter.ArtifactTypeFilter;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;

public final class FilterHelper {
    public static final Filter NO_FILTER = NoFilter.INSTANCE;

    private FilterHelper() {
    }

    public static Filter getArtifactTypeFilter(String types) {
        if (types == null || types.trim().equals("*")) {
            return NO_FILTER;
        }
        String[] t = types.split(",");
        ArrayList<String> acceptedTypes = new ArrayList<String>(t.length);
        for (int i = 0; i < t.length; ++i) {
            acceptedTypes.add(t[i].trim());
        }
        return new ArtifactTypeFilter(acceptedTypes);
    }

    public static Collection filter(Collection col, Filter filter) {
        if (filter == null) {
            return col;
        }
        ArrayList ret = new ArrayList(col);
        Iterator iter = ret.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (filter.accept(element)) continue;
            iter.remove();
        }
        return ret;
    }
}

