/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.maven.scm.provider.hg;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmVersion;

public class VersionChangeSet
extends ChangeSet {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private List<ScmVersion> scmVersionList = new ArrayList<ScmVersion>();

    public void setScmVersion(ScmVersion scmVersion) throws ScmException {
        this.scmVersionList.add(scmVersion);
    }

    public List<ScmVersion> getScmVersion() {
        return this.scmVersionList;
    }

    public String toString() {
        List files;
        String result = "";
        for (ScmVersion versions : this.getScmVersion()) {
            if (versions.getName().equals("")) continue;
            result = result + versions.getType().toLowerCase() + ":" + versions.getName() + "\n";
        }
        if (this.getAuthor() != null) {
            result = result + "user:" + this.getAuthor() + "\n";
        }
        if (this.getDate() != null) {
            result = result + "date:" + this.getDate() + "\n";
        }
        if ((files = this.getFiles()).size() != 0) {
            result = result + "files:";
            for (ChangeFile changeFile : files) {
                result = result + changeFile.getName() + " ";
            }
        }
        if (!this.getComment().equals("")) {
            result = result + "\ndescription:" + this.getComment() + "\n";
        }
        return result;
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t<changelog-entry>\n");
        if (this.getDate() != null) {
            buffer.append("\t\t<date pattern=\"" + this.getDateFormatted() + "\">").append(this.getDateFormatted()).append("</date>\n").append("\t\t<time pattern=\"HH:mm:ss\">").append(this.getTimeFormatted()).append("</time>\n");
        }
        for (ScmVersion versions : this.getScmVersion()) {
            if (versions.getName().equals("")) continue;
            buffer.append("\t\t<" + versions.getType().toLowerCase() + ">\n").append("\t\t\t<name>").append(versions.getName()).append("</name>\n");
            buffer.append("\t\t</" + versions.getType().toLowerCase() + ">\n");
        }
        buffer.append("\t\t<author><![CDATA[").append(this.getAuthor()).append("]]></author>\n");
        List changeFiles = this.getFiles();
        for (ChangeFile changeFile : changeFiles) {
            buffer.append("\t\t<file>\n").append("\t\t\t<name>").append(VersionChangeSet.escapeValue((Object)changeFile.getName())).append("</name>\n").append("\t\t\t<revision>").append(changeFile.getRevision()).append("</revision>\n");
            buffer.append("\t\t</file>\n");
        }
        buffer.append("\t\t<msg><![CDATA[").append(this.removeCDataEnd(this.getComment())).append("]]></msg>\n");
        buffer.append("\t</changelog-entry>\n");
        return buffer.toString();
    }

    private String removeCDataEnd(String message) {
        while (message != null && message.indexOf("]]>") > -1) {
            int endCdata = message.indexOf("]]>");
            message = message.substring(0, endCdata) + "] ] >" + message.substring(endCdata + 3, message.length());
        }
        return message;
    }
}

