/*--

 Copyright 2001, 2002 Elliotte Rusty Harold.
 All rights reserved.

    This file is part of XIncluder, a Java class library for integrating XInclude
    processing with SAX, DOM, and JDOM. 

    XIncluder is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License version 2.1 
    as published by the Free Software Foundation.

    XIncluder is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with XIncluder; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED.  IN NO EVENT SHALL ELLIOTTE RUSTY HAROLD OR ANY
 OTHER CONTRIBUTORS TO THIS PACKAGE
 BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 */

package com.elharo.xml.xinclude;

/**
 * <p>
 * <code>XIncludeException</code> is the generic superclass
 * for all checked exceptions that may be thrown as a result
 * of a violation of XInclude's rules.
 * </p>
 *
 * @author Elliotte Rusty Harold
 * @version 1.0d9, July 4, 2002
 */
public class XIncludeException extends Exception {

    private Throwable rootCause = null;

    /**
     * Constructs an <code>XIncludeException</code> with <code>null</code>
     * as its error detail message.
     */
    public XIncludeException() {}

    /**
     * Constructs an <code>XIncludeException</code> with the specified detail
     * message. The error message string <code>message</code> can later be
     * retrieved by the <code>{@link java.lang.Throwable#getMessage}</code>
     * method of class <code>java.lang.Throwable</code>.
     *
     * @param   message   the detail message.
     */
    public XIncludeException(String message) {
        super(message);
    }

    /**
     * When an <code>IOException</code>, <code>MalformedURLException</code> 
     * or other generic exception is thrown while processing an XML document
     * for XIncludes, it is customarily replaced
     * by some form of <code>XIncludeException</code>.  
     * This method allows you to store the original exception.
     *
     * @param   nestedException   the underlying exception which 
                                  caused the XIncludeException to be thrown
     */
    public void setRootCause(Throwable nestedException) {
        this.rootCause = nestedException;     
    }

    /**
     * When an <code>IOException</code>, <code>MalformedURLException</code> 
     * or other generic exception is thrown while processing an XML document
     * for XIncludes, it is customarily replaced
     * by some form of <code>XIncludeException</code>.  
     * This method allows you to retrieve the original exception.
     * It returns null if no such exception caused this <code>XIncludeException</code>.
     *
     * @return   Throwable   the underlying exception which 
                             caused the XIncludeException to be thrown
     */
    public Throwable getRootCause() {
        return this.rootCause;     
    }

}