/* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description:
 *
 */

#ifndef VERTEX_H_
#define VERTEX_H_

#include "hgl.h"

struct DGLBuffer;

// GLES Vertex array data holder.
typedef struct DGLVertexArray
{
	GLint size;					// Function call argument.
	GLenum type;				// --''--
	GLboolean normalized;		// --''--
	GLsizei stride;				// --''--
	const void* ptr;			// --''--
	
	GLboolean enabled;			// State.
	GLfloat* floatptr;			// Buffer for fixed->float conversion.
	struct DGLBuffer* buffer;	// Buffer binding.
} DGLVertexArray;

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern void dglVertexFinish();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // VERTEX_H_

