# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and /or associated documentation files
# (the "Materials "), to deal in the Materials without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Materials,
# and to permit persons to whom the Materials are furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Materials.
#
# THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
# DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
# OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE MATERIALS OR
# THE USE OR OTHER DEALINGS IN THE MATERIALS.

def get_include_guard_name(filename):
    return "__" + filename.upper().replace('.', '_')

def begin_include_guard(defstring):
    print "#ifndef " + defstring
    print "#define " + defstring

def end_include_guard():
    print "#endif\n"

def make_constant(c, v):
    print "enum { " + str(c) + " = " + str(v) + "};"
    
def make_include(fname):
    print "#include \"" + str(fname) + "\""

def make_generation_notice():
    print "// This file is automatically generated. Please do not edit."

def begin_namespace(name):
    print "namespace " + str(name) + " {"

def end_namespace():
    print "}"

def hex_formatter(i):
    return hex(i)

def empty_format(i):
    return str(i)

def make_array(qualifiers, type, name, data, ffn = empty_format, items_per_line = 8):
    
    print qualifiers,
    print type,
    print name + '[' + str(len(data)) + '] = {'
    formatted_items = map(ffn, data)
    s = 0
    for i in formatted_items:
        t = ""
        if s == 0:
            t = "    "
        print t + i + ", ",
        s += 1
        if s == items_per_line:
            print ""
            s = 0
    print "};"
    return len(formatted_items)


