/*
 * GUI target side interface
 *
 * Copyright (c) 2009 CodeSourcery
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef GUI_H
#define GUI_H

#include "display_state.h"

/* keyboard/mouse support */

#define MOUSE_EVENT_LBUTTON 0x01
#define MOUSE_EVENT_RBUTTON 0x02
#define MOUSE_EVENT_MBUTTON 0x04

typedef void (*KeyCallback)(void *opaque, int key);
typedef void (*vga_hw_update_ptr)(void *);
typedef void (*vga_hw_invalidate_ptr)(void *);
typedef void (*vga_hw_screen_dump_ptr)(void *, const char *);
typedef void QEMUPutMouseEvent(void *opaque, int dx, int dy, int dz, int buttons_state);

struct QEMUPutMouseEntry;
typedef struct QEMUPutMouseEntry QEMUPutMouseEntry;

QEMUPutMouseEntry *qemu_add_mouse_event_handler(QEMUPutMouseEvent *func,
                                                void *opaque, int absolute,
                                                const char *name);
void qemu_remove_mouse_event_handler(QEMUPutMouseEntry *entry);

struct mouse_transform_info_s {
    /* Touchscreen resolution */
    int x;
    int y;
    /* Calibration values as used/generated by tslib */
    int a[7];
};

DisplayState *gui_get_graphic_console(const char *devname,
                                      vga_hw_update_ptr update,
                                      vga_hw_invalidate_ptr invalidate,
                                      vga_hw_screen_dump_ptr screen_dump,
                                      void *opaque);

void gui_register_dev_key_callback(KeyCallback cb, void *opaque);
void gui_register_vt_key_callback(DisplayState *ds, KeyCallback cb, void *opaque);

int gui_register_mouse_event_handler(QEMUPutMouseEvent *func,
                                     void *opaque, int absolute,
                                     const char *devname);

/* only for skinless vts. 1 OK, 0 error (i.e. skinned vt) */
int gui_resize_vt(DisplayState *ds, int width, int height);

void dpy_update(DisplayState *s, int x, int y, int w, int h);
void dpy_cursor(DisplayState *s, int x, int y);

#endif

