/*
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description:
 *
 */

#ifndef NMAPIFOLDERLISTING_H_
#define NMAPIFOLDERLISTING_H_

#include <QObject>

#include "nmapimessagetask.h"
#include "nmapimailbox.h"
#include "nmenginedef.h"
#include "nmapifolder.h"

class NmEngine;

namespace EmailClientApi
{

class NmFolderListingPrivate;

/*!
 * \class Class for creating list of all folders
 */
class NMENGINE_EXPORT NmFolderListing : public NmMessageTask
{
    Q_OBJECT
public:
    /*!
     * Constructor of class. It set start values.
     */
    NmFolderListing( QObject *parent, const quint64 &nmMailboxId );
    /*!
     * Destructor of class. It release engine to be safe if manual releasing won't work.
     */
    ~NmFolderListing();

    enum {FolderListingFailed = -1};

    /*! 
     * \brief Returns results after foldersListed signal is received.
     * 
     *  Caller gets ownership of messages. Returns true if results were available.
     *  It clears list of folders after be called.
     *  It also at start clear inputlist of NmFolder.
     */
    bool getFolders(QList<EmailClientApi::NmFolder> &folders);

    /*!
     * \brief Return info if listing is running
     */
    bool isRunning() const;

    signals:
    /*!
     * emitted when listing is available, count is number of folders found
     * or FolderListingFailed if listing failed
     */
    void foldersListed(qint32 count);

public slots:
    /*!
     * \brief Starts gathering folders list.
     * 
     * In first turn it will get whole folderlist. 
     * \todo After that it will wait for folder events.
     * If start works, it do nothing.
     * 
     * To asynchronous operation ce be used \sa QTimer::singleShot on this method.
     * Example:
     * <code> 
     * QTimer::singleShot(0,nmFolderListing,SLOT(start());
     * </code>
     * 
     */
    virtual bool start();

    /*!
     * \brief Stop gathering folder list.
     * 
     * In first it change state of listing.
     * Then it release engine.
     * On end it clears list of folders and emits \sa NmMessageTask::canceled() signal.
     */
    virtual void cancel();

private:
    NmFolderListingPrivate* mFolderListing;
};
}

#endif /* NMFOLDERLISTING_H_ */
