/*
* Copyright (c) 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  PCS Session class
*
*/

#ifndef PCS_SESSION_H
#define PCS_SESSION_H

// INCLUDE FILES
#include <e32base.h>
#include "CPsSettings.h"

// FORWARD DECLARATIONS
class CPcsServer;
class CPsQuery;

/**
 * Represents a session (version 2) for a client thread on 
 * the server side
 */
class CPcsSession : public CSession2
{
    public:
    
        /**
         * Two phase construction
         */
		static CPcsSession* NewL(CPcsServer* aServer);
		
		/**
		 * Handles the servicing of client requests
		 * Implements CSession2 ServiceL
		 */
		void ServiceL(const RMessage2& aMessage);
		
		/**
		 * Handles the leaves generated by ServiceL function
		 * Implements CSession2 ServiceError
		 */
		void ServiceError(const RMessage2& aMessage, TInt aError);

    private:
    
        /**
         * Second phase constructor
         */
		void ConstructL();
		
		/**
		 * Constructor
		 */
		CPcsSession(CPcsServer* aServer);
		
		/** Destructor
		 *
		 */
		~CPcsSession();
		
		/**
		 * Serve the client requests
		 */
		void DoServiceL(const RMessage2& aMessage);
	
	    /** 
		 * Service method to handle search settings
		 */
		void SetSearchSettingsL(const RMessage2& aMessage);	
				
		/** 
		 * Service method to perform predictive contact search
		 */
		void GetAsyncPcsResultsL(const RMessage2& aMessage);
		
	    /** 
		 * Service method to perform predictive search on input data
		 */
		void SearchInputL(const RMessage2& aMessage);

        /** 
         * Service method to perform predictive search on input data
         * with string as result
         */
        void SearchMatchStringL(const RMessage2& aMessage);		
		
		/**
		 * Service method to check if the laguage is supported or not
		 */
		void IsLanguageSupportedL(const RMessage2& aMessage);
				
	    /**
		 * Service method to get supported data fields
		 */
		void GetDataOrderL(const RMessage2& aMessage);
							
	    /**
		 * Service method to get sort order of data fields
		 */
		void GetSortOrderL(const RMessage2& aMessage);	
		
		/**
		 * Service method to get sort order of data fields
		 */
		void ChangeSortOrderL(const RMessage2& aMessage);		
		
		
		/**
		 * Service method to shutdown the server
		 */
		void ShutdownServerL(const RMessage2& aMessage);

		/**
		 * Utility function for reading search query from message
		 */
		static CPsQuery* ReadQueryLC( TInt aParam, const RMessage2& aMessage );
		
    private:
    
        /**
         * Reference to server (not owned)
         */
		CPcsServer*             iServer;
		
		/**
		 * Indicates if a buffer overflow has occurred (owned)
		 */
		TBool				    iBufferOverFlow;
		
		/**
		 * Used to cache the results in case of overflow (owned)
		 */
		HBufC8*                 iDes;
		
		/**
		* Search settings for the session
		*/
		CPsSettings*            iSettings;
		
		/**
		* Hold a copy of search message
		*/
		RMessagePtr2            iMessage;					   		
};

#endif // End of file
