/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/



#include <QObject>


class CntMainWindow;
class CntViewManager;

#include "cntbaseselectionview.h"
#include "cntviewparameters.h"

class CntBaseSelectionTestView : public CntBaseSelectionView
{
    Q_OBJECT

public:
    CntBaseSelectionTestView(CntViewManager *viewManager, QGraphicsItem *parent = 0, 
            HbAbstractItemView::SelectionMode newMode = HbAbstractItemView::MultiSelection):
        CntBaseSelectionView(viewManager, parent, newMode) { }

    CntViewParameters::ViewId viewId() const { return CntViewParameters::noView; }

};

class TestCntBaseSelectionView : public QObject
{
     Q_OBJECT

private slots:

    void initTestCase();
    void createClasses();

    void setupView();

    void addItemsToLayout();
    void listView();
    void activateView();
    void listLayout();
    void selectionModel();

    void cleanupTestCase();

private:

    CntMainWindow            *mWindow;
    CntViewManager           *mViewManager;
    CntBaseSelectionTestView *mSelectionView;

 };
