/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.odtconverter;

import java.util.Hashtable;

public class MimeTypeResolver {
    private static Hashtable iResourceTypeAndMimeType;
    public static final int E_RESOURCE_NONE = 0;
    public static final int E_RESOURCERLB = 1;
    public static final int E_RESOURCEODT = 2;
    public static final int E_RESOURCEDTD = 3;
    public static final int E_RESOURCEXML = 4;
    public static final int E_RESOURCECSS = 5;
    public static final int E_RESOURCEDAT = 6;
    public static final int E_RESOURCERES = 7;
    public static final int E_RESOURCEFBS = 8;
    public static final int E_RESOURCEMBM = 9;
    public static final int E_RESOURCEMIF = 10;
    public static final int E_RESOURCEBMP = 11;
    public static final int E_RESOURCEJPG = 12;
    public static final int E_RESOURCEJPEG = 13;
    public static final int E_RESOURCEPNG = 14;
    public static final int E_RESOURCEGIF = 15;
    public static final int E_RESOURCEAAC = 16;
    public static final int E_RESOURCEWAV = 17;
    public static final int E_RESOURCEMID = 18;
    public static final int E_RESOURCEMP3 = 19;
    public static final int E_RESOURCEM3G = 20;
    public static final int E_RESOURCESVG = 21;
    public static final int E_RESOURCESWF = 22;
    public static final int E_RESOURCEMIME = 23;
    public static final int E_RESOURCETXT = 24;
    public static final String KRLB_FILE_EXTENSION = ".r";
    public static final String KODT_FILE_EXTENSION = ".o";
    public static final String KDTD_FILE_EXTENSION = ".dtd";
    public static final String KXML_FILE_EXTENSION = ".xml";
    public static final String KCSS_FILE_EXTENSION = ".css";
    public static final String KDAT_FILE_EXTENSION = ".dat";
    public static final String KFBS_FILE_EXTENSION = ".fbs";
    public static final String KMBM_FILE_EXTENSION = ".mbm";
    public static final String KMIF_FILE_EXTENSION = ".mif";
    public static final String KBMP_FILE_EXTENSION = ".bmp";
    public static final String KJPG_FILE_EXTENSION = ".jpg";
    public static final String KJPEG_FILE_EXTENSION = ".jpeg";
    public static final String KPNG_FILE_EXTENSION = ".png";
    public static final String KGIF_FILE_EXTENSION = ".gif";
    public static final String KAAC_FILE_EXTENSION = ".aac";
    public static final String KWAV_FILE_EXTENSION = ".wav";
    public static final String KMID_FILE_EXTENSION = ".mid";
    public static final String KMP3_FILE_EXTENSION = ".mp3";
    public static final String KM3G_FILE_EXTENSION = ".m3g";
    public static final String KSVG_FILE_EXTENSION = ".svg";
    public static final String KSWF_FILE_EXTENSION = ".swf";
    public static final String KTXT_FILE_EXTENSION = ".txt";
    public static final String KAPAAPPTYPEDES = "x-epoc/x-app";
    public static final String TXT_MIME_TYPE = "text/xml";
    public static final String MBM_MIME_TYPE = "image/x-epoc-mbm";
    public static final String EMPTY_MIME_TYPE = "";
    public static final String EMPTY_FILE_EXTENSION = "";
    public static final String WAV_MIME_TYPE = "audio/x-wav";
    public static final String MIDI_MIME_TYPE = "audio/midi";
    public static final String UNKNOWN_MIME_TYPE = "unknown";
    public static final String NAME_EXTENSION_SEPARATOR = ".";

    public MimeTypeResolver() {
        iResourceTypeAndMimeType = new Hashtable();
        iResourceTypeAndMimeType.put(KRLB_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 1));
        iResourceTypeAndMimeType.put(KODT_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 2));
        iResourceTypeAndMimeType.put(KDTD_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 3));
        iResourceTypeAndMimeType.put(KXML_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 4));
        iResourceTypeAndMimeType.put(KCSS_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 5));
        iResourceTypeAndMimeType.put(KDAT_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 6));
        iResourceTypeAndMimeType.put(KFBS_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 8));
        iResourceTypeAndMimeType.put(KMBM_FILE_EXTENSION, new ResourceTypeAndMimeType(MBM_MIME_TYPE, 9));
        iResourceTypeAndMimeType.put(KMIF_FILE_EXTENSION, new ResourceTypeAndMimeType("", 10));
        iResourceTypeAndMimeType.put(KBMP_FILE_EXTENSION, new ResourceTypeAndMimeType("", 11));
        iResourceTypeAndMimeType.put(KJPG_FILE_EXTENSION, new ResourceTypeAndMimeType("", 12));
        iResourceTypeAndMimeType.put(KJPEG_FILE_EXTENSION, new ResourceTypeAndMimeType("", 13));
        iResourceTypeAndMimeType.put(KPNG_FILE_EXTENSION, new ResourceTypeAndMimeType("", 14));
        iResourceTypeAndMimeType.put(KGIF_FILE_EXTENSION, new ResourceTypeAndMimeType("", 15));
        iResourceTypeAndMimeType.put(KAAC_FILE_EXTENSION, new ResourceTypeAndMimeType("", 16));
        iResourceTypeAndMimeType.put(KWAV_FILE_EXTENSION, new ResourceTypeAndMimeType(WAV_MIME_TYPE, 17));
        iResourceTypeAndMimeType.put(KMID_FILE_EXTENSION, new ResourceTypeAndMimeType(MIDI_MIME_TYPE, 18));
        iResourceTypeAndMimeType.put(KMP3_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 19));
        iResourceTypeAndMimeType.put(KM3G_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 20));
        iResourceTypeAndMimeType.put(KSVG_FILE_EXTENSION, new ResourceTypeAndMimeType(UNKNOWN_MIME_TYPE, 21));
        iResourceTypeAndMimeType.put(KSWF_FILE_EXTENSION, new ResourceTypeAndMimeType("", 22));
        iResourceTypeAndMimeType.put(KTXT_FILE_EXTENSION, new ResourceTypeAndMimeType("", 24));
    }

    public String getMimeType(String aFileName) {
        return this.getMimeTypeValue(this.getFileExtension(aFileName));
    }

    public int getResourceType(String aFileName) {
        return this.getResourceTypeValue(this.getFileExtension(aFileName));
    }

    private String getMimeTypeValue(String aKey) {
        if (iResourceTypeAndMimeType.containsKey(aKey)) {
            ResourceTypeAndMimeType rtamt = (ResourceTypeAndMimeType)iResourceTypeAndMimeType.get(aKey);
            return rtamt.getMimeType();
        }
        return "";
    }

    private int getResourceTypeValue(String aKey) {
        if (iResourceTypeAndMimeType.containsKey(aKey)) {
            ResourceTypeAndMimeType rtamt = (ResourceTypeAndMimeType)iResourceTypeAndMimeType.get(aKey);
            return rtamt.getResourceType();
        }
        return 0;
    }

    private String getFileExtension(String aFileName) {
        String fileExtension = "";
        if (aFileName.contains(NAME_EXTENSION_SEPARATOR)) {
            fileExtension = aFileName.substring(aFileName.lastIndexOf(NAME_EXTENSION_SEPARATOR), aFileName.length()).toLowerCase();
            return fileExtension;
        }
        return "";
    }

    private static class ResourceTypeAndMimeType {
        private String iMimeType;
        private int iResourceType;

        public ResourceTypeAndMimeType(String aMimeType, int aResourceType) {
            this.iMimeType = aMimeType;
            this.iResourceType = aResourceType;
        }

        public String getMimeType() {
            return this.iMimeType;
        }

        public int getResourceType() {
            return this.iResourceType;
        }
    }
}

