/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.installationmanager;

import java.io.File;

public class InstallationParameters {
    private File iManifest;
    private File iDestinationDir;
    private File iLocSettings;
    private File iPropFile;

    public InstallationParameters(File aManifest, File aDestinationDir) {
        this.iManifest = aManifest;
        this.iDestinationDir = aDestinationDir;
        if (!aManifest.exists()) {
            throw new IllegalArgumentException("Manifest file not found: " + aManifest.getPath());
        }
        if (aDestinationDir.isFile()) {
            throw new IllegalArgumentException("Invalid destination directory: " + aDestinationDir.getPath());
        }
    }

    public File getManifest() {
        return this.iManifest;
    }

    public File getDestinationDir() {
        return this.iDestinationDir;
    }

    public File getLocSettings() {
        return this.iLocSettings;
    }

    public File getPropFile() {
        return this.iPropFile;
    }

    public void setLocSettings(File aLocSettings) {
        this.iLocSettings = aLocSettings;
        if (!(aLocSettings == null || aLocSettings.exists() && aLocSettings.isFile())) {
            throw new IllegalArgumentException("Localisation settings file not found: " + aLocSettings.getPath());
        }
    }

    public void setPropFile(File aPropFile) {
        this.iPropFile = aPropFile;
        if (!(aPropFile == null || aPropFile.exists() && aPropFile.isFile())) {
            throw new IllegalArgumentException("Properties file not found: " + aPropFile.getPath());
        }
    }
}

