/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.xmlparser;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import org.xml.sax.InputSource;

public class DTDInputSource
extends InputSource {
    private static final int BUFFER_LENGTH = 3;
    private static final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};
    private static final byte[] BOM_UTF16_BIG = new byte[]{-2, -1};
    private static final byte[] BOM_UTF16_LIT = new byte[]{-1, -2};
    private String iFileName;

    public DTDInputSource(String aFileName) throws FileNotFoundException {
        super(new FileReader(aFileName));
        this.iFileName = aFileName;
    }

    public Reader getCharacterStream() {
        Reader reader = super.getCharacterStream();
        byte[] buffer = new byte[3];
        try {
            int i = 0;
            while (i < buffer.length) {
                buffer[i] = (byte)reader.read();
                ++i;
            }
            int skip = 0;
            if (Arrays.equals(BOM_UTF8, buffer)) {
                skip = BOM_UTF8.length;
            } else {
                byte[] compareBuffer = new byte[BOM_UTF16_BIG.length];
                System.arraycopy(buffer, 0, compareBuffer, 0, compareBuffer.length);
                if (Arrays.equals(BOM_UTF16_BIG, compareBuffer) || Arrays.equals(BOM_UTF16_LIT, compareBuffer)) {
                    skip = BOM_UTF16_BIG.length;
                }
            }
            FileReader fr = new FileReader(this.iFileName);
            fr.skip(skip);
            reader.close();
            super.setCharacterStream(fr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getCharacterStream();
    }
}

