/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.cssparser;

import java.awt.Color;
import java.util.Hashtable;

public class ColorResolver
extends Hashtable {
    private static final long serialVersionUID = 1L;
    private static final int RGB_MAX_VALUE = 255;
    private static final int PERCENTAGE_MAX_VALUE = 100;

    public ColorResolver() {
        this.put("maroon", new Color(128, 0, 0));
        this.put("red", new Color(255, 0, 0));
        this.put("orange", new Color(255, 165, 0));
        this.put("yellow", new Color(255, 255, 0));
        this.put("olive", new Color(128, 128, 0));
        this.put("purple", new Color(128, 0, 128));
        this.put("fuchsia", new Color(255, 0, 255));
        this.put("white", new Color(255, 255, 255));
        this.put("lime", new Color(0, 255, 0));
        this.put("green", new Color(0, 128, 0));
        this.put("navy", new Color(0, 0, 128));
        this.put("blue", new Color(0, 0, 255));
        this.put("aqua", new Color(0, 255, 255));
        this.put("teal", new Color(0, 128, 128));
        this.put("black", new Color(0, 0, 0));
        this.put("silver", new Color(192, 192, 192));
        this.put("gray", new Color(128, 128, 128));
        this.put("transparent", new Color(0, 0, 0, 0));
        this.put("aliceblue", new Color(240, 248, 255));
        this.put("antiquewhite", new Color(250, 235, 215));
        this.put("aquamarine", new Color(127, 255, 212));
        this.put("azure", new Color(240, 255, 255));
        this.put("beige", new Color(245, 245, 220));
        this.put("bisque", new Color(255, 228, 196));
        this.put("blanchedalmond", new Color(255, 235, 205));
        this.put("blueviolet", new Color(138, 43, 226));
        this.put("brown", new Color(165, 42, 42));
        this.put("burlywood", new Color(222, 184, 135));
        this.put("cadetblue", new Color(95, 158, 160));
        this.put("chartreuse", new Color(127, 255, 0));
        this.put("chocolate", new Color(210, 105, 30));
        this.put("coral", new Color(255, 127, 80));
        this.put("cornflowerblue", new Color(100, 149, 237));
        this.put("cornsilk", new Color(255, 248, 220));
        this.put("crimson", new Color(220, 20, 60));
        this.put("cyan", new Color(0, 255, 255));
        this.put("darkblue", new Color(0, 0, 139));
        this.put("darkcyan", new Color(0, 139, 139));
        this.put("darkgoldenrod", new Color(184, 134, 11));
        this.put("darkgray", new Color(169, 169, 169));
        this.put("darkgrey", new Color(169, 169, 169));
        this.put("darkgreen", new Color(0, 100, 0));
        this.put("darkkhaki", new Color(189, 183, 107));
        this.put("darkmagenta", new Color(139, 0, 139));
        this.put("darkolivegreen", new Color(85, 107, 47));
        this.put("darkorange", new Color(255, 140, 0));
        this.put("darkorchid", new Color(153, 50, 204));
        this.put("darkred", new Color(139, 0, 0));
        this.put("darksalmon", new Color(233, 150, 122));
        this.put("darkseagreen", new Color(143, 188, 143));
        this.put("darkslateblue", new Color(72, 61, 139));
        this.put("darkslategray", new Color(47, 79, 79));
        this.put("darkslategrey", new Color(47, 79, 79));
        this.put("darkturquoise", new Color(0, 206, 209));
        this.put("darkviolet", new Color(148, 0, 211));
        this.put("deeppink", new Color(255, 20, 147));
        this.put("deepskyblue", new Color(0, 191, 255));
        this.put("dimgray", new Color(105, 105, 105));
        this.put("dimgrey", new Color(105, 105, 105));
        this.put("dodgerblue", new Color(30, 144, 255));
        this.put("firebrick", new Color(178, 34, 34));
        this.put("floralwhite", new Color(255, 250, 240));
        this.put("forestgreen", new Color(34, 139, 34));
        this.put("fuchsia", new Color(255, 0, 255));
        this.put("gainsboro", new Color(220, 220, 220));
        this.put("ghostwhite", new Color(248, 248, 255));
        this.put("gold", new Color(255, 215, 0));
        this.put("goldenrod", new Color(218, 165, 32));
        this.put("greenyellow", new Color(173, 255, 47));
        this.put("grey", new Color(240, 255, 240));
        this.put("honeydew", new Color(240, 255, 240));
        this.put("hotpink", new Color(255, 105, 180));
        this.put("indianred", new Color(205, 92, 92));
        this.put("indigo", new Color(75, 0, 130));
        this.put("ivory", new Color(255, 255, 240));
        this.put("khaki", new Color(240, 230, 140));
        this.put("lavender", new Color(230, 230, 250));
        this.put("lavenderblush", new Color(255, 240, 245));
        this.put("lawngreen", new Color(124, 252, 0));
        this.put("lemonchiffon", new Color(255, 250, 205));
        this.put("lightblue", new Color(173, 216, 230));
        this.put("lightcoral", new Color(240, 128, 128));
        this.put("lightcyan", new Color(224, 255, 255));
        this.put("lightgoldenrodyellow", new Color(250, 250, 210));
        this.put("lightgray", new Color(211, 211, 211));
        this.put("lightgrey", new Color(211, 211, 211));
        this.put("lightgreen", new Color(144, 238, 144));
        this.put("lightpink", new Color(255, 182, 193));
        this.put("lightsalmon", new Color(255, 160, 122));
        this.put("lightseagreen", new Color(32, 178, 170));
        this.put("lightskyblue", new Color(135, 206, 250));
        this.put("lightslategray", new Color(119, 136, 153));
        this.put("lightslategrey", new Color(119, 136, 153));
        this.put("lightsteelblue", new Color(176, 196, 222));
        this.put("lightyellow", new Color(255, 255, 224));
        this.put("limegreen", new Color(50, 205, 50));
        this.put("linen", new Color(250, 240, 230));
        this.put("magenta", new Color(255, 0, 255));
        this.put("mediumaquamarine", new Color(102, 205, 170));
        this.put("mediumblue", new Color(0, 0, 205));
        this.put("mediumorchid", new Color(186, 85, 211));
        this.put("mediumpurple", new Color(147, 112, 219));
        this.put("mediumseagreen", new Color(60, 179, 113));
        this.put("mediumslateblue", new Color(123, 104, 238));
        this.put("mediumspringgreen", new Color(0, 250, 154));
        this.put("mediumturquoise", new Color(72, 209, 204));
        this.put("mediumvioletred", new Color(199, 21, 133));
        this.put("midnightblue", new Color(25, 25, 112));
        this.put("mintcream", new Color(245, 255, 250));
        this.put("mistyrose", new Color(255, 228, 225));
        this.put("moccasin", new Color(255, 228, 181));
        this.put("navajowhite", new Color(255, 222, 173));
        this.put("oldlace", new Color(253, 245, 230));
        this.put("olivedrab", new Color(107, 142, 35));
        this.put("orangered", new Color(255, 69, 0));
        this.put("orchid", new Color(218, 112, 214));
        this.put("palegoldenrod", new Color(238, 232, 170));
        this.put("palegreen", new Color(152, 251, 152));
        this.put("paleturquoise", new Color(175, 238, 238));
        this.put("palevioletred", new Color(219, 112, 147));
        this.put("papayawhip", new Color(255, 239, 213));
        this.put("peachpuff", new Color(255, 218, 185));
        this.put("peru", new Color(205, 133, 63));
        this.put("pink", new Color(255, 192, 203));
        this.put("plum", new Color(221, 160, 221));
        this.put("powderblue", new Color(176, 224, 230));
        this.put("rosybrown", new Color(188, 143, 143));
        this.put("royalblue", new Color(65, 105, 225));
        this.put("saddlebrown", new Color(139, 69, 19));
        this.put("salmon", new Color(250, 128, 114));
        this.put("sandybrown", new Color(244, 164, 96));
        this.put("seagreen", new Color(46, 139, 87));
        this.put("seashell", new Color(255, 245, 238));
        this.put("sienna", new Color(160, 82, 45));
        this.put("skyblue", new Color(135, 206, 235));
        this.put("slateblue", new Color(106, 90, 205));
        this.put("slategray", new Color(112, 128, 144));
        this.put("slategrey", new Color(112, 128, 144));
        this.put("snow", new Color(255, 250, 250));
        this.put("springgreen", new Color(0, 255, 127));
        this.put("steelblue", new Color(70, 130, 180));
        this.put("tan", new Color(210, 180, 140));
        this.put("thistle", new Color(216, 191, 216));
        this.put("tomato", new Color(255, 99, 71));
        this.put("turquoise", new Color(64, 224, 208));
        this.put("violet", new Color(238, 130, 238));
        this.put("wheat", new Color(245, 222, 179));
        this.put("whitesmoke", new Color(245, 245, 245));
        this.put("yellowgreen", new Color(154, 205, 50));
    }

    public int getColorValueFromPercentage(float aPercentage) {
        if (aPercentage < 0.0f || 100.0f < aPercentage) {
            throw new IllegalStateException("Color percentage out of range");
        }
        float value = 255.0f * (aPercentage / 100.0f);
        return (int)(value + 0.5f);
    }

    public Color hslToRgb(float aHue, float aSaturation, float aLightness) {
        float h = aHue;
        h /= 360.0f;
        if (aSaturation < 0.0f || 100.0f < aSaturation || aLightness < 0.0f || 100.0f < aLightness) {
            throw new IllegalStateException("HSL value out of range");
        }
        float s = aSaturation;
        s /= 100.0f;
        float l = aLightness;
        l /= 100.0f;
        float[] color = new float[]{0.0f, 0.0f, 0.0f};
        if (aSaturation == 0.0f) {
            int e = (int)(255.0f * l + 0.5f);
            return new Color(e, e, e);
        }
        float m2 = 0.0f;
        if ((double)l < 0.5) {
            m2 = l * (1.0f + s);
        }
        if ((double)l >= 0.5) {
            m2 = l + s - l * s;
        }
        float m1 = 2.0f * l - m2;
        float[] tempRGB = new float[]{h + 0.33333334f, h, h - 0.33333334f};
        int i = 0;
        while (i < 3) {
            if (tempRGB[i] < 0.0f) {
                tempRGB[i] = tempRGB[i] + 1.0f;
            }
            if (tempRGB[i] > 1.0f) {
                tempRGB[i] = tempRGB[i] - 1.0f;
            }
            color[i] = 6.0f * tempRGB[i] < 1.0f ? m1 + (m2 - m1) * 6.0f * tempRGB[i] : (2.0f * tempRGB[i] < 1.0f ? m2 : (3.0f * tempRGB[i] < 2.0f ? m1 + (m2 - m1) * (0.6666667f - tempRGB[i]) * 6.0f : m1));
            ++i;
        }
        return new Color((int)(255.0f * color[0] + 0.5f), (int)(255.0f * color[1] + 0.5f), (int)(255.0f * color[2] + 0.5f));
    }
}

