/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.defrep.operations;

import com.nokia.tools.themeinstaller.defrep.operations.FileOperation;
import com.nokia.tools.themeinstaller.defrep.operations.FileOperationUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StoreOperation
extends FileOperation {
    private static final int READ_BUFFER_SIZE = 1024;
    private InputStream iStream;

    public StoreOperation(File aDestination, InputStream aStream) {
        this.iFile = aDestination;
        this.iStream = aStream;
    }

    public void run() {
        int error = -3;
        try {
            this.doStoreOperation();
            error = 0;
        }
        catch (IOException ioe) {
            error = -2;
        }
        super.finished(this.iFile, error);
    }

    private void doStoreOperation() throws IOException {
        if (this.iFile.exists()) {
            this.iFile.delete();
        }
        FileOperationUtils.createDirs(this.iFile);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.iFile);
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = this.iStream.read(buffer)) != -1) {
                output.write(buffer, 0, i);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }
}

