/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.installationmanager;

import com.nokia.tools.themeinstaller.defrep.IDefinitionRepository;
import com.nokia.tools.themeinstaller.defrep.operations.FileOperationEvent;
import com.nokia.tools.themeinstaller.defrep.operations.FileOperationUtils;
import com.nokia.tools.themeinstaller.installationmanager.IResourceInstaller;
import com.nokia.tools.themeinstaller.installationmanager.Lock;
import com.nokia.tools.themeinstaller.installationmanager.ManifestFactory;
import com.nokia.tools.themeinstaller.installationmanager.ThemeResource;
import com.nokia.tools.themeinstaller.mediaconverter.MediaConverter;
import com.nokia.tools.themeinstaller.odtconverter.MimeTypeResolver;
import com.nokia.tools.themeinstaller.odtconverter.ODTHeader;
import com.nokia.tools.themeinstaller.odtconverter.ODTResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class ResourceInstaller
implements IResourceInstaller {
    private static final String MBM_SUFFIX = "mbm";
    private static final char FILE_EXT_SEPARATOR = '.';
    private IDefinitionRepository iDefRep;
    private FileOperationEvent iEvent;
    private File iDestinationDir;
    private String iDataDir;
    private MediaConverter iMediaConverter;
    private MimeTypeResolver iMimeResolver;
    private Observer iFileCopyObserver;
    private Vector iTempFiles;
    private Lock iLock;

    public ResourceInstaller(IDefinitionRepository aDefRep, File aDestinationDir, String aDataDir) throws IOException {
        this.iDefRep = aDefRep;
        this.iDestinationDir = aDestinationDir;
        this.iDataDir = aDataDir;
        this.iMediaConverter = new MediaConverter();
        this.iMimeResolver = new MimeTypeResolver();
        this.iTempFiles = new Vector();
        this.iLock = new Lock();
        this.iFileCopyObserver = new Observer(){

            public void update(Observable aFileOperation, Object aEvent) {
                ResourceInstaller.this.iEvent = (FileOperationEvent)aEvent;
                ResourceInstaller.this.iLock.unLock();
            }
        };
    }

    public Vector installResources(Vector aResources, ODTHeader aHeader) throws IOException {
        Vector<ODTResource> result = new Vector<ODTResource>();
        Enumeration resources = aResources.elements();
        while (resources.hasMoreElements()) {
            result.add(this.installResource((ThemeResource)resources.nextElement(), aHeader));
        }
        return result;
    }

    public ODTResource installResource(ThemeResource aResource, ODTHeader aHeader) throws IOException {
        ODTResource res = this.createResource(this.iDataDir, aResource);
        File f = new File(String.valueOf(this.iDataDir) + (String)res.get("TempFileName"));
        this.iDefRep.copyResource(f, this.iDestinationDir, aHeader, this.iFileCopyObserver);
        this.iLock.lock();
        if (this.iEvent.getErrorCode() != 0) {
            throw new IOException("Resource file copying failed: " + f.getPath());
        }
        this.deleteTemporaryFile(this.iEvent.getFile().getName());
        res.put("FileName", this.iEvent.getDestPath());
        return res;
    }

    private void deleteTemporaryFile(String aFileName) throws IOException {
        Enumeration fileObjects = this.iTempFiles.elements();
        while (fileObjects.hasMoreElements()) {
            File temp = (File)fileObjects.nextElement();
            if (!temp.getName().equals(aFileName)) continue;
            if (!temp.delete()) {
                throw new IOException("Temporary file deletion failed: " + aFileName);
            }
            this.iTempFiles.remove(temp);
            this.deleteTemporaryFile(aFileName);
        }
    }

    public ODTResource createODTResource(ODTHeader aHeader, String aNameSpace) {
        ODTResource res = new ODTResource();
        String odtPath = null;
        odtPath = this.iDefRep.createODTPath(this.iDestinationDir, aHeader);
        odtPath = FileOperationUtils.parseSymbianFSPath(odtPath);
        res.put("FileName", odtPath);
        res.put("CacheType", new Integer(ManifestFactory.CACHE_TYPE_CACHE_FILE));
        int flags = (Integer)aHeader.get("Flags");
        if ((flags & 2) != 0) {
            res.put("LockingPolicy", new Integer(1));
        } else {
            res.put("LockingPolicy", new Integer(0));
        }
        res.put("MimeType", "unknown");
        res.put("NameSpace", aNameSpace);
        res.put("ResourceID", aHeader.get("ThemeShortName"));
        res.put("ResourceType", new Integer(2));
        return res;
    }

    private ODTResource createResource(String aDataDirectory, ThemeResource aItem) throws IOException {
        ODTResource res = new ODTResource();
        String tempFileName = null;
        String filename = aItem.getFileName();
        int cacheType = aItem.getCacheType();
        tempFileName = cacheType == ManifestFactory.CACHE_TYPE_CACHE_FILE || cacheType == ManifestFactory.CACHE_TYPE_CACHE_MEMORY ? this.convertMedia(String.valueOf(aDataDirectory) + filename) : filename;
        int fileNameIndex = tempFileName.lastIndexOf(File.separatorChar);
        if (fileNameIndex > -1) {
            tempFileName = tempFileName.substring(fileNameIndex + 1);
        }
        aItem.setResourceType(this.iMimeResolver.getResourceType(tempFileName));
        aItem.setMimeType(this.iMimeResolver.getMimeType(tempFileName));
        res.put("TempFileName", tempFileName);
        res.put("CacheType", new Integer(cacheType));
        res.put("ResourceID", filename);
        res.put("LockingPolicy", new Integer(aItem.getLockingPolicy()));
        res.put("NameSpace", aItem.getNameSpace());
        res.put("MimeType", aItem.getMimeType());
        res.put("ResourceType", new Integer(aItem.getResourceType()));
        return res;
    }

    private String convertMedia(String aFilename) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        files.add(aFilename);
        int dotPosition = aFilename.lastIndexOf(46) + 1;
        String destinationImage = String.valueOf(aFilename.substring(0, dotPosition)) + MBM_SUFFIX;
        if (dotPosition == 0) {
            destinationImage = String.valueOf(aFilename) + '.' + MBM_SUFFIX;
        }
        String filePrefix = destinationImage.substring(0, destinationImage.lastIndexOf(46));
        File destFile = new File(destinationImage);
        int index = 1;
        while (destFile.exists()) {
            destinationImage = String.valueOf(filePrefix) + index++ + '.' + MBM_SUFFIX;
            destFile = new File(destinationImage);
        }
        this.iMediaConverter.convertMedia(files, destinationImage);
        this.iTempFiles.add(destFile);
        return destinationImage;
    }
}

