/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.localisation;

import com.nokia.tools.themeinstaller.logger.LogWriter;
import com.nokia.tools.themeinstaller.odtconverter.ConverterProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DTDReader {
    private static final String ENTITY_REGEX = "<!ENTITY(\\s*)%s(.*)>";
    private static final String VALUE_REGEX = "(\")(.*)(\")";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String ENCODING_KEY = "dtd_encoding";

    public static String readFiles(Vector aDtdFiles, String aLocString) throws IOException {
        String tempResult = null;
        Vector<String> results = new Vector<String>();
        int i = 0;
        while (i < aDtdFiles.size()) {
            tempResult = DTDReader.readEntity((File)aDtdFiles.get(i), aLocString);
            if (tempResult != null) {
                results.add(tempResult);
            }
            ++i;
        }
        if (results.isEmpty()) {
            return null;
        }
        return (String)results.firstElement();
    }

    public static String readEntity(File aDTD, String aLocString) throws IOException {
        StringBuffer strbuf = new StringBuffer();
        String encoding = ConverterProperties.getInstance().getProperty(ENCODING_KEY);
        BufferedReader rdr = null;
        if (encoding != null) {
            rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aDTD), encoding));
        } else {
            LogWriter.getInstance().logWarning("DTDReader: Character encoding of DTD files is not specified in the properties file, using system default encoding.");
            rdr = new BufferedReader(new InputStreamReader(new FileInputStream(aDTD)));
        }
        String line = rdr.readLine();
        while (line != null) {
            strbuf.append(String.valueOf(line) + LINE_SEPARATOR);
            line = rdr.readLine();
        }
        Object[] formatArguments = new String[]{aLocString};
        String regex = String.format(ENTITY_REGEX, formatArguments);
        String result = DTDReader.findString(regex, strbuf.toString());
        if (result != null) {
            result = DTDReader.findString(VALUE_REGEX, result);
            result = result.replaceAll("\"", "");
        }
        return result;
    }

    private static String findString(String aRegex, String aSearchString) {
        String result = null;
        Pattern pattern = Pattern.compile(aRegex);
        Matcher matcher = pattern.matcher(aSearchString);
        int count = 0;
        while (matcher.find()) {
            result = matcher.group();
            ++count;
        }
        if (count > 1) {
            throw new IllegalArgumentException("DTD parsing: found more than one localized value for the entity");
        }
        return result;
    }
}

