/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.odtconverter;

import com.nokia.tools.themeinstaller.cssparser.CSSDOMProcessor;
import com.nokia.tools.themeinstaller.cssparser.PseudoClassResolver;
import com.nokia.tools.themeinstaller.odtconverter.ODTDataOutputStream;
import com.nokia.tools.themeinstaller.odtconverter.ODTException;
import com.nokia.tools.themeinstaller.odtconverter.PropertyValue;
import com.nokia.tools.themeinstaller.odtconverter.PropertyValueList;
import com.nokia.tools.themeinstaller.odtconverter.StringPool;
import com.nokia.tools.themeinstaller.odtconverter.ValueTypeResolver;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMExternalizer {
    private static final String TEXT_ELEMENT = "text";
    private static final String DESC_ELEMENT = "desc";
    private static final String MARQUEE_ELEMENT = "marquee";
    private static final String OBJECT_ELEMENT = "object";
    private static final String NEWSTICKER_ELEMENT = "newsticker";
    private static final String REF_NODE = "ref";
    private static final int UNKNOWN = -1;
    private static final int NODE = 0;
    private static final int ATTRIBUTE = 1;
    private static final int PROPERTY = 2;
    private static final int COLOR_TABLE_SIZE = 3;
    private PseudoClassResolver iPseudoResolver = new PseudoClassResolver();
    private ValueTypeResolver iValueTypeResolver = new ValueTypeResolver();
    private StringPool iStringPool;
    private Document iDocument;
    private ByteArrayOutputStream iBaos;
    private ODTDataOutputStream iODTDos;
    private int iCurrentNodeId = 0;
    private CSSDOMProcessor iCSSDOMProsessor = new CSSDOMProcessor();

    public DOMExternalizer(Document aDocument) {
        this.iStringPool = new StringPool();
        this.iDocument = aDocument;
        this.iBaos = new ByteArrayOutputStream();
        this.iODTDos = new ODTDataOutputStream(this.iBaos);
    }

    protected void finalize() throws Throwable {
        this.iODTDos.close();
        this.iBaos.close();
    }

    public byte[] getByteArray() throws IOException, ODTException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] resultArray = null;
        try {
            this.doExternalize();
            result.write(this.iStringPool.toByteArray());
            result.write(this.iBaos.toByteArray());
            resultArray = result.toByteArray();
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
        return resultArray;
    }

    private void doExternalize() throws IOException, ODTException {
        Element rootElement = this.iDocument.getDocumentElement();
        if (rootElement != null) {
            this.iODTDos.writeBoolean(true);
            this.externalizeNode(rootElement, true);
        } else {
            this.iODTDos.writeBoolean(false);
        }
    }

    private void externalizeNode(Node aNode, boolean aRootNode) throws IOException, ODTException {
        String name = aNode.getNodeName();
        int nameRef = this.iStringPool.addString(name);
        this.iODTDos.writeInt16(nameRef);
        String ns = aNode.getNamespaceURI();
        int nsRef = this.iStringPool.addString(ns);
        this.iODTDos.writeInt16(nsRef);
        this.iODTDos.writeBoolean(this.checkRefNode(aNode));
        boolean textNodeFound = false;
        StringBuffer pcData = new StringBuffer();
        if (TEXT_ELEMENT.equals(name) || DESC_ELEMENT.equals(name) || MARQUEE_ELEMENT.equals(name) || OBJECT_ELEMENT.equals(name) || NEWSTICKER_ELEMENT.equals(name)) {
            NodeList list = aNode.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node nod = list.item(i);
                if (nod.getNodeType() == 3) {
                    textNodeFound = true;
                    String textNodeValue = nod.getNodeValue();
                    pcData.append(textNodeValue);
                }
                ++i;
            }
        }
        this.iODTDos.writeBoolean(textNodeFound);
        if (textNodeFound) {
            this.iODTDos.writeInt16(pcData.length());
            this.iODTDos.writeString8(pcData.toString());
        }
        this.iODTDos.writeInt32(this.iCurrentNodeId++);
        this.externalizeNodeList(aNode);
        this.externalizeAttributeList(aNode);
        this.externalizePropertyList(aNode);
    }

    private boolean checkRefNode(Node aNode) {
        boolean refNode = false;
        NamedNodeMap list = aNode.getAttributes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (DOMExternalizer.nodeType(node) == 1 && node.getNodeName().equals(REF_NODE)) {
                refNode = true;
            }
            ++i;
        }
        return refNode;
    }

    private void externalizeAttributeNode(Node aNode) throws IOException, ODTException {
        String name = aNode.getNodeName();
        int nameRef = this.iStringPool.addString(name);
        this.iODTDos.writeInt16(nameRef);
        String value = aNode.getNodeValue();
        int valueRef = this.iStringPool.addString(value);
        this.iODTDos.writeInt16(valueRef);
    }

    private void externalizePropertyNode(Node aParentNode, Node aNode) throws IOException, ODTException {
        NamedNodeMap list = aNode.getAttributes();
        boolean isInherited = this.externalizePropertyValueList(aParentNode, list);
        this.iODTDos.writeBoolean(isInherited);
        int pseudoClass = 0;
        int count = list.getLength();
        int i = 0;
        while (i < count) {
            Node item = list.item(i);
            if (item.getNodeName().equals("pseudoclass")) {
                pseudoClass = this.iPseudoResolver.getKey(item.getNodeValue());
                if (pseudoClass != -1) break;
                throw new ODTException("Error externalizing ODT/styles: unknown pseudo class");
            }
            ++i;
        }
        this.iODTDos.writeByte(pseudoClass);
    }

    private void externalizeNodeList(Node aParentNode) throws IOException, ODTException {
        this.iODTDos.writeByte(0);
        NodeList list = aParentNode.getChildNodes();
        int count = DOMExternalizer.countNodes(list);
        this.iODTDos.writeInt32(count);
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (DOMExternalizer.nodeType(node) == 0) {
                this.externalizeNode(node, false);
            }
            ++i;
        }
    }

    private void externalizeAttributeList(Node aParentNode) throws IOException, ODTException {
        this.iODTDos.writeByte(1);
        NamedNodeMap list = aParentNode.getAttributes();
        int count = DOMExternalizer.countAttributes(list);
        this.iODTDos.writeInt32(count);
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (DOMExternalizer.nodeType(node) == 1) {
                this.externalizeAttributeNode(node);
            }
            ++i;
        }
    }

    private void externalizePropertyList(Node aParentNode) throws IOException, ODTException {
        this.iODTDos.writeByte(2);
        NodeList list = aParentNode.getChildNodes();
        int count = DOMExternalizer.countProperties(list);
        this.iODTDos.writeInt32(count);
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (DOMExternalizer.nodeType(node) == 2) {
                this.externalizePropertyNode(aParentNode, node);
            }
            ++i;
        }
    }

    private Color parseColorFromString(String aColor) throws ODTException {
        String[] sx = aColor.split(",");
        int[] ix = new int[sx.length];
        if (sx.length != 3) {
            throw new ODTException("Error in DOM/style data externalization: RGB Values: parameter amount");
        }
        int i = 0;
        while (i < sx.length) {
            if (sx[i].contains("|")) {
                Short valueType = this.iValueTypeResolver.getValue(Short.valueOf(sx[i].substring(0, sx[i].indexOf("|"))));
                if (valueType.intValue() != 1) {
                    throw new ODTException("Error in DOM/style data externalization: RGB Values: R, G or B not interger");
                }
            } else {
                throw new ODTException("Error in DOM/style data externalization: RGB Values: can't resolve value type");
            }
            String redGreenBlue = sx[i].substring(sx[i].indexOf("|") + 1, sx[i].length());
            Integer rgbValue = Integer.valueOf(redGreenBlue);
            ix[i] = rgbValue;
            ++i;
        }
        return new Color(ix[0], ix[1], ix[2]);
    }

    private String parseAttrValue(String aAttrValue, PropertyValue aPropValue) throws IOException, ODTException {
        if (aAttrValue.length() > 0) {
            if (aAttrValue.contains("|")) {
                String type = aAttrValue.substring(0, aAttrValue.indexOf(124));
                String value = aAttrValue.substring(aAttrValue.indexOf(124) + 1, aAttrValue.length());
                Short lexicalUnit = Short.valueOf(type);
                Short primitiveValueType = this.iValueTypeResolver.getValue(lexicalUnit);
                switch (primitiveValueType.intValue()) {
                    case 1: {
                        double doubleValueInteger = Double.valueOf(value);
                        aPropValue.setRealValue(doubleValueInteger, primitiveValueType);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 28: {
                        double doubleValuePercentage = Double.valueOf(value);
                        aPropValue.setRealValue(doubleValuePercentage, primitiveValueType);
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        aPropValue.setString(new String(value), primitiveValueType);
                        break;
                    }
                    case 25: {
                        Color color = this.parseColorFromString(value);
                        aPropValue.setRgbValue(color);
                        break;
                    }
                }
                return value;
            }
            return aAttrValue;
        }
        return aAttrValue;
    }

    private boolean externalizePropertyValueList(Node aNode, NamedNodeMap aAttrList) throws IOException, ODTException {
        PropertyValueList valueList = new PropertyValueList(this.iStringPool);
        boolean isInherited = false;
        String name = null;
        String value = null;
        int i = 0;
        while (i < aAttrList.getLength()) {
            Node node = aAttrList.item(i);
            if (DOMExternalizer.nodeType(node) == 1 && !node.getNodeName().equals("pseudoclass")) {
                String attrName = node.getNodeName();
                String attrValue = node.getNodeValue();
                if (attrName.equals("name") && name == null) {
                    name = attrValue;
                } else if (attrName.startsWith("value")) {
                    value = attrValue;
                    isInherited = this.iCSSDOMProsessor.canInherit((Element)aNode, name, value);
                    PropertyValue propValue = valueList.newItem();
                    this.parseAttrValue(value, propValue);
                } else {
                    throw new ODTException("Error in DOM/style data externalization: Property values");
                }
            }
            ++i;
        }
        if (name == null || value == null) {
            throw new ODTException("Error in DOM/style data externalization: Property values");
        }
        int nameRef = this.iStringPool.addString(name);
        this.iODTDos.writeInt16(nameRef);
        valueList.externalize(this.iODTDos);
        return isInherited;
    }

    private static int countNodes(NodeList aList) {
        int count = 0;
        int i = 0;
        while (i < aList.getLength()) {
            if (DOMExternalizer.nodeType(aList.item(i)) == 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static int countAttributes(NamedNodeMap aList) {
        int count = 0;
        int i = 0;
        while (i < aList.getLength()) {
            if (DOMExternalizer.nodeType(aList.item(i)) == 1) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static int countProperties(NodeList aList) {
        int count = 0;
        int i = 0;
        while (i < aList.getLength()) {
            if (DOMExternalizer.nodeType(aList.item(i)) == 2) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static int nodeType(Node aItem) {
        int type = -1;
        if (aItem.getNodeType() == 1 && !aItem.getNodeName().equals("styleproperty")) {
            type = 0;
        } else if (aItem.getNodeType() == 2) {
            type = 1;
        } else if (aItem.getNodeType() == 1 && aItem.getNodeName().equals("styleproperty")) {
            type = 2;
        }
        return type;
    }
}

