/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.odtconverter;

import com.nokia.tools.themeinstaller.odtconverter.ODTDataOutputStream;
import com.nokia.tools.themeinstaller.odtconverter.ODTException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

public class StringPool {
    private Vector iStringPool = new Vector();

    public int addString(String aString) {
        if (aString == null) {
            aString = "";
        }
        if (!this.iStringPool.contains(aString)) {
            this.iStringPool.addElement(aString);
        }
        return this.iStringPool.lastIndexOf(aString);
    }

    public String getString(int aIndex) {
        return (String)this.iStringPool.elementAt(aIndex);
    }

    public byte[] toByteArray() throws IOException, ODTException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ODTDataOutputStream dos = new ODTDataOutputStream(baos);
        int count = this.iStringPool.size();
        byte[] result = null;
        try {
            dos.writeInt16(count);
            int i = 0;
            while (i < count) {
                String string = (String)this.iStringPool.elementAt(i);
                dos.writeInt16(string.length());
                dos.writeString8(string);
                ++i;
            }
            result = baos.toByteArray();
        }
        finally {
            if (dos != null) {
                dos.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return result;
    }
}

