/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.cssparser;

import com.nokia.tools.themeinstaller.cssparser.CSSRule;
import com.nokia.tools.themeinstaller.cssparser.CSSSpecificity;
import com.nokia.tools.themeinstaller.cssparser.PseudoClassResolver;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CSSMatchMaker {
    private static final String STRING_CLASS = "class";
    private static final String STRING_ID = "id";
    private static final String STRING_SPACE = " ";
    private PseudoClassResolver iPseudoClassResolver = new PseudoClassResolver();

    public boolean match(CSSRule aRule, Element aElement) {
        aRule.resetSpecificity();
        return this.match(aRule.getSelector(), aRule.getSpecificity(), aElement);
    }

    private boolean match(Selector aSelector, CSSSpecificity aSpecificity, Element aElement) {
        switch (aSelector.getSelectorType()) {
            case 4: {
                ElementSelector eSelector = (ElementSelector)aSelector;
                String name = eSelector.getLocalName();
                if (name == null || name.equals(aElement.getLocalName())) {
                    aSpecificity.incElement();
                    return true;
                }
                return false;
            }
            case 0: {
                ConditionalSelector cSelector = (ConditionalSelector)aSelector;
                if (!this.match((Selector)cSelector.getSimpleSelector(), aSpecificity, aElement)) {
                    return false;
                }
                return this.matchCondition(cSelector.getCondition(), aSpecificity, aElement);
            }
            case 11: {
                DescendantSelector dSelector = (DescendantSelector)aSelector;
                if (!this.match((Selector)dSelector.getSimpleSelector(), aSpecificity, aElement)) {
                    return false;
                }
                return this.match(dSelector.getAncestorSelector(), aSpecificity, (Element)aElement.getParentNode());
            }
            case 10: {
                DescendantSelector dSelector = (DescendantSelector)aSelector;
                if (!this.match((Selector)dSelector.getSimpleSelector(), aSpecificity, aElement)) {
                    return false;
                }
                Node ancestor = aElement;
                while ((ancestor = ancestor.getParentNode()) != null) {
                    if (ancestor.getNodeType() != 1 || !this.match(dSelector.getAncestorSelector(), aSpecificity, (Element)ancestor)) continue;
                    return true;
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                throw new CSSException("Selector : " + aSelector.getSelectorType() + " not supported");
            }
        }
        throw new CSSException("Unknown selector : " + aSelector.getSelectorType());
    }

    private boolean matchCondition(Condition aCondition, CSSSpecificity aSpecificity, Element aElement) {
        switch (aCondition.getConditionType()) {
            case 5: {
                AttributeCondition idCondition = (AttributeCondition)aCondition;
                String idAttribute = aElement.getAttribute(STRING_ID);
                String[] idTexts = idAttribute.split(STRING_SPACE);
                int i = 0;
                while (i < idTexts.length) {
                    String idText = idTexts[i];
                    if (idAttribute != null && idText.equals(idCondition.getValue())) {
                        aSpecificity.incID();
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 9: {
                AttributeCondition classCondition = (AttributeCondition)aCondition;
                String classAttribute = aElement.getAttribute(STRING_CLASS);
                String[] classTexts = classAttribute.split(STRING_SPACE);
                int i = 0;
                while (i < classTexts.length) {
                    String classText = classTexts[i];
                    if (classAttribute != null && classText.equals(classCondition.getValue())) {
                        aSpecificity.incAttribute();
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 0: {
                CombinatorCondition combCondition = (CombinatorCondition)aCondition;
                return this.matchCondition(combCondition.getFirstCondition(), aSpecificity, aElement) && this.matchCondition(combCondition.getSecondCondition(), aSpecificity, aElement);
            }
            case 10: {
                Collection pseudoTypes = this.iPseudoClassResolver.getPseudoTypes();
                Iterator it = pseudoTypes.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(aCondition.toString().substring(1))) continue;
                    aSpecificity.incAttribute();
                    return true;
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                throw new CSSException("condition : " + aCondition.getConditionType() + " not supported");
            }
        }
        throw new CSSException("Unknown condition : " + aCondition.getConditionType());
    }
}

