/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.odtconverter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class ConverterProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_FILE = "data" + File.separatorChar + "ThemeInstaller.prop";
    private static ConverterProperties sInstance = null;
    private static String sPropFileName = null;

    public ConverterProperties() throws IOException {
        URL resource = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        File bin = new File(resource.getPath());
        this.loadProperties(new File(String.valueOf(bin.getParent()) + File.separatorChar + PROPERTY_FILE));
    }

    public ConverterProperties(File aFile) throws IOException {
        this.loadProperties(aFile);
    }

    public ConverterProperties(Properties aDefaults) throws IOException {
        super(aDefaults);
        this.loadProperties(new File(PROPERTY_FILE));
    }

    protected void loadProperties(File aFile) throws IOException {
        FileInputStream file = null;
        try {
            file = new FileInputStream(aFile);
            this.load(file);
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    public static ConverterProperties getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("Converter Properties: Initialize must be called before the properties can be used");
        }
        return sInstance;
    }

    public static void initialize(File aPropFile) throws IOException {
        if (sInstance != null && (sPropFileName != null && aPropFile != null && sPropFileName.equals(aPropFile.getPath()) || sPropFileName == null && aPropFile == null)) {
            return;
        }
        if (aPropFile == null) {
            sInstance = new ConverterProperties();
            sPropFileName = null;
        } else {
            sInstance = new ConverterProperties(aPropFile);
            sPropFileName = aPropFile.getPath();
        }
    }
}

