/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.odtconverter;

import com.nokia.tools.themeinstaller.odtconverter.ODTDataOutputStream;
import com.nokia.tools.themeinstaller.odtconverter.ODTException;
import com.nokia.tools.themeinstaller.odtconverter.StringPool;
import java.awt.Color;
import java.io.IOException;

public class PropertyValue {
    public static final String STRING_AUTO = "auto";
    public static final String STRING_NONE = "none";
    public static final String STRING_INHERIT = "inherit";
    public static final int E_NOT_SET = 0;
    public static final int E_AUTO = 1;
    public static final int E_NONE = 2;
    public static final int E_INHERIT = 3;
    private Short iValueType;
    private int iIdentType;
    private Color iRgbValue;
    private double iRealValue;
    private int iStringRef;
    private StringPool iStringPool;

    public PropertyValue(StringPool aStringPool) {
        this.iStringPool = aStringPool;
    }

    public void setRgbValue(Color aRgbValue) throws ODTException {
        this.iRgbValue = aRgbValue;
        this.iValueType = new Short(25);
    }

    public void setRealValue(double aRealValue, short aValueType) throws ODTException {
        switch (aValueType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: {
                break;
            }
            default: {
                throw new ODTException("Property value type is not compatible with real: " + aValueType);
            }
        }
        this.iRealValue = aRealValue;
        this.iValueType = new Short(aValueType);
    }

    public void setString(String aString, short aValueType) throws ODTException {
        switch (aValueType) {
            case 0: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new ODTException("Property value type is not compatible with string: " + aValueType);
            }
        }
        this.iStringRef = this.iStringPool.addString(aString);
        this.iIdentType = aString.equals(STRING_AUTO) ? 1 : (aString.equals(STRING_INHERIT) ? 3 : (aString.equals(STRING_NONE) ? 2 : 0));
        this.iValueType = new Short(aValueType);
    }

    public void externalize(ODTDataOutputStream aStream) throws IOException, ODTException {
        aStream.writeByte(this.iValueType.byteValue());
        switch (this.iValueType.intValue()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: {
                aStream.writeTReal64(this.iRealValue);
                break;
            }
            case 0: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                aStream.writeInt16(this.iStringRef);
                aStream.writeByte(this.iIdentType);
                break;
            }
            case 25: {
                aStream.writeByte(this.iRgbValue.getRed());
                aStream.writeByte(this.iRgbValue.getGreen());
                aStream.writeByte(this.iRgbValue.getBlue());
                break;
            }
            default: {
                throw new ODTException("Property value can not be resolved: " + this.iValueType);
            }
        }
    }
}

