/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.logger;

import com.nokia.tools.themeinstaller.logger.LogFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogWriter {
    private static Logger iLogger = Logger.getLogger(LogWriter.class.getName());
    private static LogWriter sInstance = null;
    private static String sLogFileName = null;
    private static final String LOG_FILENAME = "ThemeInstaller";
    private static final String UNDERLINE_CHARACTER = "_";
    private static final String LOG_FILENAME_EXTENSION = ".log";
    private static final String DATE_FORMAT = "yyyyMMdd_HHmmssSS";

    private LogWriter(Level aLevel) {
        iLogger.setLevel(aLevel);
        if (aLevel == Level.OFF) {
            return;
        }
        iLogger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new LogFormatter());
        iLogger.addHandler(consoleHandler);
    }

    private LogWriter(File aDir, Level aLevel) {
        try {
            iLogger.setLevel(aLevel);
            if (aLevel == Level.OFF) {
                return;
            }
            iLogger.setUseParentHandlers(false);
            String filename = this.validateDir(aDir);
            FileHandler fileHandler = new FileHandler(filename);
            fileHandler.setFormatter(new LogFormatter());
            iLogger.addHandler(fileHandler);
        }
        catch (IOException e) {
            iLogger.log(Level.SEVERE, "Unable to create logging file.", e);
        }
    }

    public Level getLevel() {
        return iLogger.getLevel();
    }

    private static void closeFile() {
        if (iLogger.getHandlers().length > 0 && iLogger.getHandlers()[0] instanceof FileHandler) {
            iLogger.getHandlers()[0].close();
        }
    }

    private String validateDir(File aDir) {
        if (aDir.isFile()) {
            throw new IllegalArgumentException("Invalid log file path. Not a directory: " + aDir);
        }
        if (!aDir.exists()) {
            aDir.mkdirs();
        }
        return aDir + File.separator + LOG_FILENAME + UNDERLINE_CHARACTER + LogFormatter.dateToString(DATE_FORMAT, System.currentTimeMillis()) + LOG_FILENAME_EXTENSION;
    }

    public void setLevel(int aLevel) {
        if (aLevel < 0 || 7 < aLevel) {
            throw new IllegalStateException("Trying to set invalid logging level");
        }
        switch (aLevel) {
            case 0: {
                iLogger.setLevel(Level.ALL);
                break;
            }
            case 1: {
                iLogger.setLevel(Level.FINEST);
                break;
            }
            case 2: {
                iLogger.setLevel(Level.FINER);
                break;
            }
            case 3: {
                iLogger.setLevel(Level.FINE);
                break;
            }
            case 4: {
                iLogger.setLevel(Level.CONFIG);
                break;
            }
            case 5: {
                iLogger.setLevel(Level.INFO);
                break;
            }
            case 6: {
                iLogger.setLevel(Level.WARNING);
                break;
            }
            case 7: {
                iLogger.setLevel(Level.SEVERE);
                break;
            }
        }
    }

    public boolean inConsoleMode() {
        return iLogger.getHandlers().length > 0 && iLogger.getHandlers()[0] instanceof ConsoleHandler;
    }

    public void logSevere(String aMessage) {
        iLogger.log(Level.SEVERE, aMessage);
    }

    public void logWarning(String aMessage) {
        iLogger.log(Level.WARNING, aMessage);
    }

    public void logInfo(String aMessage) {
        iLogger.log(Level.INFO, aMessage);
    }

    public void logConfig(String aMessage) {
        iLogger.log(Level.CONFIG, aMessage);
    }

    public void logFine(String aMessage) {
        iLogger.log(Level.FINE, aMessage);
    }

    public static synchronized void closeInstance() {
        LogWriter.closeFile();
        sInstance = null;
    }

    public static synchronized LogWriter getInstance() {
        if (sInstance == null) {
            sInstance = new LogWriter(Level.OFF);
        }
        return sInstance;
    }

    public static void initialize(File aDir) throws IOException {
        if (sInstance != null && (sLogFileName != null && aDir != null && sLogFileName.equals(aDir.getPath()) || sLogFileName == null && aDir == null)) {
            return;
        }
        if (aDir == null) {
            sInstance = new LogWriter(Level.ALL);
            sLogFileName = null;
        } else {
            sInstance = new LogWriter(aDir, Level.ALL);
            sLogFileName = aDir.getPath();
        }
    }
}

