/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.localisation;

import com.nokia.tools.themeinstaller.defrep.DefinitionRepository;
import com.nokia.tools.themeinstaller.defrep.operations.FileOperationEvent;
import com.nokia.tools.themeinstaller.installationmanager.Lock;
import com.nokia.tools.themeinstaller.localisation.DTDComposer;
import com.nokia.tools.themeinstaller.localisation.DTDReader;
import com.nokia.tools.themeinstaller.localisation.FileSearch;
import com.nokia.tools.themeinstaller.localisation.ILocalisation;
import com.nokia.tools.themeinstaller.localisation.IncludeSetting;
import com.nokia.tools.themeinstaller.localisation.Settings;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class Localisation
implements ILocalisation {
    private static String COMPOSED_DTD_FILE = "composed";
    private static String DTD_FILE_EXTENSION = ".dtd";
    private Settings iSettings;
    private Observer iCopyObserver;
    private Lock iCopyLock;
    private FileOperationEvent iCopyEvent;
    private DefinitionRepository iDefRep;

    public Localisation(Settings aSettings) {
        this.iSettings = aSettings;
        this.iDefRep = DefinitionRepository.getInstance();
        this.iCopyLock = new Lock();
        this.iCopyObserver = new Observer(){

            public void update(Observable aFileOperation, Object aEvent) {
                Localisation.this.iCopyEvent = (FileOperationEvent)aEvent;
                Localisation.this.iCopyLock.unLock();
            }
        };
    }

    public Settings getSettings() {
        return this.iSettings;
    }

    public File composeDTD(String aFileName, int aLanguage) throws IOException {
        File composed = File.createTempFile(COMPOSED_DTD_FILE, DTD_FILE_EXTENSION);
        composed.deleteOnExit();
        this.copyDTDContents(this.findDTD(aFileName), composed, false);
        Enumeration includes = this.iSettings.getIncludes().elements();
        IncludeSetting incl = null;
        Enumeration inclEntities = null;
        File inclFile = null;
        String entity = null;
        String locString = null;
        String filename = null;
        Hashtable<String, String> entities = new Hashtable<String, String>();
        Object[] formatArgs = new Integer[]{new Integer(aLanguage)};
        while (includes.hasMoreElements()) {
            incl = (IncludeSetting)includes.nextElement();
            filename = String.format(incl.getFile(), formatArgs);
            inclFile = FileSearch.findFile(incl.getSearchTree(), filename, true);
            if (incl.isIncludeAll()) {
                this.copyDTDContents(inclFile, composed, true);
                continue;
            }
            inclEntities = incl.getEntities().elements();
            while (inclEntities.hasMoreElements()) {
                entity = (String)inclEntities.nextElement();
                locString = DTDReader.readEntity(inclFile, entity);
                entities.put(entity, locString);
            }
        }
        return DTDComposer.writeEntitiesToDtd(composed, entities, true);
    }

    public File findDTD(String aFileName) throws IOException {
        Vector searchTree = this.iSettings.getSearchTree();
        return FileSearch.findFile(searchTree, aFileName, true);
    }

    private void copyDTDContents(File aSource, File aDestination, boolean aAppend) throws IOException {
        this.iDefRep.copy(aSource, aDestination, aAppend, this.iCopyObserver);
        this.iCopyLock.lock();
        if (this.iCopyEvent.getErrorCode() != 0) {
            throw new IOException("Localisation: DTD contents copy failed: " + this.iCopyEvent.getErrorCode() + ", File: " + this.iCopyEvent.getFile().getPath());
        }
    }
}

