/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.installationmanager;

import com.nokia.tools.themeinstaller.defrep.DefinitionRepository;
import com.nokia.tools.themeinstaller.defrep.IDefinitionRepository;
import com.nokia.tools.themeinstaller.defrep.operations.FileOperation;
import com.nokia.tools.themeinstaller.defrep.operations.FileOperationEvent;
import com.nokia.tools.themeinstaller.installationmanager.IInstallationListener;
import com.nokia.tools.themeinstaller.installationmanager.IResourceInstaller;
import com.nokia.tools.themeinstaller.installationmanager.IThemeManifest;
import com.nokia.tools.themeinstaller.installationmanager.InstallationList;
import com.nokia.tools.themeinstaller.installationmanager.InstallationParameters;
import com.nokia.tools.themeinstaller.installationmanager.LanguageInstallEvent;
import com.nokia.tools.themeinstaller.installationmanager.LanguageInstaller;
import com.nokia.tools.themeinstaller.installationmanager.LanguageSpecificData;
import com.nokia.tools.themeinstaller.installationmanager.Lock;
import com.nokia.tools.themeinstaller.installationmanager.ManifestFactory;
import com.nokia.tools.themeinstaller.installationmanager.ProgressEvent;
import com.nokia.tools.themeinstaller.installationmanager.ResourceInstaller;
import com.nokia.tools.themeinstaller.odtconverter.ConverterProperties;
import com.nokia.tools.themeinstaller.odtconverter.ODTDocument;
import com.nokia.tools.themeinstaller.odtconverter.ODTHeader;
import com.nokia.tools.themeinstaller.odtconverter.ODTInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class InstallationManager
implements Observer,
IInstallationListener {
    protected static final String MANIFEST_SUFFIX = ".dat";
    private File iManifest;
    private File iDestinationDir;
    private IDefinitionRepository iDefRep;
    private String iDataDir;
    private IInstallationListener iListener;
    private IResourceInstaller iResourceInstaller;
    private InstallationList iList;
    private Lock iLock;
    private Lock iMultiThemeLock;
    private File iLocSettings;

    public InstallationManager(InstallationParameters aParams, IInstallationListener aListener) throws IOException {
        ConverterProperties.initialize(aParams.getPropFile());
        this.iManifest = aParams.getManifest();
        this.iLocSettings = aParams.getLocSettings();
        this.iDestinationDir = aParams.getDestinationDir();
        this.iListener = aListener;
        if (!this.iDestinationDir.exists()) {
            this.iDestinationDir.mkdirs();
        }
        this.iDefRep = DefinitionRepository.getInstance();
        this.iDataDir = this.iManifest.getParent() == null ? "." + File.separatorChar : String.valueOf(this.iManifest.getParent()) + File.separatorChar;
        this.iResourceInstaller = new ResourceInstaller(this.iDefRep, this.iDestinationDir, this.iDataDir);
        this.iList = new InstallationList();
        this.iLock = new Lock();
        this.iMultiThemeLock = new Lock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startInstallation() throws IOException {
        if (this.iManifest.isDirectory()) {
            Enumeration manifests = this.searchManifests(this.iManifest).elements();
            if (!manifests.hasMoreElements()) throw new IllegalArgumentException("Manifest files not found from: " + this.iManifest.getPath());
            this.installMultiTheme(manifests);
            return;
        } else {
            ManifestFactory factory = new ManifestFactory(this.iLocSettings);
            IThemeManifest manifest = factory.createManifest(this.iManifest);
            Enumeration manifests = manifest.getManifestFiles().elements();
            if (manifests.hasMoreElements()) {
                this.installMultiTheme(manifests);
                return;
            } else {
                this.installTheme(manifest, this.iLocSettings);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(Observable aObservable, Object aEvent) {
        if (aObservable instanceof LanguageInstaller) {
            this.iLock.unLock();
            LanguageInstallEvent event = (LanguageInstallEvent)aEvent;
            ODTHeader header = event.getODTDocument().getODTHeader();
            ProgressEvent pe = new ProgressEvent();
            pe.setState(1);
            pe.setName((String)header.get("ThemeShortName"));
            pe.setLanguage((Integer)header.get("Language"));
            pe.setError(event.getErrorCode(), event.getReason());
            this.iListener.installationProgress(pe);
            if (event.getErrorCode() == 0) {
                InputStream in = null;
                try {
                    try {
                        ODTDocument document = event.getODTDocument();
                        in = new ODTInputStream(document);
                        this.iDefRep.storeODT(this.iDestinationDir, document.getODTHeader(), in, this);
                        return;
                    }
                    catch (Exception e) {
                        pe.setError(-1, e.toString());
                        this.iListener.installationCompleted(pe);
                        if (in == null) return;
                        try {
                            in.close();
                            return;
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            pe.setError(event.getErrorCode(), event.getReason());
            this.iListener.installationCompleted(pe);
            return;
        }
        if (!(aObservable instanceof FileOperation)) return;
        FileOperationEvent event = (FileOperationEvent)aEvent;
        ProgressEvent pe = new ProgressEvent();
        pe.setState(2);
        pe.setFileName(event.getFullDestPath());
        pe.setError(event.getErrorCode(), null);
        if (event.getErrorCode() == 0) {
            pe.setFileName(event.getFullDestPath());
            this.iListener.installationProgress(pe);
        } else {
            pe.setError(event.getErrorCode(), null);
            this.iListener.installationCompleted(pe);
        }
        this.iList.removeInstall(event.getDestPath());
        if (this.iList.installsExist()) return;
        pe.setError(event.getErrorCode(), null);
        this.iListener.installationCompleted(pe);
    }

    public void installationProgress(ProgressEvent aEvent) {
        this.iListener.installationProgress(aEvent);
    }

    public void installationCompleted(ProgressEvent aEvent) {
        this.iListener.installationCompleted(aEvent);
        this.iMultiThemeLock.unLock();
    }

    private void installTheme(IThemeManifest aManifest, File aLocSettings) throws IOException {
        ODTHeader unlocalizedHeader = LanguageInstaller.createHeader(aManifest, null);
        Vector resources = aManifest.getResources();
        Vector odtResources = this.iResourceInstaller.installResources(resources, unlocalizedHeader);
        Enumeration languages = aManifest.getLanguages().elements();
        while (languages.hasMoreElements()) {
            LanguageSpecificData language = (LanguageSpecificData)languages.nextElement();
            LanguageInstaller installer = new LanguageInstaller(this, aManifest, language, aLocSettings, this.iResourceInstaller);
            this.iList.addInstall(language.getLanguageId());
            installer.addResources(odtResources);
            try {
                installer.install();
                this.iLock.lock();
            }
            catch (Exception e) {
                ProgressEvent pe = new ProgressEvent();
                pe.setName(aManifest.getThemeShortName());
                pe.setLanguage(language.getLanguageId());
                pe.setError(-1, e.toString());
                this.iListener.installationCompleted(pe);
            }
        }
    }

    private void installMultiTheme(Enumeration aManifests) {
        while (aManifests.hasMoreElements()) {
            File f = (File)aManifests.nextElement();
            try {
                InstallationParameters params = new InstallationParameters(f, this.iDestinationDir);
                params.setLocSettings(this.iLocSettings);
                InstallationManager i = new InstallationManager(params, this);
                i.startInstallation();
                this.iMultiThemeLock.lock();
            }
            catch (Exception e) {
                ProgressEvent pe = new ProgressEvent();
                pe.setFileName(f.getPath());
                pe.setError(-1, "Sub theme installation failed: " + e.toString());
                this.iListener.installationCompleted(pe);
            }
        }
    }

    private Vector searchManifests(File aLocation) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File aDir, String aName) {
                return aName.endsWith(InstallationManager.MANIFEST_SUFFIX);
            }
        };
        File[] files = aLocation.listFiles(filter);
        Vector<File> v = new Vector<File>();
        int i = 0;
        while (i < files.length) {
            v.add(files[i]);
            ++i;
        }
        return v;
    }
}

